/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.function.Predicates;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.DatabaseHistoryException;
import io.debezium.relational.history.DatabaseHistoryListener;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.JsonTableChangeSerializer;
import io.debezium.relational.history.TableChanges;
import io.debezium.text.MultipleParsingExceptions;
import io.debezium.text.ParsingException;
import io.debezium.util.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseHistory
implements DatabaseHistory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final Field INTERNAL_PREFER_DDL = Field.create("database.history.prefer.ddl").withDisplayName("Prefer DDL for schema recovery").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Prefer DDL for schema recovery in case logical schema is present").withInvisibleRecommender().withNoValidation();
    protected Configuration config;
    private HistoryRecordComparator comparator = HistoryRecordComparator.INSTANCE;
    private boolean skipUnparseableDDL;
    private boolean storeOnlyCapturedTablesDdl;
    private Function<String, Optional<Pattern>> ddlFilter = x -> Optional.empty();
    private DatabaseHistoryListener listener = DatabaseHistoryListener.NOOP;
    private boolean useCatalogBeforeSchema;
    private boolean preferDdl = false;
    private TableChanges.TableChangesSerializer<Array> tableChangesSerializer = new JsonTableChangeSerializer();

    protected AbstractDatabaseHistory() {
    }

    @Override
    public void configure(Configuration config, HistoryRecordComparator comparator, DatabaseHistoryListener listener, boolean useCatalogBeforeSchema) {
        this.config = config;
        this.comparator = comparator != null ? comparator : HistoryRecordComparator.INSTANCE;
        this.skipUnparseableDDL = config.getBoolean(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS);
        this.storeOnlyCapturedTablesDdl = Boolean.valueOf(config.getString(DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL));
        String ddlFilter = config.getString(DatabaseHistory.DDL_FILTER);
        this.ddlFilter = ddlFilter != null ? Predicates.matchedBy(ddlFilter) : this.ddlFilter;
        this.listener = listener;
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
        this.preferDdl = config.getBoolean(INTERNAL_PREFER_DDL);
    }

    @Override
    public void start() {
        this.listener.started();
    }

    @Override
    public final void record(Map<String, ?> source, Map<String, ?> position, String databaseName, String ddl) throws DatabaseHistoryException {
        this.record(source, position, databaseName, null, ddl, null, Clock.SYSTEM.currentTimeAsInstant());
    }

    @Override
    public final void record(Map<String, ?> source, Map<String, ?> position, String databaseName, String schemaName, String ddl, TableChanges changes, Instant timestamp) throws DatabaseHistoryException {
        HistoryRecord record = new HistoryRecord(source, position, databaseName, schemaName, ddl, changes, timestamp);
        this.storeRecord(record);
        this.listener.onChangeApplied(record);
    }

    @Override
    public void recover(Map<Map<String, ?>, Map<String, ?>> offsets, Tables schema, DdlParser ddlParser) {
        this.listener.recoveryStarted();
        HashMap stopPoints = new HashMap();
        offsets.forEach((source, position) -> {
            Document srcDocument = Document.create();
            if (source != null) {
                source.forEach(srcDocument::set);
            }
            stopPoints.put(srcDocument, new HistoryRecord((Map<String, ?>)source, (Map<String, ?>)position, null, null, null, null, null));
        });
        this.recoverRecords(recovered -> {
            this.listener.onChangeFromHistory((HistoryRecord)recovered);
            Document srcDocument = recovered.document().getDocument("source");
            if (stopPoints.containsKey(srcDocument) && this.comparator.isAtOrBefore((HistoryRecord)recovered, (HistoryRecord)stopPoints.get(srcDocument))) {
                Array tableChanges = recovered.tableChanges();
                String ddl = recovered.ddl();
                if (!this.preferDdl && tableChanges != null && !tableChanges.isEmpty()) {
                    TableChanges changes = this.tableChangesSerializer.deserialize(tableChanges, this.useCatalogBeforeSchema);
                    for (TableChanges.TableChange entry : changes) {
                        if (entry.getType() == TableChanges.TableChangeType.CREATE || entry.getType() == TableChanges.TableChangeType.ALTER) {
                            schema.overwriteTable(entry.getTable());
                            continue;
                        }
                        schema.removeTable(entry.getId());
                    }
                    this.listener.onChangeApplied((HistoryRecord)recovered);
                } else if (ddl != null && ddlParser != null) {
                    Optional<Pattern> filteredBy;
                    if (recovered.databaseName() != null) {
                        ddlParser.setCurrentDatabase(recovered.databaseName());
                    }
                    if (recovered.schemaName() != null) {
                        ddlParser.setCurrentSchema(recovered.schemaName());
                    }
                    if ((filteredBy = this.ddlFilter.apply(ddl)).isPresent()) {
                        this.logger.info("a DDL '{}' was filtered out of processing by regular expression '{}", (Object)ddl, (Object)filteredBy.get());
                        return;
                    }
                    try {
                        this.logger.debug("Applying: {}", (Object)ddl);
                        ddlParser.parse(ddl, schema);
                        this.listener.onChangeApplied((HistoryRecord)recovered);
                    }
                    catch (MultipleParsingExceptions | ParsingException e) {
                        if (this.skipUnparseableDDL) {
                            this.logger.warn("Ignoring unparseable statements '{}' stored in database history: {}", (Object)ddl, (Object)e);
                        }
                        throw e;
                    }
                }
            } else {
                this.logger.debug("Skipping: {}", (Object)recovered.ddl());
            }
        });
        this.listener.recoveryStopped();
    }

    protected abstract void storeRecord(HistoryRecord var1) throws DatabaseHistoryException;

    protected abstract void recoverRecords(Consumer<HistoryRecord> var1);

    @Override
    public void stop() {
        this.listener.stopped();
    }

    @Override
    public void initializeStorage() {
    }

    @Override
    public boolean storeOnlyCapturedTables() {
        return this.storeOnlyCapturedTablesDdl;
    }

    @Override
    public boolean skipUnparseableDdlStatements() {
        return this.skipUnparseableDDL;
    }
}

