/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class EventProcessingFailureHandlingIT
extends AbstractConnectorTest {
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE tablea (id int primary key, cola varchar(30))", "CREATE TABLE tableb (id int primary key, colb BIGINT NOT NULL)", "CREATE TABLE tablec (id int primary key, colc varchar(30))"});
        TestHelper.enableTableCdc(this.connection, "tablea");
        TestHelper.enableTableCdc(this.connection, "tableb");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void warn() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int ID_START_1 = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(SqlServerConnectorConfig.EVENT_PROCESSING_FAILURE_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN)).build();
        LogInterceptor logInterceptor = new LogInterceptor(EventDispatcher.class);
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForStreamingStarted();
        this.connection.execute(new String[]{"INSERT INTO tablea VALUES (1, 'seed')"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).isNull();
        this.connection.execute(new String[]{"ALTER TABLE dbo.tableb ALTER COLUMN colb varchar(30)"});
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        records = this.consumeRecordsByTopic(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tableb")).isNull();
        Awaitility.await().alias("Found warning message in logs").atMost((long)TestHelper.waitTimeForLogEntries(), TimeUnit.SECONDS).until(() -> logInterceptor.containsWarnMessage("Error while processing event at offset {"));
    }

    @Test
    public void ignore() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int ID_START_1 = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(SqlServerConnectorConfig.EVENT_PROCESSING_FAILURE_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.EventProcessingFailureHandlingMode.SKIP)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForStreamingStarted();
        this.connection.execute(new String[]{"INSERT INTO tablea VALUES (1, 'seed')"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).isNull();
        this.connection.execute(new String[]{"ALTER TABLE dbo.tableb ALTER COLUMN colb varchar(30)"});
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        records = this.consumeRecordsByTopic(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tableb")).isNull();
    }

    @Test
    public void fail() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int ID_START_1 = 10;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        LogInterceptor logInterceptor = new LogInterceptor(ErrorHandler.class);
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForStreamingStarted();
        this.connection.execute(new String[]{"INSERT INTO tablea VALUES (1, 'seed')"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tablea")).hasSize(1);
        Assertions.assertThat((List)records.recordsForTopic("server1.testDB1.dbo.tableb")).isNull();
        this.connection.execute(new String[]{"ALTER TABLE dbo.tableb ALTER COLUMN colb varchar(30)"});
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        Awaitility.await().alias("Found error message in logs").atMost((long)TestHelper.waitTimeForLogEntries(), TimeUnit.SECONDS).until(() -> {
            boolean foundErrorMessageInLogs = logInterceptor.containsStacktraceElement("Error while processing event at offset {");
            return foundErrorMessageInLogs && !this.engine.isRunning();
        });
    }
}

