/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.relational.history.KafkaDatabaseHistory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnectorConfigTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnectorConfigTest.class);

    @Test
    public void noDatabaseName() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(this.defaultConfig().build());
        Assert.assertFalse((boolean)connectorConfig.validateAndRecord((Iterable)SqlServerConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void onlyDatabaseName() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(((Configuration.Builder)this.defaultConfig().with(SqlServerConnectorConfig.DATABASE_NAME, "testDB")).build());
        Assert.assertTrue((boolean)connectorConfig.validateAndRecord((Iterable)SqlServerConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void onlyDatabaseNames() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(((Configuration.Builder)this.defaultConfig().with(SqlServerConnectorConfig.DATABASE_NAMES, "testDB")).build());
        Assert.assertTrue((boolean)connectorConfig.validateAndRecord((Iterable)SqlServerConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    @Test
    public void databaseNameAndDatabaseNames() {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(((Configuration.Builder)((Configuration.Builder)this.defaultConfig().with(SqlServerConnectorConfig.DATABASE_NAME, "testDB")).with(SqlServerConnectorConfig.DATABASE_NAMES, "testDB")).build());
        Assert.assertFalse((boolean)connectorConfig.validateAndRecord((Iterable)SqlServerConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    private Configuration.Builder defaultConfig() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(SqlServerConnectorConfig.SERVER_NAME, "server")).with(SqlServerConnectorConfig.HOSTNAME, "localhost")).with(SqlServerConnectorConfig.USER, "debezium")).with(KafkaDatabaseHistory.BOOTSTRAP_SERVERS, "localhost:9092")).with(KafkaDatabaseHistory.TOPIC, "history");
    }
}

