/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SqlServerConnectorMultiPartitionModeIT
extends AbstractConnectorTest {
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabases("testDB1", "testDB2");
        this.connection = TestHelper.multiPartitionTestConnection();
        this.connection.execute(new String[]{"USE testDB1", "CREATE TABLE tableA (id int primary key, colA varchar(32))", "CREATE TABLE tableB (id int primary key, colB varchar(32))", "INSERT INTO tableA VALUES(1, 'a1')", "INSERT INTO tableB VALUES(2, 'b')"});
        TestHelper.enableTableCdc(this.connection, "tableA");
        TestHelper.enableTableCdc(this.connection, "tableB");
        this.connection.execute(new String[]{"USE testDB2", "CREATE TABLE tableA (id int primary key, colA varchar(32))", "CREATE TABLE tableC (id int primary key, colC varchar(32))", "INSERT INTO tableA VALUES(3, 'a2')", "INSERT INTO tableC VALUES(4, 'c')"});
        TestHelper.enableTableCdc(this.connection, "tableA");
        TestHelper.enableTableCdc(this.connection, "tableC");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void snapshotAndStreaming() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultMultiPartitionConfig("testDB1", "testDB2").with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForDatabaseSnapshotsToBeCompleted("testDB1", "testDB2");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(4);
        List tableA1 = records.recordsForTopic(TestHelper.topicName("testDB1", "tableA"));
        Assertions.assertThat((List)tableA1).hasSize(1);
        this.assertValue((SourceRecord)tableA1.get(0), "colA", "a1");
        List tableB = records.recordsForTopic(TestHelper.topicName("testDB1", "tableB"));
        Assertions.assertThat((List)tableB).hasSize(1);
        this.assertValue((SourceRecord)tableB.get(0), "colB", "b");
        List tableA2 = records.recordsForTopic(TestHelper.topicName("testDB2", "tableA"));
        Assertions.assertThat((List)tableA2).hasSize(1);
        this.assertValue((SourceRecord)tableA2.get(0), "colA", "a2");
        List tableC = records.recordsForTopic(TestHelper.topicName("testDB2", "tableC"));
        Assertions.assertThat((List)tableC).hasSize(1);
        this.assertValue((SourceRecord)tableC.get(0), "colC", "c");
        this.connection.execute(new String[]{"USE testDB1", "INSERT INTO tableA VALUES(5, 'a1s')"});
        this.connection.execute(new String[]{"USE testDB2", "INSERT INTO tableA VALUES(6, 'a2s')"});
        TestHelper.waitForTaskStreamingStarted();
        records = this.consumeRecordsByTopic(2);
        tableA1 = records.recordsForTopic(TestHelper.topicName("testDB1", "tableA"));
        Assertions.assertThat((List)tableA1).hasSize(1);
        this.assertValue((SourceRecord)tableA1.get(0), "colA", "a1s");
        tableA2 = records.recordsForTopic(TestHelper.topicName("testDB2", "tableA"));
        Assertions.assertThat((List)tableA1).hasSize(1);
        this.assertValue((SourceRecord)tableA2.get(0), "colA", "a2s");
    }

    private void assertValue(SourceRecord record, String fieldName, Object expected) {
        Struct value = (Struct)record.value();
        Struct after = (Struct)value.get("after");
        Assertions.assertThat((Object)after.get(fieldName)).isEqualTo(expected);
    }
}

