/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Field;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Connector;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class SqlServerConnectorTest {
    SqlServerConnector connector;

    @Before
    public void before() {
        this.connector = new SqlServerConnector();
    }

    @Test
    public void testValidateUnableToConnectNoThrow() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(SqlServerConnectorConfig.SERVER_NAME.name(), "dbserver1");
        config.put(SqlServerConnectorConfig.HOSTNAME.name(), "narnia");
        config.put(SqlServerConnectorConfig.PORT.name(), "4321");
        config.put(SqlServerConnectorConfig.DATABASE_NAME.name(), "sqlserver");
        config.put(SqlServerConnectorConfig.USER.name(), "pikachu");
        config.put(SqlServerConnectorConfig.PASSWORD.name(), "raichu");
        Config validated = this.connector.validate(config);
        ConfigValue hostName = this.getHostName(validated).orElseThrow(() -> new IllegalArgumentException("Host name config option not found"));
        Assertions.assertThat((boolean)((String)hostName.errorMessages().get(0)).startsWith("Unable to connect:"));
    }

    private Optional<ConfigValue> getHostName(Config config) {
        return config.configValues().stream().filter(value -> value.name().equals(SqlServerConnectorConfig.HOSTNAME.name())).findFirst();
    }

    @Test
    public void shouldReturnConfigurationDefinition() {
        SqlServerConnectorTest.assertConfigDefIsValid((Connector)this.connector, SqlServerConnectorConfig.ALL_FIELDS);
    }

    protected static void assertConfigDefIsValid(Connector connector, Field.Set fields) {
        ConfigDef configDef = connector.config();
        Assertions.assertThat((Object)configDef).isNotNull();
        fields.forEach(expected -> {
            Assertions.assertThat((Collection)configDef.names()).contains(new Object[]{expected.name()});
            ConfigDef.ConfigKey key = (ConfigDef.ConfigKey)configDef.configKeys().get(expected.name());
            Assertions.assertThat((Object)key).isNotNull();
            Assertions.assertThat((String)key.name).isEqualTo((Object)expected.name());
            Assertions.assertThat((String)key.displayName).isEqualTo((Object)expected.displayName());
            Assertions.assertThat((Object)key.importance).isEqualTo((Object)expected.importance());
            Assertions.assertThat((String)key.documentation).isEqualTo((Object)expected.description());
            Assertions.assertThat((Object)key.type).isEqualTo((Object)expected.type());
            if (expected.equals((Object)SqlServerConnectorConfig.DATABASE_HISTORY)) {
                Assertions.assertThat((String)((Class)key.defaultValue).getName()).isEqualTo((Object)((String)expected.defaultValue()));
            }
            Assertions.assertThat((List)key.dependents).isEqualTo((Object)expected.dependents());
            Assertions.assertThat((Object)key.width).isNotNull();
            Assertions.assertThat((String)key.group).isNotNull();
            Assertions.assertThat((int)key.orderInGroup).isGreaterThan(0);
            Assertions.assertThat((Object)key.validator).isNull();
            Assertions.assertThat((Object)key.recommender).isNull();
        });
    }
}

