/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.metrics.Metrics;
import io.debezium.relational.history.DatabaseHistoryListener;
import io.debezium.relational.history.DatabaseHistoryMXBean;
import io.debezium.relational.history.HistoryRecord;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseHistoryMetrics
extends Metrics
implements DatabaseHistoryListener,
DatabaseHistoryMXBean {
    private static final String CONTEXT_NAME = "schema-history";
    private static final Duration PAUSE_BETWEEN_LOG_MESSAGES = Duration.ofSeconds(2L);
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseHistoryMetrics.class);
    private DatabaseHistoryStatus status = DatabaseHistoryStatus.STOPPED;
    private Instant recoveryStartTime = null;
    private AtomicLong changesRecovered = new AtomicLong();
    private AtomicLong totalChangesApplied = new AtomicLong();
    private Instant lastChangeAppliedTimestamp;
    private Instant lastChangeRecoveredTimestamp;
    private HistoryRecord lastAppliedChange;
    private HistoryRecord lastRecoveredChange;

    protected <T extends CdcSourceTaskContext> DatabaseHistoryMetrics(T taskContext, String contextName) {
        super(taskContext, contextName);
    }

    public DatabaseHistoryMetrics(CommonConnectorConfig connectorConfig) {
        super(connectorConfig, CONTEXT_NAME);
    }

    @Override
    public String getStatus() {
        return this.status.toString();
    }

    @Override
    public long getRecoveryStartTime() {
        return this.recoveryStartTime == null ? -1L : this.recoveryStartTime.getEpochSecond();
    }

    @Override
    public long getChangesRecovered() {
        return this.changesRecovered.get();
    }

    @Override
    public long getChangesApplied() {
        return this.totalChangesApplied.get();
    }

    @Override
    public long getMilliSecondsSinceLastAppliedChange() {
        return this.lastChangeAppliedTimestamp == null ? -1L : Duration.between(this.lastChangeAppliedTimestamp, Instant.now()).toMillis();
    }

    @Override
    public long getMilliSecondsSinceLastRecoveredChange() {
        return this.lastChangeRecoveredTimestamp == null ? -1L : Duration.between(this.lastChangeRecoveredTimestamp, Instant.now()).toMillis();
    }

    @Override
    public String getLastAppliedChange() {
        return this.lastAppliedChange == null ? "" : this.lastAppliedChange.toString();
    }

    @Override
    public String getLastRecoveredChange() {
        return this.lastRecoveredChange == null ? "" : this.lastRecoveredChange.toString();
    }

    @Override
    public void started() {
        this.status = DatabaseHistoryStatus.RUNNING;
        this.register();
    }

    @Override
    public void stopped() {
        this.status = DatabaseHistoryStatus.STOPPED;
        this.unregister();
    }

    @Override
    public void recoveryStarted() {
        this.status = DatabaseHistoryStatus.RECOVERING;
        this.recoveryStartTime = Instant.now();
        LOGGER.info("Started database history recovery");
    }

    @Override
    public void recoveryStopped() {
        this.status = DatabaseHistoryStatus.RUNNING;
        LOGGER.info("Finished database history recovery of {} change(s) in {} ms", (Object)this.changesRecovered.get(), (Object)Duration.between(this.recoveryStartTime, Instant.now()).toMillis());
    }

    @Override
    public void onChangeFromHistory(HistoryRecord record) {
        this.lastRecoveredChange = record;
        this.changesRecovered.incrementAndGet();
        if (this.getMilliSecondsSinceLastRecoveredChange() >= PAUSE_BETWEEN_LOG_MESSAGES.toMillis()) {
            LOGGER.info("Database history recovery in progress, recovered {} records", (Object)this.changesRecovered);
        }
        this.lastChangeRecoveredTimestamp = Instant.now();
    }

    @Override
    public void onChangeApplied(HistoryRecord record) {
        this.lastAppliedChange = record;
        this.totalChangesApplied.incrementAndGet();
        if (this.getMilliSecondsSinceLastAppliedChange() >= PAUSE_BETWEEN_LOG_MESSAGES.toMillis()) {
            LOGGER.info("Already applied {} database changes", (Object)this.totalChangesApplied);
        }
        this.lastChangeAppliedTimestamp = Instant.now();
    }

    public static enum DatabaseHistoryStatus {
        STOPPED,
        RECOVERING,
        RUNNING;

    }
}

