/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import io.debezium.converters.spi.SerializerType;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.storage.ConverterConfig;

public class CloudEventsConverterConfig
extends ConverterConfig {
    public static final String CLOUDEVENTS_SERIALIZER_TYPE_CONFIG = "serializer.type";
    public static final String CLOUDEVENTS_SERIALIZER_TYPE_DEFAULT = "json";
    private static final String CLOUDEVENTS_SERIALIZER_TYPE_DOC = "Specify a serializer to serialize CloudEvents values";
    public static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG = "data.serializer.type";
    public static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_DEFAULT = "json";
    private static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_DOC = "Specify a serializer to serialize the data field of CloudEvents values";
    private static final ConfigDef CONFIG = ConverterConfig.newConfigDef();

    public static ConfigDef configDef() {
        return CONFIG;
    }

    public CloudEventsConverterConfig(Map<String, ?> props) {
        super(CONFIG, props);
    }

    public SerializerType cloudeventsSerializerType() {
        return SerializerType.withName(this.getString(CLOUDEVENTS_SERIALIZER_TYPE_CONFIG));
    }

    public SerializerType cloudeventsDataSerializerTypeConfig() {
        return SerializerType.withName(this.getString(CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG));
    }

    static {
        CONFIG.define(CLOUDEVENTS_SERIALIZER_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"json", ConfigDef.Importance.HIGH, CLOUDEVENTS_SERIALIZER_TYPE_DOC);
        CONFIG.define(CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"json", ConfigDef.Importance.HIGH, CLOUDEVENTS_DATA_SERIALIZER_TYPE_DOC);
    }
}

