/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Collect;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SchemaHistoryTopicIT
extends AbstractConnectorTest {
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE tablea (id int primary key, cola varchar(30))", "CREATE TABLE tableb (id int primary key, colb varchar(30))", "CREATE TABLE tablec (id int primary key, colc varchar(30))"});
        TestHelper.enableTableCdc(this.connection, "tablea");
        TestHelper.enableTableCdc(this.connection, "tableb");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-1904"})
    public void streamingSchemaChanges() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START_1 = 10;
        int ID_START_2 = 100;
        int ID_START_3 = 1000;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(RelationalDatabaseConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        Testing.Print.enable();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(3);
        List schemaRecords = records.allRecordsInOrder();
        Assertions.assertThat((List)schemaRecords).hasSize(3);
        schemaRecords.forEach(record -> {
            Assertions.assertThat((String)record.topic()).isEqualTo((Object)"server1");
            Assertions.assertThat((String)((Struct)record.key()).getString("databaseName")).isEqualTo((Object)"testDB");
            Assertions.assertThat(record.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        });
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(0)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(1)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(2)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"last");
        List tableChanges = ((Struct)((SourceRecord)schemaRecords.get(0)).value()).getArray("tableChanges");
        Assertions.assertThat((List)tableChanges).hasSize(1);
        Assertions.assertThat((Object)((Struct)tableChanges.get(0)).get("type")).isEqualTo((Object)"CREATE");
        this.waitForAvailableRecords(TestHelper.waitTimeForRecords(), TimeUnit.SECONDS);
        records = this.consumeRecordsByTopic(10, 24);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tablea")).hasSize(5);
        List tablebRecords = records.recordsForTopic("server1.dbo.tableb");
        if (tablebRecords.size() == 4) {
            tablebRecords.add(this.consumeRecord());
        }
        Assertions.assertThat((List)tablebRecords).hasSize(5);
        tablebRecords.forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_STRING_SCHEMA).build()));
        List updateBatch = records.allRecordsInOrder();
        SourceRecord lastUpdate = (SourceRecord)updateBatch.get(updateBatch.size() - 1);
        TestHelper.disableTableCdc((JdbcConnection)this.connection, "tableb");
        this.connection.execute(new String[]{"exec sp_rename 'tableb.colb', 'newcolb';"});
        TestHelper.enableTableCdc(this.connection, "tableb", "after_change");
        for (int i = 0; i < 5; ++i) {
            int id = 100 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a2')"});
            this.connection.execute(new String[]{"INSERT INTO tableb(id,newcolb) VALUES(" + id + ", 'b2')"});
        }
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.allRecordsInOrder()).hasSize(1);
        SourceRecord schemaRecord = (SourceRecord)records.allRecordsInOrder().get(0);
        Assertions.assertThat((String)schemaRecord.topic()).isEqualTo((Object)"server1");
        Assertions.assertThat((String)((Struct)schemaRecord.key()).getString("databaseName")).isEqualTo((Object)"testDB");
        Assertions.assertThat(schemaRecord.sourceOffset().get("snapshot")).isNull();
        Assertions.assertThat((String)((Struct)schemaRecord.value()).getStruct("source").getString("snapshot")).isNull();
        tableChanges = ((Struct)schemaRecord.value()).getArray("tableChanges");
        Assertions.assertThat((List)tableChanges).hasSize(1);
        Assertions.assertThat((Object)((Struct)tableChanges.get(0)).get("type")).isEqualTo((Object)"ALTER");
        Assertions.assertThat((Map)lastUpdate.sourceOffset()).isEqualTo((Object)schemaRecord.sourceOffset());
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("newcolb", Schema.OPTIONAL_STRING_SCHEMA).build()));
        for (int i = 0; i < 5; ++i) {
            int id = 1000 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a3')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b3')"});
        }
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("newcolb", Schema.OPTIONAL_STRING_SCHEMA).build()));
    }

    @Test
    @FixFor(value={"DBZ-1904"})
    public void snapshotSchemaChanges() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START_1 = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(RelationalDatabaseConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(3);
        List schemaRecords = records.allRecordsInOrder();
        Assertions.assertThat((List)schemaRecords).hasSize(3);
        schemaRecords.forEach(record -> {
            Assertions.assertThat((String)record.topic()).isEqualTo((Object)"server1");
            Assertions.assertThat((String)((Struct)record.key()).getString("databaseName")).isEqualTo((Object)"testDB");
            Assertions.assertThat(record.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        });
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(0)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(1)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(2)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        List tableChanges = ((Struct)((SourceRecord)schemaRecords.get(0)).value()).getArray("tableChanges");
        Assertions.assertThat((List)tableChanges).hasSize(1);
        Assertions.assertThat((Object)((Struct)tableChanges.get(0)).get("type")).isEqualTo((Object)"CREATE");
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tableb")).hasSize(5);
        records.recordsForTopic("server1.dbo.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("server1.dbo.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_STRING_SCHEMA).build()));
    }

    @Test
    @FixFor(value={"DBZ-2303"})
    public void schemaChangeAfterSnapshot() throws Exception {
        boolean RECORDS_PER_TABLE = true;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.tablec")).build();
        this.connection.execute(new String[]{"CREATE TABLE tabled (id int primary key, cold varchar(30))"});
        this.connection.execute(new String[]{"INSERT INTO tablec VALUES(1, 'c')"});
        TestHelper.enableTableCdc(this.connection, "tablec");
        TestHelper.waitForEnabledCdc(this.connection, "tablec");
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        Testing.Print.enable();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tablec")).hasSize(1);
        this.stopConnector();
        this.assertConnectorNotRunning();
        Configuration config2 = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.tablec,dbo.tabled")).build();
        this.start(SqlServerConnector.class, config2);
        this.assertConnectorIsRunning();
        TestHelper.waitForStreamingStarted();
        TestHelper.enableTableCdc(this.connection, "tabled");
        TestHelper.waitForEnabledCdc(this.connection, "tabled");
        this.connection.execute(new String[]{"INSERT INTO tabled VALUES(1, 'd')"});
        records = this.consumeRecordsByTopic(3);
        Assertions.assertThat((List)records.recordsForTopic("server1.dbo.tabled")).hasSize(1);
        List schemaEvents = records.recordsForTopic("server1");
        if (schemaEvents == null) {
            Testing.print((Object)("Received records: " + records.allRecordsInOrder()));
        }
        SourceRecord schemaEventD = (SourceRecord)schemaEvents.get(schemaEvents.size() - 1);
        Assertions.assertThat((String)((Struct)schemaEventD.value()).getStruct("source").getString("schema")).isEqualTo((Object)"dbo");
        Assertions.assertThat((String)((Struct)schemaEventD.value()).getStruct("source").getString("table")).isEqualTo((Object)"tabled");
    }

    @Test
    @FixFor(value={"DBZ-3347"})
    public void shouldContainPartitionInSchemaChangeEventInSinglePartitionMode() throws Exception {
        this.shouldContainPartitionInSchemaChangeEvent(TestHelper.defaultConfig(), Collections.singletonMap("server", "server1"));
    }

    @Test
    @FixFor(value={"DBZ-3347", "DBZ-2975"})
    public void shouldContainPartitionInSchemaChangeEventInMultiPartitionMode() throws Exception {
        this.shouldContainPartitionInSchemaChangeEvent(TestHelper.defaultMultiPartitionConfig(), Collect.hashMapOf((Object)"server", (Object)"server1", (Object)"database", (Object)"testDB"));
    }

    private void shouldContainPartitionInSchemaChangeEvent(Configuration.Builder configBuilder, Map<String, String> expectedPartition) throws Exception {
        this.connection.execute(new String[]{"create table dbz3347 (id int primary key, data varchar(50))"});
        TestHelper.enableTableCdc(this.connection, "dbz3347");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)configBuilder.with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo\\.dbz3347")).with(SqlServerConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForStreamingStarted();
        AbstractConnectorTest.SourceRecords schemaChanges = this.consumeRecordsByTopic(1);
        SourceRecord change = (SourceRecord)schemaChanges.recordsForTopic("server1").get(0);
        Assertions.assertThat((Map)change.sourcePartition()).isEqualTo(expectedPartition);
    }
}

