/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.junit.SkipTestRule;
import io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;

public class IncrementalSnapshotWithRecompileIT
extends AbstractIncrementalSnapshotTest<SqlServerConnector> {
    private SqlServerConnection connection;
    @Rule
    public SkipTestRule skipRule = new SkipTestRule();

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnectionWithOptionRecompile();
        this.connection.execute(new String[]{"CREATE TABLE a (pk int primary key, aa int)", "CREATE TABLE debezium_signal (id varchar(64), type varchar(32), data varchar(2048))"});
        TestHelper.enableTableCdc(this.connection, "debezium_signal");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    protected void populateTable() throws SQLException {
        super.populateTable();
        TestHelper.enableTableCdc(this.connection, "a");
    }

    protected Class<SqlServerConnector> connectorClass() {
        return SqlServerConnector.class;
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected String topicName() {
        return "server1.dbo.a";
    }

    protected String tableName() {
        return "testDB.dbo.a";
    }

    protected String signalTableName() {
        return "dbo.debezium_signal";
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(SqlServerConnectorConfig.SIGNAL_DATA_COLLECTION, "testDB.dbo.debezium_signal")).with(SqlServerConnectorConfig.INCREMENTAL_SNAPSHOT_OPTION_RECOMPILE, true);
    }
}

