/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigurationDefaults;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Threads;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnapshotChangeEventSource<P extends Partition, O extends OffsetContext>
implements SnapshotChangeEventSource<P, O> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSnapshotChangeEventSource.class);
    private final CommonConnectorConfig connectorConfig;
    private final SnapshotProgressListener snapshotProgressListener;

    public AbstractSnapshotChangeEventSource(CommonConnectorConfig connectorConfig, SnapshotProgressListener snapshotProgressListener) {
        this.connectorConfig = connectorConfig;
        this.snapshotProgressListener = snapshotProgressListener;
    }

    @Override
    public SnapshotResult<O> execute(ChangeEventSource.ChangeEventSourceContext context, P partition, O previousOffset) throws InterruptedException {
        SnapshotContext<P, O> ctx;
        SnapshottingTask snapshottingTask = this.getSnapshottingTask(previousOffset);
        if (snapshottingTask.shouldSkipSnapshot()) {
            LOGGER.debug("Skipping snapshotting");
            return SnapshotResult.skipped(previousOffset);
        }
        this.delaySnapshotIfNeeded(context);
        try {
            ctx = this.prepare(partition);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize snapshot context.", (Throwable)e);
            throw new RuntimeException(e);
        }
        boolean completedSuccessfully = true;
        try {
            this.snapshotProgressListener.snapshotStarted();
            SnapshotResult<O> snapshotResult = this.doExecute(context, previousOffset, ctx, snapshottingTask);
            return snapshotResult;
        }
        catch (InterruptedException e) {
            completedSuccessfully = false;
            LOGGER.warn("Snapshot was interrupted before completion");
            throw e;
        }
        catch (Exception t) {
            completedSuccessfully = false;
            throw new DebeziumException((Throwable)t);
        }
        finally {
            LOGGER.info("Snapshot - Final stage");
            this.complete(ctx);
            if (completedSuccessfully) {
                this.snapshotProgressListener.snapshotCompleted();
            } else {
                this.snapshotProgressListener.snapshotAborted();
            }
        }
    }

    protected <T extends DataCollectionId> Stream<T> determineDataCollectionsToBeSnapshotted(Collection<T> allDataCollections) {
        Set<Pattern> snapshotAllowedDataCollections = this.connectorConfig.getDataCollectionsToBeSnapshotted();
        if (snapshotAllowedDataCollections.size() == 0) {
            return allDataCollections.stream();
        }
        return allDataCollections.stream().filter(dataCollectionId -> snapshotAllowedDataCollections.stream().anyMatch(s -> s.matcher(dataCollectionId.identifier()).matches()));
    }

    protected void delaySnapshotIfNeeded(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        Duration snapshotDelay = this.connectorConfig.getSnapshotDelay();
        if (snapshotDelay.isZero() || snapshotDelay.isNegative()) {
            return;
        }
        Threads.Timer timer = Threads.timer(Clock.SYSTEM, snapshotDelay);
        Metronome metronome = Metronome.parker(ConfigurationDefaults.RETURN_CONTROL_INTERVAL, Clock.SYSTEM);
        while (!timer.expired()) {
            if (!context.isRunning()) {
                throw new InterruptedException("Interrupted while awaiting initial snapshot delay");
            }
            LOGGER.info("The connector will wait for {}s before proceeding", (Object)timer.remaining().getSeconds());
            metronome.pause();
        }
    }

    protected abstract SnapshotResult<O> doExecute(ChangeEventSource.ChangeEventSourceContext var1, O var2, SnapshotContext<P, O> var3, SnapshottingTask var4) throws Exception;

    protected abstract SnapshottingTask getSnapshottingTask(O var1);

    protected abstract SnapshotContext<P, O> prepare(P var1) throws Exception;

    protected void complete(SnapshotContext<P, O> snapshotContext) {
    }

    public static class SnapshottingTask {
        private final boolean snapshotSchema;
        private final boolean snapshotData;

        public SnapshottingTask(boolean snapshotSchema, boolean snapshotData) {
            this.snapshotSchema = snapshotSchema;
            this.snapshotData = snapshotData;
        }

        public boolean snapshotData() {
            return this.snapshotData;
        }

        public boolean snapshotSchema() {
            return this.snapshotSchema;
        }

        public boolean shouldSkipSnapshot() {
            return !this.snapshotSchema() && !this.snapshotData();
        }

        public String toString() {
            return "SnapshottingTask [snapshotSchema=" + this.snapshotSchema + ", snapshotData=" + this.snapshotData + "]";
        }
    }

    public static class SnapshotContext<P extends Partition, O extends OffsetContext>
    implements AutoCloseable {
        public P partition;
        public O offset;

        public SnapshotContext(P partition) {
            this.partition = partition;
        }

        @Override
        public void close() throws Exception {
        }
    }
}

