/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal;

import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.signal.Signal;
import io.debezium.schema.DataCollectionId;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteSnapshot
implements Signal.Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteSnapshot.class);
    private static final String FIELD_DATA_COLLECTIONS = "data-collections";
    private static final String FIELD_TYPE = "type";
    public static final String NAME = "execute-snapshot";
    private final EventDispatcher<? extends DataCollectionId> dispatcher;

    public ExecuteSnapshot(EventDispatcher<? extends DataCollectionId> dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public boolean arrived(Signal.Payload signalPayload) throws InterruptedException {
        List<String> dataCollections = ExecuteSnapshot.getDataCollections(signalPayload.data);
        if (dataCollections == null) {
            return false;
        }
        SnapshotType type = ExecuteSnapshot.getSnapshotType(signalPayload.data);
        LOGGER.info("Requested '{}' snapshot of data collections '{}'", (Object)type, dataCollections);
        switch (type) {
            case INCREMENTAL: {
                this.dispatcher.getIncrementalSnapshotChangeEventSource().addDataCollectionNamesToSnapshot(dataCollections, signalPayload.offsetContext);
            }
        }
        return true;
    }

    public static SnapshotType getSnapshotType(Document data) {
        String typeStr = data.getString(FIELD_TYPE);
        SnapshotType type = SnapshotType.INCREMENTAL;
        if (typeStr != null) {
            type = SnapshotType.valueOf(typeStr);
        }
        return type;
    }

    public static List<String> getDataCollections(Document data) {
        Array dataCollectionsArray = data.getArray(FIELD_DATA_COLLECTIONS);
        if (dataCollectionsArray == null || dataCollectionsArray.isEmpty()) {
            LOGGER.warn("Execute snapshot signal '{}' has arrived but the requested field '{}' is missing from data or is empty", (Object)data, (Object)FIELD_DATA_COLLECTIONS);
            return null;
        }
        return dataCollectionsArray.streamValues().map(v -> v.asString().trim()).collect(Collectors.toList());
    }

    public static enum SnapshotType {
        INCREMENTAL;

    }
}

