/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SnapshotWithSelectOverridesIT
extends AbstractConnectorTest {
    private static final int INITIAL_RECORDS_PER_TABLE = 10;
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE table1 (id int, name varchar(30), price decimal(8,2), ts datetime2(0), soft_deleted bit, primary key(id))"});
        this.connection.execute(new String[]{"CREATE TABLE table2 (id int, name varchar(30), price decimal(8,2), ts datetime2(0), soft_deleted bit, primary key(id))"});
        this.connection.execute(new String[]{"CREATE TABLE table3 (id int, name varchar(30), price decimal(8,2), ts datetime2(0), soft_deleted bit, primary key(id))"});
        for (int i = 0; i < 10; ++i) {
            this.connection.execute(new String[]{String.format("INSERT INTO table1 VALUES(%s, '%s', %s, '%s', %s)", i, "name" + i, new BigDecimal(i + ".23"), "2018-07-18 13:28:56", i % 2)});
            this.connection.execute(new String[]{String.format("INSERT INTO table2 VALUES(%s, '%s', %s, '%s', %s)", i, "name" + i, new BigDecimal(i + ".23"), "2018-07-18 13:28:56", i % 2)});
            this.connection.execute(new String[]{String.format("INSERT INTO table3 VALUES(%s, '%s', %s, '%s', %s)", i, "name" + i, new BigDecimal(i + ".23"), "2018-07-18 13:28:56", i % 2)});
        }
        TestHelper.enableTableCdc(this.connection, "table1");
        TestHelper.enableTableCdc(this.connection, "table2");
        TestHelper.enableTableCdc(this.connection, "table3");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-1224"})
    public void takeSnapshotWithOverridesInSinglePartitionMode() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, "dbo.table1,dbo.table3")).with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + ".dbo.table1", "SELECT * FROM [dbo].[table1] where soft_deleted = 0 order by id desc").with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + ".dbo.table3", "SELECT * FROM [dbo].[table3] where soft_deleted = 0").build();
        this.takeSnapshotWithOverrides(config);
    }

    @Test
    @FixFor(value={"DBZ-1224", "DBZ-2975"})
    public void takeSnapshotWithOverridesInMultiPartitionMode() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultMultiPartitionConfig().with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, "dbo.table1,dbo.table3")).with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + ".dbo.table1", "SELECT * FROM [testdb].[dbo].[table1] where soft_deleted = 0 order by id desc").with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + ".dbo.table3", "SELECT * FROM [testdb].[dbo].[table3] where soft_deleted = 0").build();
        this.takeSnapshotWithOverrides(config);
    }

    private void takeSnapshotWithOverrides(Configuration config) throws Exception {
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(20);
        List table1 = records.recordsForTopic("server1.dbo.table1");
        List table2 = records.recordsForTopic("server1.dbo.table2");
        List table3 = records.recordsForTopic("server1.dbo.table3");
        Assertions.assertThat((List)table1).hasSize(5);
        Assertions.assertThat((List)table2).hasSize(10);
        Assertions.assertThat((List)table3).hasSize(5);
        String expectedIdsForTable1 = "86420";
        StringBuilder actualIdsForTable1 = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            SourceRecord record = (SourceRecord)table1.get(i);
            Struct key = (Struct)record.key();
            actualIdsForTable1.append(key.get("id"));
            Struct value = (Struct)record.value();
            Assertions.assertThat((Object)((Struct)value.get("after")).get("soft_deleted")).isEqualTo((Object)false);
        }
        Assertions.assertThat((String)actualIdsForTable1.toString()).isEqualTo((Object)expectedIdsForTable1);
    }

    @Test
    @FixFor(value={"DBZ-3429"})
    public void takeSnapshotWithOverridesWithAdditionalWhitespaceInSinglePartitionMode() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, "  dbo.table1 , dbo.table3  ")).with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + ".dbo.table1", "SELECT * FROM [dbo].[table1] where soft_deleted = 0 order by id desc").with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + ".dbo.table3", "SELECT * FROM [dbo].[table3] where soft_deleted = 0").build();
        this.takeSnapshotWithOverridesWithAdditionalWhitespace(config);
    }

    @Test
    @FixFor(value={"DBZ-3429", "DBZ-2975"})
    public void takeSnapshotWithOverridesWithAdditionalWhitespaceInMultiPartitionMode() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultMultiPartitionConfig().with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, "  dbo.table1 , dbo.table3  ")).with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + ".dbo.table1", "SELECT * FROM [testdb].[dbo].[table1] where soft_deleted = 0 order by id desc").with(RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + ".dbo.table3", "SELECT * FROM [testdb].[dbo].[table3] where soft_deleted = 0").build();
        this.takeSnapshotWithOverridesWithAdditionalWhitespace(config);
    }

    private void takeSnapshotWithOverridesWithAdditionalWhitespace(Configuration config) throws Exception {
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(20);
        List table1 = records.recordsForTopic("server1.dbo.table1");
        List table2 = records.recordsForTopic("server1.dbo.table2");
        List table3 = records.recordsForTopic("server1.dbo.table3");
        Assertions.assertThat((List)table1).hasSize(5);
        Assertions.assertThat((List)table2).hasSize(10);
        Assertions.assertThat((List)table3).hasSize(5);
        String expectedIdsForTable1 = "86420";
        StringBuilder actualIdsForTable1 = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            SourceRecord record = (SourceRecord)table1.get(i);
            Struct key = (Struct)record.key();
            actualIdsForTable1.append(key.get("id"));
            Struct value = (Struct)record.value();
            Assertions.assertThat((Object)((Struct)value.get("after")).get("soft_deleted")).isEqualTo((Object)false);
        }
        Assertions.assertThat((String)actualIdsForTable1.toString()).isEqualTo((Object)expectedIdsForTable1);
    }
}

