/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.converters.CloudEventsConverterTest;
import io.debezium.data.SchemaAndValueField;
import io.debezium.data.SourceRecordAssert;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.time.Timestamp;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.MapAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SnapshotIT
extends AbstractConnectorTest {
    private static final int INITIAL_RECORDS_PER_TABLE = 500;
    private static final int STREAMING_RECORDS_PER_TABLE = 500;
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE table1 (id int, name varchar(30), price decimal(8,2), ts datetime2(0), primary key(id))"});
        for (int i = 0; i < 500; ++i) {
            this.connection.execute(new String[]{String.format("INSERT INTO table1 VALUES(%s, '%s', %s, '%s')", i, "name" + i, new BigDecimal(i + ".23"), "2018-07-18 13:28:56")});
        }
        TestHelper.enableTableCdc(this.connection, "table1");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void takeSnapshotInExclusiveMode() throws Exception {
        this.takeSnapshot(SqlServerConnectorConfig.SnapshotIsolationMode.EXCLUSIVE);
    }

    @Test
    public void takeSnapshotInSnapshotMode() throws Exception {
        Testing.Print.enable();
        this.takeSnapshot(SqlServerConnectorConfig.SnapshotIsolationMode.SNAPSHOT);
    }

    @Test
    public void takeSnapshotInRepeatableReadMode() throws Exception {
        this.takeSnapshot(SqlServerConnectorConfig.SnapshotIsolationMode.REPEATABLE_READ);
    }

    @Test
    public void takeSnapshotInReadCommittedMode() throws Exception {
        this.takeSnapshot(SqlServerConnectorConfig.SnapshotIsolationMode.READ_COMMITTED);
    }

    @Test
    public void takeSnapshotInReadUncommittedMode() throws Exception {
        this.takeSnapshot(SqlServerConnectorConfig.SnapshotIsolationMode.READ_UNCOMMITTED);
    }

    private void takeSnapshot(SqlServerConnectorConfig.SnapshotIsolationMode lockingMode) throws Exception {
        Configuration config = TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_ISOLATION_MODE.name(), lockingMode.getValue()).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(500);
        List table1 = records.recordsForTopic("server1.dbo.table1");
        Assertions.assertThat((List)table1).hasSize(500);
        for (int i = 0; i < 500; ++i) {
            SourceRecord record1 = (SourceRecord)table1.get(i);
            List<SchemaAndValueField> expectedKey1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)i));
            List<SchemaAndValueField> expectedRow1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)i), new SchemaAndValueField("name", Schema.OPTIONAL_STRING_SCHEMA, (Object)("name" + i)), new SchemaAndValueField("price", Decimal.builder((int)2).parameter("connect.decimal.precision", "8").optional().build(), (Object)new BigDecimal(i + ".23")), new SchemaAndValueField("ts", Timestamp.builder().optional().schema(), (Object)1531920536000L));
            Struct key1 = (Struct)record1.key();
            Struct value1 = (Struct)record1.value();
            this.assertRecord(key1, expectedKey1);
            this.assertRecord((Struct)value1.get("after"), expectedRow1);
            Assertions.assertThat((Map)record1.sourceOffset()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"snapshot", (Object)true), MapAssert.entry((Object)"snapshot_completed", (Object)(i == 499 ? 1 : 0))});
            Assert.assertNull((Object)value1.get("before"));
        }
    }

    @Test
    public void takeSnapshotAndStartStreaming() throws Exception {
        Configuration config = TestHelper.defaultConfig().build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(500);
        List table1 = records.recordsForTopic("server1.dbo.table1");
        table1.subList(0, 499).forEach(record -> Assertions.assertThat((String)((Struct)record.value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true"));
        Assertions.assertThat((String)((Struct)((SourceRecord)table1.get(499)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"last");
        this.testStreaming();
    }

    @Test
    @FixFor(value={"DBZ-1280"})
    public void testDeadlockDetection() throws Exception {
        LogInterceptor logInterceptor = new LogInterceptor();
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.SNAPSHOT_LOCK_TIMEOUT_MS, 1000)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.connection.setAutoCommit(false).executeWithoutCommitting(new String[]{"SELECT TOP(0) * FROM dbo.table1 WITH (TABLOCKX)"});
        this.consumeRecordsByTopic(500);
        this.assertConnectorNotRunning();
        ((BooleanAssert)Assertions.assertThat((boolean)logInterceptor.containsStacktraceElement("Lock request time out period exceeded.")).as("Log contains error related to lock timeout")).isTrue();
        this.connection.rollback();
    }

    @Test
    public void takeSnapshotWithOldStructAndStartStreaming() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SOURCE_STRUCT_MAKER_VERSION, (EnumeratedValue)CommonConnectorConfig.Version.V1)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(500);
        List table1 = records.recordsForTopic("server1.dbo.table1");
        table1.forEach(record -> Assertions.assertThat((Boolean)((Struct)record.value()).getStruct("source").getBoolean("snapshot")).isTrue());
        this.testStreaming();
    }

    private void testStreaming() throws SQLException, InterruptedException {
        for (int i = 0; i < 500; ++i) {
            int id = i + 500;
            this.connection.execute(new String[]{String.format("INSERT INTO table1 VALUES(%s, '%s', %s, '%s')", id, "name" + id, new BigDecimal(id + ".23"), "2018-07-18 13:28:56")});
        }
        int lastId = 999;
        TestHelper.waitForCdcRecord(this.connection, "table1", rs -> rs.getInt("id") == 999);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(500);
        List table1 = records.recordsForTopic("server1.dbo.table1");
        Assertions.assertThat((List)table1).hasSize(500);
        for (int i = 0; i < 500; ++i) {
            int id = i + 500;
            SourceRecord record1 = (SourceRecord)table1.get(i);
            List<SchemaAndValueField> expectedKey1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id));
            List<SchemaAndValueField> expectedRow1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id), new SchemaAndValueField("name", Schema.OPTIONAL_STRING_SCHEMA, (Object)("name" + id)), new SchemaAndValueField("price", Decimal.builder((int)2).parameter("connect.decimal.precision", "8").optional().build(), (Object)new BigDecimal(id + ".23")), new SchemaAndValueField("ts", Timestamp.builder().optional().schema(), (Object)1531920536000L));
            Struct key1 = (Struct)record1.key();
            Struct value1 = (Struct)record1.value();
            this.assertRecord(key1, expectedKey1);
            this.assertRecord((Struct)value1.get("after"), expectedRow1);
            Assertions.assertThat((Map)record1.sourceOffset()).hasSize(4);
            Assert.assertTrue((boolean)record1.sourceOffset().containsKey("change_lsn"));
            Assert.assertTrue((boolean)record1.sourceOffset().containsKey("commit_lsn"));
            Assert.assertTrue((boolean)record1.sourceOffset().containsKey("event_serial_no"));
            Assert.assertNull((Object)value1.get("before"));
        }
    }

    @Test
    public void takeSchemaOnlySnapshotAndStartStreaming() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        this.testStreaming();
    }

    @Test
    @FixFor(value={"DBZ-1031"})
    public void takeSnapshotFromTableWithReservedName() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE [User] (id int, name varchar(30), primary key(id))"});
        for (int i = 0; i < 500; ++i) {
            this.connection.execute(new String[]{String.format("INSERT INTO [User] VALUES(%s, '%s')", i, "name" + i)});
        }
        TestHelper.enableTableCdc(this.connection, "User");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, "dbo.User")).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(500);
        List user = records.recordsForTopic("server1.dbo.User");
        Assertions.assertThat((List)user).hasSize(500);
        for (int i = 0; i < 500; ++i) {
            SourceRecord record1 = (SourceRecord)user.get(i);
            List<SchemaAndValueField> expectedKey1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)i));
            List<SchemaAndValueField> expectedRow1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)i), new SchemaAndValueField("name", Schema.OPTIONAL_STRING_SCHEMA, (Object)("name" + i)));
            Struct key1 = (Struct)record1.key();
            Struct value1 = (Struct)record1.value();
            this.assertRecord(key1, expectedKey1);
            this.assertRecord((Struct)value1.get("after"), expectedRow1);
            Assertions.assertThat((Map)record1.sourceOffset()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"snapshot", (Object)true), MapAssert.entry((Object)"snapshot_completed", (Object)(i == 499 ? 1 : 0))});
            Assert.assertNull((Object)value1.get("before"));
        }
    }

    @Test
    public void takeSchemaOnlySnapshotAndSendHeartbeat() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(Heartbeat.HEARTBEAT_INTERVAL, 300000)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        SourceRecord record = this.consumeRecord();
        Assertions.assertThat((Object)record).isNotNull();
        Assertions.assertThat((String)record.topic()).startsWith("__debezium-heartbeat");
    }

    @Test
    @FixFor(value={"DBZ-1067"})
    public void testBlacklistColumn() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE blacklist_column_table_a (id int, name varchar(30), amount integer primary key(id))", "CREATE TABLE blacklist_column_table_b (id int, name varchar(30), amount integer primary key(id))"});
        this.connection.execute(new String[]{"INSERT INTO blacklist_column_table_a VALUES(10, 'some_name', 120)"});
        this.connection.execute(new String[]{"INSERT INTO blacklist_column_table_b VALUES(11, 'some_name', 447)"});
        TestHelper.enableTableCdc(this.connection, "blacklist_column_table_a");
        TestHelper.enableTableCdc(this.connection, "blacklist_column_table_b");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.COLUMN_BLACKLIST, "dbo.blacklist_column_table_a.amount")).with(SqlServerConnectorConfig.TABLE_WHITELIST, "dbo.blacklist_column_table_a,dbo.blacklist_column_table_b")).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        List tableA = records.recordsForTopic("server1.dbo.blacklist_column_table_a");
        List tableB = records.recordsForTopic("server1.dbo.blacklist_column_table_b");
        Schema expectedSchemaA = SchemaBuilder.struct().optional().name("server1.dbo.blacklist_column_table_a.Value").field("id", Schema.INT32_SCHEMA).field("name", Schema.OPTIONAL_STRING_SCHEMA).build();
        Struct expectedValueA = new Struct(expectedSchemaA).put("id", (Object)10).put("name", (Object)"some_name");
        Schema expectedSchemaB = SchemaBuilder.struct().optional().name("server1.dbo.blacklist_column_table_b.Value").field("id", Schema.INT32_SCHEMA).field("name", Schema.OPTIONAL_STRING_SCHEMA).field("amount", Schema.OPTIONAL_INT32_SCHEMA).build();
        Struct expectedValueB = new Struct(expectedSchemaB).put("id", (Object)11).put("name", (Object)"some_name").put("amount", (Object)447);
        Assertions.assertThat((List)tableA).hasSize(1);
        SourceRecordAssert.assertThat((SourceRecord)((SourceRecord)tableA.get(0))).valueAfterFieldIsEqualTo(expectedValueA).valueAfterFieldSchemaIsEqualTo(expectedSchemaA);
        Assertions.assertThat((List)tableB).hasSize(1);
        SourceRecordAssert.assertThat((SourceRecord)((SourceRecord)tableB.get(0))).valueAfterFieldIsEqualTo(expectedValueB).valueAfterFieldSchemaIsEqualTo(expectedSchemaB);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-2456"})
    public void shouldSelectivelySnapshotTables() throws SQLException, InterruptedException {
        this.connection.execute(new String[]{"CREATE TABLE table_a (id int, name varchar(30), amount integer primary key(id))", "CREATE TABLE table_b (id int, name varchar(30), amount integer primary key(id))"});
        this.connection.execute(new String[]{"INSERT INTO table_a VALUES(10, 'some_name', 120)"});
        this.connection.execute(new String[]{"INSERT INTO table_b VALUES(11, 'some_name', 447)"});
        TestHelper.enableTableCdc(this.connection, "table_a");
        TestHelper.enableTableCdc(this.connection, "table_b");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.COLUMN_EXCLUDE_LIST, "dbo.table_a.amount")).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.table_a,dbo.table_b")).with(CommonConnectorConfig.SNAPSHOT_MODE_TABLES, "[A-z].*dbo.table_a")).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tableA = records.recordsForTopic("server1.dbo.table_a");
        List tableB = records.recordsForTopic("server1.dbo.table_b");
        Assertions.assertThat((List)tableA).hasSize(1);
        Assertions.assertThat((List)tableB).isNull();
        TestHelper.waitForSnapshotToBeCompleted();
        this.connection.execute(new String[]{"INSERT INTO table_a VALUES(22, 'some_name', 556)"});
        this.connection.execute(new String[]{"INSERT INTO table_b VALUES(24, 'some_name', 558)"});
        records = this.consumeRecordsByTopic(2);
        tableA = records.recordsForTopic("server1.dbo.table_a");
        tableB = records.recordsForTopic("server1.dbo.table_b");
        Assertions.assertThat((List)tableA).hasSize(1);
        Assertions.assertThat((List)tableB).hasSize(1);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-1067"})
    public void testColumnExcludeList() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE blacklist_column_table_a (id int, name varchar(30), amount integer primary key(id))", "CREATE TABLE blacklist_column_table_b (id int, name varchar(30), amount integer primary key(id))"});
        this.connection.execute(new String[]{"INSERT INTO blacklist_column_table_a VALUES(10, 'some_name', 120)"});
        this.connection.execute(new String[]{"INSERT INTO blacklist_column_table_b VALUES(11, 'some_name', 447)"});
        TestHelper.enableTableCdc(this.connection, "blacklist_column_table_a");
        TestHelper.enableTableCdc(this.connection, "blacklist_column_table_b");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.COLUMN_EXCLUDE_LIST, "dbo.blacklist_column_table_a.amount")).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.blacklist_column_table_a,dbo.blacklist_column_table_b")).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        List tableA = records.recordsForTopic("server1.dbo.blacklist_column_table_a");
        List tableB = records.recordsForTopic("server1.dbo.blacklist_column_table_b");
        Schema expectedSchemaA = SchemaBuilder.struct().optional().name("server1.dbo.blacklist_column_table_a.Value").field("id", Schema.INT32_SCHEMA).field("name", Schema.OPTIONAL_STRING_SCHEMA).build();
        Struct expectedValueA = new Struct(expectedSchemaA).put("id", (Object)10).put("name", (Object)"some_name");
        Schema expectedSchemaB = SchemaBuilder.struct().optional().name("server1.dbo.blacklist_column_table_b.Value").field("id", Schema.INT32_SCHEMA).field("name", Schema.OPTIONAL_STRING_SCHEMA).field("amount", Schema.OPTIONAL_INT32_SCHEMA).build();
        Struct expectedValueB = new Struct(expectedSchemaB).put("id", (Object)11).put("name", (Object)"some_name").put("amount", (Object)447);
        Assertions.assertThat((List)tableA).hasSize(1);
        SourceRecordAssert.assertThat((SourceRecord)((SourceRecord)tableA.get(0))).valueAfterFieldIsEqualTo(expectedValueA).valueAfterFieldSchemaIsEqualTo(expectedSchemaA);
        Assertions.assertThat((List)tableB).hasSize(1);
        SourceRecordAssert.assertThat((SourceRecord)((SourceRecord)tableB.get(0))).valueAfterFieldIsEqualTo(expectedValueB).valueAfterFieldSchemaIsEqualTo(expectedSchemaB);
        this.stopConnector();
    }

    @Test
    public void reoderCapturedTables() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE table_a (id int, name varchar(30), amount integer primary key(id))", "CREATE TABLE table_b (id int, name varchar(30), amount integer primary key(id))"});
        this.connection.execute(new String[]{"INSERT INTO table_a VALUES(10, 'some_name', 120)"});
        this.connection.execute(new String[]{"INSERT INTO table_b VALUES(11, 'some_name', 447)"});
        TestHelper.enableTableCdc(this.connection, "table_a");
        TestHelper.enableTableCdc(this.connection, "table_b");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.table_b,dbo.table_a")).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tableA = records.recordsForTopic("server1.dbo.table_a");
        List tableB = records.recordsForTopic("server1.dbo.table_b");
        Assertions.assertThat((List)tableB).hasSize(1);
        Assertions.assertThat((List)tableA).isNull();
        records = this.consumeRecordsByTopic(1);
        tableA = records.recordsForTopic("server1.dbo.table_a");
        Assertions.assertThat((List)tableA).hasSize(1);
        this.stopConnector();
    }

    @Test
    public void reoderCapturedTablesWithOverlappingTableWhitelist() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE table_a (id int, name varchar(30), amount integer primary key(id))", "CREATE TABLE table_ac (id int, name varchar(30), amount integer primary key(id))", "CREATE TABLE table_ab (id int, name varchar(30), amount integer primary key(id))"});
        this.connection.execute(new String[]{"INSERT INTO table_a VALUES(10, 'some_name', 120)"});
        this.connection.execute(new String[]{"INSERT INTO table_ab VALUES(11, 'some_name', 447)"});
        this.connection.execute(new String[]{"INSERT INTO table_ac VALUES(12, 'some_name', 885)"});
        TestHelper.enableTableCdc(this.connection, "table_a");
        TestHelper.enableTableCdc(this.connection, "table_ab");
        TestHelper.enableTableCdc(this.connection, "table_ac");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_INCLUDE_LIST, "dbo.table_ab,dbo.table_(.*)")).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tableA = records.recordsForTopic("server1.dbo.table_a");
        List tableB = records.recordsForTopic("server1.dbo.table_ab");
        List tableC = records.recordsForTopic("server1.dbo.table_ac");
        Assertions.assertThat((List)tableB).hasSize(1);
        Assertions.assertThat((List)tableA).isNull();
        Assertions.assertThat((List)tableC).isNull();
        records = this.consumeRecordsByTopic(1);
        tableA = records.recordsForTopic("server1.dbo.table_a");
        Assertions.assertThat((List)tableA).hasSize(1);
        Assertions.assertThat((List)tableC).isNull();
        records = this.consumeRecordsByTopic(1);
        tableC = records.recordsForTopic("server1.dbo.table_ac");
        Assertions.assertThat((List)tableC).hasSize(1);
        this.stopConnector();
    }

    @Test
    public void reoderCapturedTablesWithoutTableWhitelist() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE table_ac (id int, name varchar(30), amount integer primary key(id))", "CREATE TABLE table_a (id int, name varchar(30), amount integer primary key(id))", "CREATE TABLE table_ab (id int, name varchar(30), amount integer primary key(id))"});
        this.connection.execute(new String[]{"INSERT INTO table_ac VALUES(12, 'some_name', 885)"});
        this.connection.execute(new String[]{"INSERT INTO table_a VALUES(10, 'some_name', 120)"});
        this.connection.execute(new String[]{"INSERT INTO table_ab VALUES(11, 'some_name', 447)"});
        TestHelper.enableTableCdc(this.connection, "table_a");
        TestHelper.enableTableCdc(this.connection, "table_ab");
        TestHelper.enableTableCdc(this.connection, "table_ac");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_EXCLUDE_LIST, "dbo.table1")).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tableA = records.recordsForTopic("server1.dbo.table_a");
        List tableB = records.recordsForTopic("server1.dbo.table_ab");
        List tableC = records.recordsForTopic("server1.dbo.table_ac");
        Assertions.assertThat((List)tableA).hasSize(1);
        Assertions.assertThat((List)tableB).isNull();
        Assertions.assertThat((List)tableC).isNull();
        records = this.consumeRecordsByTopic(1);
        tableB = records.recordsForTopic("server1.dbo.table_ab");
        Assertions.assertThat((List)tableB).hasSize(1);
        Assertions.assertThat((List)tableC).isNull();
        records = this.consumeRecordsByTopic(1);
        tableC = records.recordsForTopic("server1.dbo.table_ac");
        Assertions.assertThat((List)tableC).hasSize(1);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-1292", "DBZ-3157"})
    public void shouldOutputRecordsInCloudEventsFormat() throws Exception {
        Configuration config = TestHelper.defaultConfig().build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(500);
        List snapshotTable1 = snapshotRecords.recordsForTopic("server1.dbo.table1");
        Assertions.assertThat((List)snapshotTable1).hasSize(500);
        for (SourceRecord sourceRecord : snapshotTable1) {
            CloudEventsConverterTest.shouldConvertToCloudEventsInJson((SourceRecord)sourceRecord, (boolean)false);
            CloudEventsConverterTest.shouldConvertToCloudEventsInJsonWithDataAsAvro((SourceRecord)sourceRecord, (boolean)false);
            CloudEventsConverterTest.shouldConvertToCloudEventsInAvro((SourceRecord)sourceRecord, (String)"sqlserver", (String)"server1", (boolean)false);
        }
        for (int i = 0; i < 500; ++i) {
            int id = i + 500;
            this.connection.execute(new String[]{String.format("INSERT INTO table1 VALUES(%s, '%s', %s, '%s')", id, "name" + id, new BigDecimal(id + ".23"), "2018-07-18 13:28:56")});
        }
        AbstractConnectorTest.SourceRecords streamingRecords = this.consumeRecordsByTopic(500);
        List streamingTable1 = streamingRecords.recordsForTopic("server1.dbo.table1");
        Assertions.assertThat((List)streamingTable1).hasSize(500);
        for (SourceRecord sourceRecord : streamingTable1) {
            CloudEventsConverterTest.shouldConvertToCloudEventsInJson((SourceRecord)sourceRecord, (boolean)false, jsonNode -> Assertions.assertThat((String)jsonNode.get("id").asText()).contains("event_serial_no:1"));
            CloudEventsConverterTest.shouldConvertToCloudEventsInJsonWithDataAsAvro((SourceRecord)sourceRecord, (boolean)false);
            CloudEventsConverterTest.shouldConvertToCloudEventsInAvro((SourceRecord)sourceRecord, (String)"sqlserver", (String)"server1", (boolean)false);
        }
    }

    private void assertRecord(Struct record, List<SchemaAndValueField> expected) {
        expected.forEach(schemaAndValueField -> schemaAndValueField.assertFor(record));
    }
}

