/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver.util;

import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SourceTimestampMode;
import io.debezium.connector.sqlserver.SqlServerChangeTable;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Clock;
import io.debezium.util.IoUtil;
import io.debezium.util.Strings;
import io.debezium.util.Testing;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestHelper.class);
    public static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-connect.txt").toAbsolutePath();
    public static final String TEST_DATABASE = "testdb";
    private static final String TEST_PROPERTY_PREFIX = "debezium.test.";
    private static final String STATEMENTS_PLACEHOLDER = "#";
    private static final String ENABLE_DB_CDC = "IF EXISTS(select 1 from sys.databases where name='#' AND is_cdc_enabled=0)\nEXEC sys.sp_cdc_enable_db";
    private static final String DISABLE_DB_CDC = "IF EXISTS(select 1 from sys.databases where name='#' AND is_cdc_enabled=1)\nEXEC sys.sp_cdc_disable_db";
    private static final String ENABLE_TABLE_CDC = "IF EXISTS(select 1 from sys.tables where name = '#' AND is_tracked_by_cdc=0)\nEXEC sys.sp_cdc_enable_table @source_schema = N'dbo', @source_name = N'#', @role_name = NULL, @supports_net_changes = 0";
    private static final String IS_CDC_ENABLED = "SELECT COUNT(1) FROM sys.databases WHERE name = '#' AND is_cdc_enabled=1";
    private static final String IS_CDC_TABLE_ENABLED = "SELECT COUNT(*) FROM sys.tables tb WHERE tb.is_tracked_by_cdc = 1 AND tb.name='#'";
    private static final String ENABLE_TABLE_CDC_WITH_CUSTOM_CAPTURE = "EXEC sys.sp_cdc_enable_table @source_schema = N'dbo', @source_name = N'%s', @capture_instance = N'%s', @role_name = NULL, @supports_net_changes = 0, @captured_column_list = %s";
    private static final String DISABLE_TABLE_CDC = "EXEC sys.sp_cdc_disable_table @source_schema = N'dbo', @source_name = N'#', @capture_instance = 'all'";
    private static final String CDC_WRAPPERS_DML;
    public static final String TYPE_NAME_PARAMETER_KEY = "__debezium.source.column.type";
    public static final String TYPE_LENGTH_PARAMETER_KEY = "__debezium.source.column.length";
    public static final String TYPE_SCALE_PARAMETER_KEY = "__debezium.source.column.scale";

    public static JdbcConfiguration adminJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.DATABASE, "master")).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 1433)).withDefault(JdbcConfiguration.USER, "sa")).withDefault(JdbcConfiguration.PASSWORD, "Password!")).build();
    }

    public static JdbcConfiguration defaultJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.DATABASE, TEST_DATABASE)).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 1433)).withDefault(JdbcConfiguration.USER, "sa")).withDefault(JdbcConfiguration.PASSWORD, "Password!")).build();
    }

    public static Configuration.Builder defaultConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.defaultJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with("database." + field, value));
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.with(RelationalDatabaseConnectorConfig.SERVER_NAME, "server1")).with(SqlServerConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with(RelationalDatabaseConnectorConfig.INCLUDE_SCHEMA_CHANGES, false);
    }

    public static void createTestDatabase() {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            TestHelper.dropTestDatabase(connection);
            String sql = "CREATE DATABASE testDB\n";
            connection.execute(new String[]{sql});
            connection.execute(new String[]{"USE testDB"});
            connection.execute(new String[]{"ALTER DATABASE testDB SET ALLOW_SNAPSHOT_ISOLATION ON"});
            TestHelper.enableDbCdc(connection, "testDB");
        }
        catch (SQLException e) {
            LOGGER.error("Error while initiating test database", (Throwable)e);
            throw new IllegalStateException("Error while initiating test database", e);
        }
    }

    public static void dropTestDatabase() {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            TestHelper.dropTestDatabase(connection);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while dropping test database", e);
        }
    }

    private static void dropTestDatabase(SqlServerConnection connection) throws SQLException {
        try {
            Awaitility.await((String)"Disabling CDC").atMost(60L, TimeUnit.SECONDS).until(() -> {
                try {
                    connection.execute(new String[]{"USE testDB"});
                }
                catch (SQLException e) {
                    return true;
                }
                try {
                    TestHelper.disableDbCdc(connection, "testDB");
                    return true;
                }
                catch (SQLException e) {
                    return false;
                }
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalArgumentException("Failed to disable CDC on testDB", e);
        }
        connection.execute(new String[]{"USE master"});
        try {
            Awaitility.await((String)"Dropping database testDB").atMost(60L, TimeUnit.SECONDS).until(() -> {
                try {
                    String sql = "IF EXISTS(select 1 from sys.databases where name = 'testDB') DROP DATABASE testDB";
                    connection.execute(new String[]{sql});
                    return true;
                }
                catch (SQLException e) {
                    LOGGER.warn("DROP DATABASE testDB failed (will be retried): {}", (Object)e.getMessage());
                    try {
                        connection.execute(new String[]{"ALTER DATABASE testDB SET SINGLE_USER WITH ROLLBACK IMMEDIATE;"});
                    }
                    catch (SQLException e2) {
                        LOGGER.error("Failed to rollback immediately", (Throwable)e2);
                    }
                    return false;
                }
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalStateException("Failed to drop test database", e);
        }
    }

    public static SqlServerConnection adminConnection() {
        return new SqlServerConnection((Configuration)TestHelper.adminJdbcConfig(), Clock.system(), SourceTimestampMode.getDefaultMode(), new SqlServerValueConverters(JdbcValueConverters.DecimalMode.PRECISE, TemporalPrecisionMode.ADAPTIVE, null));
    }

    public static SqlServerConnection testConnection() {
        return new SqlServerConnection((Configuration)TestHelper.defaultJdbcConfig(), Clock.system(), SourceTimestampMode.getDefaultMode(), new SqlServerValueConverters(JdbcValueConverters.DecimalMode.PRECISE, TemporalPrecisionMode.ADAPTIVE, null));
    }

    public static void enableDbCdc(SqlServerConnection connection, String name) throws SQLException {
        try {
            Objects.requireNonNull(name);
            connection.execute(new String[]{ENABLE_DB_CDC.replace(STATEMENTS_PLACEHOLDER, name)});
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> {
                String sql = IS_CDC_ENABLED.replace(STATEMENTS_PLACEHOLDER, name);
                return (Long)connection.queryAndMap(sql, connection.singleResultMapper(rs -> rs.getLong(1), "")) == 1L;
            });
        }
        catch (SQLException e) {
            LOGGER.error("Failed to enable CDC on database " + name);
            throw e;
        }
    }

    protected static void disableDbCdc(SqlServerConnection connection, String name) throws SQLException {
        Objects.requireNonNull(name);
        connection.execute(new String[]{DISABLE_DB_CDC.replace(STATEMENTS_PLACEHOLDER, name)});
    }

    public static void enableTableCdc(SqlServerConnection connection, String name) throws SQLException {
        Objects.requireNonNull(name);
        String enableCdcForTableStmt = ENABLE_TABLE_CDC.replace(STATEMENTS_PLACEHOLDER, name);
        String generateWrapperFunctionsStmts = CDC_WRAPPERS_DML.replaceAll(STATEMENTS_PLACEHOLDER, name.replaceAll("\\$", "\\\\\\$"));
        connection.execute(new String[]{enableCdcForTableStmt, generateWrapperFunctionsStmts});
    }

    public static boolean isCdcEnabled(SqlServerConnection connection, String name) throws SQLException {
        Objects.requireNonNull(name);
        String tableEnabledStmt = IS_CDC_TABLE_ENABLED.replace(STATEMENTS_PLACEHOLDER, name);
        return (Boolean)connection.queryAndMap(tableEnabledStmt, connection.singleResultMapper(rs -> rs.getInt(1) > 0, "Cannot get CDC status of the table"));
    }

    public static void enableTableCdc(SqlServerConnection connection, String tableName, String captureName) throws SQLException {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(captureName);
        String enableCdcForTableStmt = String.format(ENABLE_TABLE_CDC_WITH_CUSTOM_CAPTURE, tableName, captureName, "NULL");
        connection.execute(new String[]{enableCdcForTableStmt});
    }

    public static void enableTableCdc(SqlServerConnection connection, String tableName, String captureName, List<String> captureColumnList) throws SQLException {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(captureName);
        Objects.requireNonNull(captureColumnList);
        String captureColumnListParam = String.format("N'%s'", Strings.join((CharSequence)",", captureColumnList));
        String enableCdcForTableStmt = String.format(ENABLE_TABLE_CDC_WITH_CUSTOM_CAPTURE, tableName, captureName, captureColumnListParam);
        connection.execute(new String[]{enableCdcForTableStmt});
    }

    public static void disableTableCdc(SqlServerConnection connection, String name) throws SQLException {
        Objects.requireNonNull(name);
        String disableCdcForTableStmt = DISABLE_TABLE_CDC.replace(STATEMENTS_PLACEHOLDER, name);
        connection.execute(new String[]{disableCdcForTableStmt});
    }

    public static void waitForSnapshotToBeCompleted() {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Awaitility.await((String)"Snapshot not completed").atMost(Duration.ofSeconds(60L)).until(() -> {
                try {
                    return (boolean)((Boolean)mbeanServer.getAttribute(TestHelper.getObjectName("snapshot", "server1"), "SnapshotCompleted"));
                }
                catch (InstanceNotFoundException e) {
                    return false;
                }
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalArgumentException("Snapshot did not complete", e);
        }
    }

    public static void waitForStreamingStarted() {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Awaitility.await((String)"Streaming never started").atMost(Duration.ofSeconds(60L)).until(() -> {
                try {
                    return (boolean)((Boolean)mbeanServer.getAttribute(TestHelper.getObjectName("streaming", "server1"), "Connected"));
                }
                catch (InstanceNotFoundException e) {
                    return false;
                }
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalArgumentException("Streaming did not start", e);
        }
    }

    public static void waitForMaxLsnAvailable(SqlServerConnection connection) throws Exception {
        try {
            Awaitility.await((String)"Max LSN not available").atMost(60L, TimeUnit.SECONDS).pollDelay(Duration.ofSeconds(0L)).pollInterval(Duration.ofMillis(100L)).until(() -> connection.getMaxLsn().isAvailable());
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalArgumentException("A max LSN was not available", e);
        }
    }

    private static ObjectName getObjectName(String context, String serverName) throws MalformedObjectNameException {
        return new ObjectName("debezium.sql_server:type=connector-metrics,context=" + context + ",server=" + serverName);
    }

    public static int waitTimeForRecords() {
        return Integer.parseInt(System.getProperty("debezium.test.records.waittime", "5"));
    }

    public static void waitForCdcRecord(SqlServerConnection connection, String tableName, CdcRecordHandler handler) {
        try {
            Awaitility.await((String)("Checking for expected record in CDC table for " + tableName)).atMost(60L, TimeUnit.SECONDS).pollDelay(Duration.ofSeconds(0L)).pollInterval(Duration.ofMillis(100L)).until(() -> {
                if (!connection.getMaxLsn().isAvailable()) {
                    return false;
                }
                for (SqlServerChangeTable ct : connection.listOfChangeTables()) {
                    String ctTableName = ct.getChangeTableId().table();
                    if (!ctTableName.endsWith("dbo_" + connection.getNameOfChangeTable(tableName))) continue;
                    try {
                        Lsn minLsn = connection.getMinLsn(ctTableName);
                        Lsn maxLsn = connection.getMaxLsn();
                        CdcRecordFoundBlockingMultiResultSetConsumer consumer = new CdcRecordFoundBlockingMultiResultSetConsumer(handler);
                        SqlServerChangeTable[] tables = Collections.singletonList(ct).toArray(new SqlServerChangeTable[0]);
                        connection.getChangesForTables(tables, minLsn, maxLsn, (JdbcConnection.BlockingMultiResultSetConsumer)consumer);
                        return consumer.isFound();
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("An insufficient number of arguments were supplied")) {
                            return false;
                        }
                        throw new AssertionError("Failed to fetch changes for " + tableName, e);
                    }
                }
                return false;
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalStateException("Expected record never appeared in the CDC table", e);
        }
    }

    public static void waitForCdcRecord(SqlServerConnection connection, String tableName, String captureInstanceName, CdcRecordHandler handler) {
        try {
            Awaitility.await((String)("Checking for expected record in CDC table for " + tableName)).atMost(30L, TimeUnit.SECONDS).pollDelay(Duration.ofSeconds(0L)).pollInterval(Duration.ofMillis(100L)).until(() -> {
                if (!connection.getMaxLsn().isAvailable()) {
                    return false;
                }
                for (SqlServerChangeTable ct : connection.listOfChangeTables()) {
                    String ctTableName = ct.getChangeTableId().table();
                    if (!ctTableName.endsWith(connection.getNameOfChangeTable(captureInstanceName))) continue;
                    try {
                        Lsn minLsn = connection.getMinLsn(ctTableName);
                        Lsn maxLsn = connection.getMaxLsn();
                        CdcRecordFoundBlockingMultiResultSetConsumer consumer = new CdcRecordFoundBlockingMultiResultSetConsumer(handler);
                        SqlServerChangeTable[] tables = Collections.singletonList(ct).toArray(new SqlServerChangeTable[0]);
                        connection.getChangesForTables(tables, minLsn, maxLsn, (JdbcConnection.BlockingMultiResultSetConsumer)consumer);
                        return consumer.isFound();
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("An insufficient number of arguments were supplied")) {
                            return false;
                        }
                        throw new AssertionError("Failed to fetch changes for " + tableName, e);
                    }
                }
                return false;
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalStateException("Expected record never appeared in the CDC table", e);
        }
    }

    static {
        try {
            ClassLoader classLoader = TestHelper.class.getClassLoader();
            CDC_WRAPPERS_DML = IoUtil.read((InputStream)classLoader.getResourceAsStream("generate_cdc_wrappers.sql"));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load SQL Server statements", e);
        }
    }

    static class CdcRecordFoundBlockingMultiResultSetConsumer
    implements JdbcConnection.BlockingMultiResultSetConsumer {
        private final CdcRecordHandler handler;
        private boolean found;

        public CdcRecordFoundBlockingMultiResultSetConsumer(CdcRecordHandler handler) {
            this.handler = handler;
        }

        public void accept(ResultSet[] rs) throws SQLException, InterruptedException {
            if (rs.length == 1) {
                ResultSet resultSet = rs[0];
                while (resultSet.next()) {
                    if (!this.handler.apply(resultSet)) continue;
                    this.found = true;
                    break;
                }
            }
        }

        public boolean isFound() {
            return this.found;
        }
    }

    @FunctionalInterface
    public static interface CdcRecordHandler {
        public boolean apply(ResultSet var1) throws SQLException;
    }
}

