/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.SqlServerChangeTable;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class SqlServerConnectionIT {
    private ZoneOffset databaseZoneOffset;

    @Before
    public void before() throws SQLException {
        this.databaseZoneOffset = this.getDatabaseZoneOffset();
        TestHelper.dropTestDatabase();
    }

    private ZoneOffset getDatabaseZoneOffset() throws SQLException {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            int datetimeoffset = (Integer)connection.queryAndMap("SELECT DATEPART(TZoffset, SYSDATETIME())", rs -> {
                rs.next();
                return rs.getInt(1);
            });
            ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(datetimeoffset * 60);
            return zoneOffset;
        }
    }

    @Test
    public void shouldEnableCdcForDatabase() throws Exception {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            connection.execute(new String[]{"CREATE DATABASE testDB"});
            connection.execute(new String[]{"USE testDB"});
            TestHelper.enableDbCdc(connection, "testDB");
        }
    }

    @Test
    public void shouldEnableCdcWithWrapperFunctionsForTable() throws Exception {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            connection.execute(new String[]{"CREATE DATABASE testDB"});
            connection.execute(new String[]{"USE testDB"});
            TestHelper.enableDbCdc(connection, "testDB");
            String sql = "IF EXISTS (select 1 from sys.objects where name = 'testTable' and type = 'u')\nDROP TABLE testTable\nCREATE TABLE testTable (ID int not null identity(1, 1) primary key, NUMBER int, TEXT text)";
            connection.execute(new String[]{sql});
            TestHelper.enableTableCdc(connection, "testTable");
            connection.execute(new String[]{"INSERT INTO testTable (NUMBER, TEXT) values (1, 'aaa')\nINSERT INTO testTable (NUMBER, TEXT) values (2, 'bbb')"});
            Thread.sleep(5000L);
            Testing.Print.enable();
            connection.query("select * from cdc.fn_cdc_get_all_changes_dbo_testTable(sys.fn_cdc_get_min_lsn('dbo_testTable'), sys.fn_cdc_get_max_lsn(), N'all')", rs -> {
                while (rs.next()) {
                    BigInteger lsn = new BigInteger(rs.getBytes(1));
                    StringBuilder sb = new StringBuilder(lsn.toString());
                    for (int col = 1; col <= rs.getMetaData().getColumnCount(); ++col) {
                        sb.append(rs.getObject(col)).append(' ');
                    }
                    Testing.print((Object)sb.toString());
                }
            });
            Testing.Print.disable();
        }
    }

    @Test
    @FixFor(value={"DBZ-1491"})
    public void shouldProperlyGetDefaultColumnValues() throws Exception {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            connection.execute(new String[]{"CREATE DATABASE testDB"});
            connection.execute(new String[]{"USE testDB"});
        }
        connection = TestHelper.testConnection();
        var2_2 = null;
        try {
            connection.connect();
            TestHelper.enableDbCdc(connection, "testDB");
            String sql = "IF EXISTS (select 1 from sys.objects where name = 'table_with_defaults' and type = 'u')\nDROP TABLE testTable\nCREATE TABLE testDB.dbo.table_with_defaults (    int_no_default_not_null int not null,    int_no_default int,    bigint_column bigint default (3147483648),    int_column int default (2147483647),    smallint_column smallint default (32767),    tinyint_column tinyint default (255),    bit_column bit default(1),    decimal_column decimal(20,5) default (100.12345),    numeric_column numeric(10,3) default (200.123),    money_column money default (922337203685477.58),    smallmoney_column smallmoney default (214748.3647),    float_column float default (1.2345e2),    real_column real default (1.2345e3),    date_column date default ('2019-02-03'),    datetime_column datetime default ('2019-01-01 12:34:56.789'),    datetime2_column datetime2 default ('2019-01-01 12:34:56.1234567'),    datetime2_0_column datetime2(0) default ('2019-01-01 12:34:56'),    datetime2_1_column datetime2(1) default ('2019-01-01 12:34:56.1'),    datetime2_2_column datetime2(2) default ('2019-01-01 12:34:56.12'),    datetime2_3_column datetime2(3) default ('2019-01-01 12:34:56.123'),    datetime2_4_column datetime2(4) default ('2019-01-01 12:34:56.1234'),    datetime2_5_column datetime2(5) default ('2019-01-01 12:34:56.12345'),    datetime2_6_column datetime2(6) default ('2019-01-01 12:34:56.123456'),    datetime2_7_column datetime2(7) default ('2019-01-01 12:34:56.1234567'),    datetimeoffset_column datetimeoffset default ('2019-01-01 00:00:00.1234567+02:00'),    smalldatetime_column smalldatetime default ('2019-01-01 12:34:00'),    time_column time default ('12:34:56.1234567'),    time_0_column time(0) default ('12:34:56'),    time_1_column time(1) default ('12:34:56.1'),    time_2_column time(2) default ('12:34:56.12'),    time_3_column time(3) default ('12:34:56.123'),    time_4_column time(4) default ('12:34:56.1234'),    time_5_column time(5) default ('12:34:56.12345'),    time_6_column time(6) default ('12:34:56.123456'),    time_7_column time(7) default ('12:34:56.1234567'),    char_column char(3) default ('aaa'),    varchar_column varchar(20) default ('bbb'),    text_column text default ('ccc'),    nchar_column nchar(3) default ('ddd'),    nvarchar_column nvarchar(20) default ('eee'),    ntext_column ntext default ('fff'),    binary_column binary(5) default (0x0102030405),    varbinary_column varbinary(10) default (0x010203040506),    image_column image default (0x01020304050607));";
            connection.execute(new String[]{sql});
            TestHelper.enableTableCdc(connection, "table_with_defaults");
            Thread.sleep(5000L);
            List<String> capturedColumns = Arrays.asList("int_no_default_not_null", "int_no_default", "bigint_column", "int_column", "smallint_column", "tinyint_column", "bit_column", "decimal_column", "numeric_column", "money_column", "smallmoney_column", "float_column", "real_column", "date_column", "datetime_column", "datetime2_column", "datetime2_0_column", "datetime2_1_column", "datetime2_2_column", "datetime2_3_column", "datetime2_4_column", "datetime2_5_column", "datetime2_6_column", "datetime2_7_column", "datetimeoffset_column", "smalldatetime_column", "time_column", "time_0_column", "time_1_column", "time_2_column", "time_3_column", "time_4_column", "time_5_column", "time_6_column", "time_7_column", "char_column", "varchar_column", "text_column", "nchar_column", "nvarchar_column", "ntext_column", "binary_column", "varbinary_column", "image_column");
            SqlServerChangeTable changeTable = new SqlServerChangeTable(new TableId("testDB", "dbo", "table_with_defaults"), null, 0, null, null, capturedColumns);
            Table table = connection.getTableSchemaFromTable(changeTable);
            this.assertColumnHasNotDefaultValue(table, "int_no_default_not_null");
            this.assertColumnHasDefaultValue(table, "int_no_default", null);
            this.assertColumnHasDefaultValue(table, "bigint_column", 3147483648L);
            this.assertColumnHasDefaultValue(table, "int_column", Integer.MAX_VALUE);
            this.assertColumnHasDefaultValue(table, "smallint_column", (short)Short.MAX_VALUE);
            this.assertColumnHasDefaultValue(table, "tinyint_column", (short)255);
            this.assertColumnHasDefaultValue(table, "bit_column", true);
            this.assertColumnHasDefaultValue(table, "decimal_column", new BigDecimal("100.12345"));
            this.assertColumnHasDefaultValue(table, "numeric_column", new BigDecimal("200.123"));
            this.assertColumnHasDefaultValue(table, "money_column", new BigDecimal("922337203685477.58"));
            this.assertColumnHasDefaultValue(table, "smallmoney_column", new BigDecimal("214748.3647"));
            this.assertColumnHasDefaultValue(table, "float_column", 123.45);
            this.assertColumnHasDefaultValue(table, "real_column", Float.valueOf(1234.5f));
            this.assertColumnHasDefaultValue(table, "date_column", 17930);
            this.assertColumnHasDefaultValue(table, "datetime_column", this.toMillis(OffsetDateTime.of(2019, 1, 1, 12, 34, 56, 790000000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "datetime2_column", this.toNanos(OffsetDateTime.of(2019, 1, 1, 12, 34, 56, 123456700, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "datetime2_0_column", this.toMillis(OffsetDateTime.of(2019, 1, 1, 12, 34, 56, 0, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "datetime2_1_column", this.toMillis(OffsetDateTime.of(2019, 1, 1, 12, 34, 56, 100000000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "datetime2_2_column", this.toMillis(OffsetDateTime.of(2019, 1, 1, 12, 34, 56, 120000000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "datetime2_3_column", this.toMillis(OffsetDateTime.of(2019, 1, 1, 12, 34, 56, 123000000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "datetime2_4_column", this.toMicros(OffsetDateTime.of(2019, 1, 1, 12, 34, 56, 123400000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "datetime2_5_column", this.toMicros(OffsetDateTime.of(2019, 1, 1, 12, 34, 56, 123450000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "datetime2_6_column", this.toMicros(OffsetDateTime.of(2019, 1, 1, 12, 34, 56, 123456000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "datetime2_7_column", this.toNanos(OffsetDateTime.of(2019, 1, 1, 12, 34, 56, 123456700, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "datetimeoffset_column", "2019-01-01T00:00:00.1234567+02:00");
            this.assertColumnHasDefaultValue(table, "smalldatetime_column", this.toMillis(OffsetDateTime.of(2019, 1, 1, 12, 34, 0, 0, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "time_column", this.toNanos(OffsetDateTime.of(1970, 1, 1, 12, 34, 56, 123000000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "time_0_column", (int)this.toMillis(OffsetDateTime.of(1970, 1, 1, 12, 34, 56, 0, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "time_1_column", (int)this.toMillis(OffsetDateTime.of(1970, 1, 1, 12, 34, 56, 100000000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "time_2_column", (int)this.toMillis(OffsetDateTime.of(1970, 1, 1, 12, 34, 56, 120000000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "time_3_column", (int)this.toMillis(OffsetDateTime.of(1970, 1, 1, 12, 34, 56, 123000000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "time_4_column", this.toMicros(OffsetDateTime.of(1970, 1, 1, 12, 34, 56, 123000000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "time_5_column", this.toMicros(OffsetDateTime.of(1970, 1, 1, 12, 34, 56, 123000000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "time_6_column", this.toMicros(OffsetDateTime.of(1970, 1, 1, 12, 34, 56, 123000000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "time_7_column", this.toNanos(OffsetDateTime.of(1970, 1, 1, 12, 34, 56, 123000000, this.databaseZoneOffset)));
            this.assertColumnHasDefaultValue(table, "char_column", "aaa");
            this.assertColumnHasDefaultValue(table, "varchar_column", "bbb");
            this.assertColumnHasDefaultValue(table, "text_column", "ccc");
            this.assertColumnHasDefaultValue(table, "nchar_column", "ddd");
            this.assertColumnHasDefaultValue(table, "nvarchar_column", "eee");
            this.assertColumnHasDefaultValue(table, "ntext_column", "fff");
            this.assertColumnHasDefaultValue(table, "binary_column", ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5}));
            this.assertColumnHasDefaultValue(table, "varbinary_column", ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5, 6}));
            this.assertColumnHasDefaultValue(table, "image_column", ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5, 6, 7}));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                if (var2_2 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    connection.close();
                }
            }
        }
    }

    private long toMillis(OffsetDateTime datetime) {
        return datetime.toInstant().toEpochMilli();
    }

    private long toMicros(OffsetDateTime datetime) {
        Instant instant = datetime.toInstant();
        long seconds = instant.toEpochMilli() / 1000L;
        long micros = (long)instant.getNano() / 1000L;
        return seconds * 1000000L + micros;
    }

    private long toNanos(OffsetDateTime datetime) {
        Instant instant = datetime.toInstant();
        long seconds = instant.toEpochMilli() / 1000L;
        long nanos = instant.getNano();
        return seconds * 1000000000L + nanos;
    }

    private void assertColumnHasNotDefaultValue(Table table, String columnName) {
        Column column = table.columnWithName(columnName);
        Assertions.assertThat((boolean)column.hasDefaultValue()).isFalse();
    }

    private void assertColumnHasDefaultValue(Table table, String columnName, Object expectedValue) {
        Column column = table.columnWithName(columnName);
        Assertions.assertThat((boolean)column.hasDefaultValue()).isTrue();
        Assertions.assertThat((Object)column.defaultValue()).isEqualTo(expectedValue);
    }
}

