/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.filter;

import io.debezium.DebeziumException;
import io.debezium.transforms.filter.Engine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.kafka.connect.connector.ConnectRecord;

public class Jsr223Engine
implements Engine {
    private String expression;
    private CompiledScript script;
    protected ScriptEngine engine;

    @Override
    public void configure(String language, String expression) {
        this.expression = expression;
        ScriptEngineManager factory = new ScriptEngineManager();
        this.engine = factory.getEngineByName(language);
        if (this.engine == null) {
            throw new DebeziumException("Implementation of language '" + language + "' not found on the classpath");
        }
        this.configureEngine();
        if (this.engine instanceof Compilable) {
            try {
                this.script = ((Compilable)((Object)this.engine)).compile(expression);
            }
            catch (ScriptException e) {
                throw new DebeziumException((Throwable)e);
            }
        }
    }

    protected void configureEngine() {
    }

    @Override
    public boolean eval(ConnectRecord<?> record) {
        Bindings binding = this.engine.createBindings();
        binding.put("key", record.key());
        binding.put("value", record.value());
        binding.put("keySchema", (Object)record.keySchema());
        binding.put("valueSchema", (Object)record.valueSchema());
        try {
            Object result;
            Object object = result = this.script != null ? this.script.eval(binding) : this.engine.eval(this.expression, binding);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new DebeziumException("Value '" + result + "' returned by the condition is not a boolean");
        }
        catch (Exception e) {
            throw new DebeziumException("Error while evaluating expression '" + this.expression + "' for record '" + record + "'", (Throwable)e);
        }
    }
}

