/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.sqlserver.Module;
import io.debezium.connector.sqlserver.SqlServerChangeEventSourceFactory;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerEventMetadataProvider;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerTaskContext;
import io.debezium.connector.sqlserver.SqlServerTopicSelector;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnectorTask
extends BaseSourceTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnectorTask.class);
    private static final String CONTEXT_NAME = "sql-server-connector-task";
    private volatile SqlServerTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile SqlServerConnection dataConnection;
    private volatile SqlServerConnection metadataConnection;
    private volatile ChangeEventSourceCoordinator coordinator;
    private volatile ErrorHandler errorHandler;
    private volatile SqlServerDatabaseSchema schema;

    public String version() {
        return Module.version();
    }

    public ChangeEventSourceCoordinator start(Configuration config) {
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(config);
        TopicSelector<TableId> topicSelector = SqlServerTopicSelector.defaultSelector(connectorConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create((Logger)LOGGER);
        config = ((Configuration.Builder)config.edit().withDefault("database.responseBuffering", "adaptive").withDefault("database.fetchSize", 10000)).build();
        Configuration jdbcConfig = config.filter(x -> !x.startsWith("database.history.") && !x.equals(HistorizedRelationalDatabaseConnectorConfig.DATABASE_HISTORY.name())).subset("database.", true);
        this.dataConnection = new SqlServerConnection(jdbcConfig);
        this.metadataConnection = new SqlServerConnection(jdbcConfig);
        try {
            this.dataConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new ConnectException((Throwable)e);
        }
        this.schema = new SqlServerDatabaseSchema(connectorConfig, schemaNameAdjuster, topicSelector, this.dataConnection);
        this.schema.initializeStorage();
        OffsetContext previousOffset = this.getPreviousOffset(new SqlServerOffsetContext.Loader(connectorConfig));
        if (previousOffset != null) {
            this.schema.recover(previousOffset);
        }
        this.taskContext = new SqlServerTaskContext(connectorConfig, this.schema);
        Clock clock = Clock.system();
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        this.errorHandler = new ErrorHandler(SqlServerConnector.class, connectorConfig.getLogicalName(), this.queue, this::cleanupResources);
        EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, topicSelector, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new);
        this.coordinator = new ChangeEventSourceCoordinator(previousOffset, this.errorHandler, SqlServerConnector.class, connectorConfig.getLogicalName(), (ChangeEventSourceFactory)new SqlServerChangeEventSourceFactory(connectorConfig, this.dataConnection, this.metadataConnection, this.errorHandler, (EventDispatcher<TableId>)dispatcher, clock, this.schema), dispatcher, (RelationalDatabaseSchema)this.schema);
        this.coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)new SqlServerEventMetadataProvider());
        return this.coordinator;
    }

    protected OffsetContext getPreviousOffset(OffsetContext.Loader loader) {
        Map partition = loader.getPartition();
        Map previousOffset = (Map)this.context.offsetStorageReader().offsets(Collections.singleton(partition)).get(partition);
        if (previousOffset != null) {
            OffsetContext offsetContext = loader.load(previousOffset);
            LOGGER.info("Found previous offset {}", (Object)offsetContext);
            return offsetContext;
        }
        return null;
    }

    public List<SourceRecord> poll() throws InterruptedException {
        List records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    public void stop() {
        this.cleanupResources();
    }

    private void cleanupResources() {
        if (!this.state.compareAndSet(BaseSourceTask.State.RUNNING, BaseSourceTask.State.STOPPED)) {
            LOGGER.info("Connector has already been stopped");
            return;
        }
        try {
            if (this.coordinator != null) {
                this.coordinator.stop();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted while stopping coordinator", (Throwable)e);
            throw new ConnectException("Interrupted while stopping coordinator, failing the task");
        }
        try {
            if (this.errorHandler != null) {
                this.errorHandler.stop();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted while stopping", (Throwable)e);
        }
        try {
            if (this.dataConnection != null) {
                this.dataConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC connection", (Throwable)e);
        }
        try {
            if (this.metadataConnection != null) {
                this.metadataConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC metadata connection", (Throwable)e);
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return SqlServerConnectorConfig.ALL_FIELDS;
    }
}

