/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public final class SQLServerDataSourceObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object ref, Name name, Context c, Hashtable<?, ?> h) throws SQLServerException {
        try {
            String className;
            Reference r = (Reference)ref;
            RefAddr ra = r.get("class");
            if (null == ra) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDataSourceReference"), null, true);
            }
            if (null == (className = (String)ra.getContent())) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDataSourceReference"), null, true);
            }
            if ("com.microsoft.sqlserver.jdbc.SQLServerDataSource".equals(className) || "com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource".equals(className) || "com.microsoft.sqlserver.jdbc.SQLServerXADataSource".equals(className)) {
                Class<?> dataSourceClass = Class.forName(className);
                Object dataSourceClassInstance = dataSourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                SQLServerDataSource ds = (SQLServerDataSource)dataSourceClassInstance;
                ds.initializeFromReference(r);
                return dataSourceClassInstance;
            }
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDataSourceReference"), null, true);
        }
        catch (ClassNotFoundException e) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDataSourceReference"), null, true);
        }
        catch (InstantiationException e) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDataSourceReference"), null, true);
        }
        catch (IllegalAccessException e) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDataSourceReference"), null, true);
        }
        catch (IllegalArgumentException e) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDataSourceReference"), null, true);
        }
        catch (InvocationTargetException e) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDataSourceReference"), null, true);
        }
        catch (NoSuchMethodException e) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDataSourceReference"), null, true);
        }
        catch (SecurityException e) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDataSourceReference"), null, true);
        }
        return null;
    }
}

