/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.data.SchemaAndValueField;
import io.debezium.data.SourceRecordAssert;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.time.Timestamp;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.fest.assertions.MapAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SnapshotIT
extends AbstractConnectorTest {
    private static final int INITIAL_RECORDS_PER_TABLE = 500;
    private static final int STREAMING_RECORDS_PER_TABLE = 500;
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE table1 (id int, name varchar(30), price decimal(8,2), ts datetime2(0), primary key(id))"});
        for (int i = 0; i < 500; ++i) {
            this.connection.execute(new String[]{String.format("INSERT INTO table1 VALUES(%s, '%s', %s, '%s')", i, "name" + i, new BigDecimal(i + ".23"), "2018-07-18 13:28:56")});
        }
        TestHelper.enableTableCdc(this.connection, "table1");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void takeSnapshotInExclusiveMode() throws Exception {
        this.takeSnapshot(SqlServerConnectorConfig.SnapshotIsolationMode.EXCLUSIVE);
    }

    @Test
    public void takeSnapshotInSnapshotMode() throws Exception {
        this.takeSnapshot(SqlServerConnectorConfig.SnapshotIsolationMode.SNAPSHOT);
    }

    @Test
    public void takeSnapshotInRepeatableReadMode() throws Exception {
        this.takeSnapshot(SqlServerConnectorConfig.SnapshotIsolationMode.REPEATABLE_READ);
    }

    @Test
    public void takeSnapshotInReadUncommittedMode() throws Exception {
        this.takeSnapshot(SqlServerConnectorConfig.SnapshotIsolationMode.READ_UNCOMMITTED);
    }

    private void takeSnapshot(SqlServerConnectorConfig.SnapshotIsolationMode lockingMode) throws Exception {
        Configuration config = TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_ISOLATION_MODE.name(), lockingMode.getValue()).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(500);
        List table1 = records.recordsForTopic("server1.dbo.table1");
        Assertions.assertThat((List)table1).hasSize(500);
        for (int i = 0; i < 500; ++i) {
            SourceRecord record1 = (SourceRecord)table1.get(i);
            List<SchemaAndValueField> expectedKey1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)i));
            List<SchemaAndValueField> expectedRow1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)i), new SchemaAndValueField("name", Schema.OPTIONAL_STRING_SCHEMA, (Object)("name" + i)), new SchemaAndValueField("price", Decimal.builder((int)2).parameter("connect.decimal.precision", "8").optional().build(), (Object)new BigDecimal(i + ".23")), new SchemaAndValueField("ts", Timestamp.builder().optional().schema(), (Object)1531920536000L));
            Struct key1 = (Struct)record1.key();
            Struct value1 = (Struct)record1.value();
            this.assertRecord(key1, expectedKey1);
            this.assertRecord((Struct)value1.get("after"), expectedRow1);
            Assertions.assertThat((Map)record1.sourceOffset()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"snapshot", (Object)true), MapAssert.entry((Object)"snapshot_completed", (Object)(i == 499 ? 1 : 0))});
            Assert.assertNull((Object)value1.get("before"));
        }
    }

    @Test
    public void takeSnapshotAndStartStreaming() throws Exception {
        Configuration config = TestHelper.defaultConfig().build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.consumeRecordsByTopic(500);
        this.testStreaming();
    }

    private void testStreaming() throws SQLException, InterruptedException {
        for (int i = 0; i < 500; ++i) {
            int id = i + 500;
            this.connection.execute(new String[]{String.format("INSERT INTO table1 VALUES(%s, '%s', %s, '%s')", id, "name" + id, new BigDecimal(id + ".23"), "2018-07-18 13:28:56")});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(500);
        List table1 = records.recordsForTopic("server1.dbo.table1");
        Assertions.assertThat((List)table1).hasSize(500);
        for (int i = 0; i < 500; ++i) {
            int id = i + 500;
            SourceRecord record1 = (SourceRecord)table1.get(i);
            List<SchemaAndValueField> expectedKey1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id));
            List<SchemaAndValueField> expectedRow1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id), new SchemaAndValueField("name", Schema.OPTIONAL_STRING_SCHEMA, (Object)("name" + id)), new SchemaAndValueField("price", Decimal.builder((int)2).parameter("connect.decimal.precision", "8").optional().build(), (Object)new BigDecimal(id + ".23")), new SchemaAndValueField("ts", Timestamp.builder().optional().schema(), (Object)1531920536000L));
            Struct key1 = (Struct)record1.key();
            Struct value1 = (Struct)record1.value();
            this.assertRecord(key1, expectedKey1);
            this.assertRecord((Struct)value1.get("after"), expectedRow1);
            Assertions.assertThat((Map)record1.sourceOffset()).hasSize(2);
            Assert.assertTrue((boolean)record1.sourceOffset().containsKey("change_lsn"));
            Assert.assertTrue((boolean)record1.sourceOffset().containsKey("commit_lsn"));
            Assert.assertNull((Object)value1.get("before"));
        }
    }

    @Test
    public void takeSchemaOnlySnapshotAndStartStreaming() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        this.testStreaming();
    }

    @Test
    @FixFor(value={"DBZ-1031"})
    public void takeSnapshotFromTableWithReservedName() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE [User] (id int, name varchar(30), primary key(id))"});
        for (int i = 0; i < 500; ++i) {
            this.connection.execute(new String[]{String.format("INSERT INTO [User] VALUES(%s, '%s')", i, "name" + i)});
        }
        TestHelper.enableTableCdc(this.connection, "User");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        Configuration config = TestHelper.defaultConfig().with("table.whitelist", "dbo.User").build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(500);
        List user = records.recordsForTopic("server1.dbo.User");
        Assertions.assertThat((List)user).hasSize(500);
        for (int i = 0; i < 500; ++i) {
            SourceRecord record1 = (SourceRecord)user.get(i);
            List<SchemaAndValueField> expectedKey1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)i));
            List<SchemaAndValueField> expectedRow1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)i), new SchemaAndValueField("name", Schema.OPTIONAL_STRING_SCHEMA, (Object)("name" + i)));
            Struct key1 = (Struct)record1.key();
            Struct value1 = (Struct)record1.value();
            this.assertRecord(key1, expectedKey1);
            this.assertRecord((Struct)value1.get("after"), expectedRow1);
            Assertions.assertThat((Map)record1.sourceOffset()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"snapshot", (Object)true), MapAssert.entry((Object)"snapshot_completed", (Object)(i == 499 ? 1 : 0))});
            Assert.assertNull((Object)value1.get("before"));
        }
    }

    @Test
    public void takeSchemaOnlySnapshotAndSendHeartbeat() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).with(Heartbeat.HEARTBEAT_INTERVAL, 300000)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        SourceRecord record = this.consumeRecord();
        Assertions.assertThat((Object)record).isNotNull();
        Assertions.assertThat((String)record.topic()).startsWith("__debezium-heartbeat");
    }

    @Test
    @FixFor(value={"DBZ-1067"})
    public void blacklistColumn() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE blacklist_column_table_a (id int, name varchar(30), amount integer primary key(id))", "CREATE TABLE blacklist_column_table_b (id int, name varchar(30), amount integer primary key(id))"});
        this.connection.execute(new String[]{"INSERT INTO blacklist_column_table_a VALUES(10, 'some_name', 120)"});
        this.connection.execute(new String[]{"INSERT INTO blacklist_column_table_b VALUES(11, 'some_name', 447)"});
        TestHelper.enableTableCdc(this.connection, "blacklist_column_table_a");
        TestHelper.enableTableCdc(this.connection, "blacklist_column_table_b");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.COLUMN_BLACKLIST, "dbo.blacklist_column_table_a.amount")).with(SqlServerConnectorConfig.TABLE_WHITELIST, "dbo.blacklist_column_table_a,dbo.blacklist_column_table_b")).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        List tableA = records.recordsForTopic("server1.dbo.blacklist_column_table_a");
        List tableB = records.recordsForTopic("server1.dbo.blacklist_column_table_b");
        Schema expectedSchemaA = SchemaBuilder.struct().optional().name("server1.dbo.blacklist_column_table_a.Value").field("id", Schema.INT32_SCHEMA).field("name", Schema.OPTIONAL_STRING_SCHEMA).build();
        Struct expectedValueA = new Struct(expectedSchemaA).put("id", (Object)10).put("name", (Object)"some_name");
        Schema expectedSchemaB = SchemaBuilder.struct().optional().name("server1.dbo.blacklist_column_table_b.Value").field("id", Schema.INT32_SCHEMA).field("name", Schema.OPTIONAL_STRING_SCHEMA).field("amount", Schema.OPTIONAL_INT32_SCHEMA).build();
        Struct expectedValueB = new Struct(expectedSchemaB).put("id", (Object)11).put("name", (Object)"some_name").put("amount", (Object)447);
        Assertions.assertThat((List)tableA).hasSize(1);
        SourceRecordAssert.assertThat((SourceRecord)((SourceRecord)tableA.get(0))).valueAfterFieldIsEqualTo(expectedValueA).valueAfterFieldSchemaIsEqualTo(expectedSchemaA);
        Assertions.assertThat((List)tableB).hasSize(1);
        SourceRecordAssert.assertThat((SourceRecord)((SourceRecord)tableB.get(0))).valueAfterFieldIsEqualTo(expectedValueB).valueAfterFieldSchemaIsEqualTo(expectedSchemaB);
        this.stopConnector();
    }

    private void assertRecord(Struct record, List<SchemaAndValueField> expected) {
        expected.forEach(schemaAndValueField -> schemaAndValueField.assertFor(record));
    }
}

