/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.text;

import io.debezium.annotation.Immutable;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.function.BooleanConsumer;
import io.debezium.text.ParsingException;
import io.debezium.text.Position;
import io.debezium.text.XmlCharacters;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

@NotThreadSafe
public class TokenStream {
    public static final String ANY_VALUE = "any value";
    public static final int ANY_TYPE = Integer.MIN_VALUE;
    protected final String inputString;
    private final char[] inputContent;
    private final boolean caseSensitive;
    private final Tokenizer tokenizer;
    private List<Token> tokens;
    private ListIterator<Token> tokenIterator;
    private Token currentToken;
    private boolean completed;

    public TokenStream(String content, Tokenizer tokenizer, boolean caseSensitive) {
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(tokenizer, "tokenizer");
        this.inputString = content;
        this.inputContent = content.toCharArray();
        this.caseSensitive = caseSensitive;
        this.tokenizer = tokenizer;
    }

    public TokenStream start() throws ParsingException {
        if (this.tokens == null) {
            TokenFactory tokenFactory = this.caseSensitive ? new CaseSensitiveTokenFactory() : new CaseInsensitiveTokenFactory();
            CharacterArrayStream characterStream = new CharacterArrayStream(this.inputContent);
            this.tokenizer.tokenize(characterStream, tokenFactory);
            this.tokens = this.initializeTokens(tokenFactory.getTokens());
        }
        this.tokenIterator = this.tokens.listIterator();
        this.moveToNextToken();
        return this;
    }

    protected List<Token> initializeTokens(List<Token> tokens) {
        return tokens;
    }

    public void rewind() {
        this.tokenIterator = this.tokens.listIterator();
        this.completed = false;
        this.currentToken = null;
        this.moveToNextToken();
    }

    public Marker mark() {
        if (this.completed) {
            return new Marker(null, this.tokenIterator.previousIndex());
        }
        Token currentToken = this.currentToken();
        Position currentPosition = currentToken != null ? currentToken.position() : null;
        return new Marker(currentPosition, this.tokenIterator.previousIndex());
    }

    public boolean rewind(Marker marker) {
        if (marker.tokenIndex >= 0 && marker.tokenIndex <= this.tokenIterator.nextIndex()) {
            this.completed = false;
            this.currentToken = null;
            this.tokenIterator = this.tokens.listIterator(marker.tokenIndex);
            this.moveToNextToken();
            return true;
        }
        return false;
    }

    public boolean advance(Marker marker) {
        if (marker.tokenIndex >= 0 && marker.tokenIndex >= this.tokenIterator.nextIndex()) {
            this.completed = false;
            this.currentToken = null;
            this.tokenIterator = this.tokens.listIterator(marker.tokenIndex);
            this.moveToNextToken();
            return true;
        }
        return false;
    }

    public Position previousPosition() {
        return this.previousPosition(1);
    }

    public Position previousPosition(int count) {
        return this.previousToken(1).position();
    }

    public Position nextPosition() {
        return this.currentToken().position();
    }

    public int consumeInteger() throws ParsingException, IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        String value = this.currentToken().value().toUpperCase();
        try {
            ArrayList<Token> newTokens = new ArrayList<Token>();
            int ePos = value.indexOf("E");
            if (ePos != -1) {
                String mantissa = value.substring(0, ePos);
                newTokens.add(new CaseInsensitiveToken(this.currentToken().startIndex() + ePos, this.currentToken().startIndex() + ePos + 1, 1, this.currentToken().position()));
                if (ePos != value.length() - 1) {
                    newTokens.add(new CaseInsensitiveToken(this.currentToken().startIndex() + ePos + 1, this.currentToken().endIndex(), 1, this.currentToken().position()));
                }
                value = mantissa;
            }
            int result = Integer.parseInt(value);
            this.moveToNextToken(newTokens);
            return result;
        }
        catch (NumberFormatException e) {
            Position position = this.currentToken().position();
            throw new ParsingException(position, "Expecting integer at line " + position.line() + ", column " + position.column() + " but found '" + value + "'");
        }
    }

    public long consumeLong() throws ParsingException, IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        String value = this.currentToken().value();
        try {
            long result = Long.parseLong(value);
            this.moveToNextToken();
            return result;
        }
        catch (NumberFormatException e) {
            Position position = this.currentToken().position();
            throw new ParsingException(position, "Expecting long at line " + position.line() + ", column " + position.column() + " but found '" + value + "'");
        }
    }

    public boolean consumeBoolean() throws ParsingException, IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        String value = this.currentToken().value();
        try {
            boolean result = Boolean.parseBoolean(value);
            this.moveToNextToken();
            return result;
        }
        catch (NumberFormatException e) {
            Position position = this.currentToken().position();
            throw new ParsingException(position, "Expecting boolean at line " + position.line() + ", column " + position.column() + " but found '" + value + "'");
        }
    }

    public String consume() throws ParsingException, IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        String result = this.currentToken().value();
        this.moveToNextToken();
        return result;
    }

    protected void throwNoMoreContent() throws ParsingException {
        Position pos = this.tokens.isEmpty() ? new Position(-1, 1, 0) : this.tokens.get(this.tokens.size() - 1).position();
        throw new ParsingException(pos, "No more content");
    }

    public String peek() throws IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        return this.currentToken().value();
    }

    public TokenStream consume(String expected) throws ParsingException, IllegalStateException {
        if (this.completed) {
            throw new ParsingException(this.tokens.get(this.tokens.size() - 1).position(), "No more content but was expecting token " + expected);
        }
        if (expected != ANY_VALUE && !this.currentToken().matches(expected)) {
            String found = this.currentToken().value();
            Position pos = this.currentToken().position();
            String fragment = this.generateFragment();
            String msg = "Expecting " + expected + " at line " + pos.line() + ", column " + pos.column() + " but found '" + found + "': " + fragment;
            throw new ParsingException(pos, msg);
        }
        this.moveToNextToken();
        return this;
    }

    public TokenStream consume(char expected) throws ParsingException, IllegalStateException {
        if (this.completed) {
            throw new ParsingException(this.tokens.get(this.tokens.size() - 1).position(), "No more content but was expecting '" + expected + "'");
        }
        if (!this.currentToken().matches(expected)) {
            String found = this.currentToken().value();
            Position pos = this.currentToken().position();
            String fragment = this.generateFragment();
            String msg = "Expecting '" + expected + "' at line " + pos.line() + ", column " + pos.column() + " but found '" + found + "': " + fragment;
            throw new ParsingException(pos, msg);
        }
        this.moveToNextToken();
        return this;
    }

    public TokenStream consume(int expectedType) throws ParsingException, IllegalStateException {
        if (this.completed) {
            throw new ParsingException(this.tokens.get(this.tokens.size() - 1).position(), "No more content but was expecting token of type " + expectedType);
        }
        if (expectedType != Integer.MIN_VALUE && (this.currentToken().type() & expectedType) != expectedType) {
            String found = this.currentToken().value();
            Position pos = this.currentToken().position();
            String fragment = this.generateFragment();
            String msg = "Expecting token type " + expectedType + " at line " + pos.line() + ", column " + pos.column() + " but found '" + found + "': " + fragment;
            throw new ParsingException(pos, msg);
        }
        this.moveToNextToken();
        return this;
    }

    public TokenStream consume(String expected, String ... expectedForNextTokens) throws ParsingException, IllegalStateException {
        this.consume(expected);
        for (String nextExpected : expectedForNextTokens) {
            this.consume(nextExpected);
        }
        return this;
    }

    public TokenStream consume(String[] nextTokens) throws ParsingException, IllegalStateException {
        for (String nextExpected : nextTokens) {
            this.consume(nextExpected);
        }
        return this;
    }

    public TokenStream consume(Iterable<String> nextTokens) throws ParsingException, IllegalStateException {
        for (String nextExpected : nextTokens) {
            this.consume(nextExpected);
        }
        return this;
    }

    public String consumeAnyOf(int ... typeOptions) throws IllegalStateException {
        if (this.completed) {
            throw new ParsingException(this.tokens.get(this.tokens.size() - 1).position(), "No more content but was expecting one token of type " + Strings.join((CharSequence)"|", typeOptions));
        }
        for (int typeOption : typeOptions) {
            if (typeOption != Integer.MIN_VALUE && !this.matches(typeOption)) continue;
            return this.consume();
        }
        String found = this.currentToken().value();
        Position pos = this.currentToken().position();
        String fragment = this.generateFragment();
        String msg = "Expecting " + Strings.join((CharSequence)"|", typeOptions) + " at line " + pos.line() + ", column " + pos.column() + " but found '" + found + "': " + fragment;
        throw new ParsingException(pos, msg);
    }

    public String consumeAnyOf(String ... options) throws IllegalStateException {
        if (this.completed) {
            throw new ParsingException(this.tokens.get(this.tokens.size() - 1).position(), "No more content but was expecting one token of " + String.join((CharSequence)"|", options));
        }
        for (String option : options) {
            if (option != ANY_VALUE && !this.matches(option)) continue;
            return this.consume();
        }
        String found = this.currentToken().value();
        Position pos = this.currentToken().position();
        String fragment = this.generateFragment();
        String msg = "Expecting " + String.join((CharSequence)"|", options) + " at line " + pos.line() + ", column " + pos.column() + " but found '" + found + "': " + fragment;
        throw new ParsingException(pos, msg);
    }

    public TokenStream consumeThrough(char expected) throws ParsingException, IllegalStateException {
        return this.consumeThrough(String.valueOf(expected), null);
    }

    public TokenStream consumeThrough(char expected, char skipMatchingTokens) throws ParsingException, IllegalStateException {
        return this.consumeThrough(String.valueOf(expected), String.valueOf(skipMatchingTokens));
    }

    public TokenStream consumeThrough(String expected) throws ParsingException, IllegalStateException {
        return this.consumeThrough(expected, null);
    }

    public TokenStream consumeThrough(String expected, String skipMatchingTokens) throws ParsingException, IllegalStateException {
        if (ANY_VALUE == expected) {
            this.consume();
            return this;
        }
        this.consumeUntil(expected, skipMatchingTokens);
        this.consume(expected);
        return this;
    }

    public TokenStream consumeUntil(char expected) throws ParsingException, IllegalStateException {
        return this.consumeUntil(String.valueOf(expected), null);
    }

    public TokenStream consumeUntil(char expected, char skipMatchingTokens) throws ParsingException, IllegalStateException {
        return this.consumeUntil(String.valueOf(expected), String.valueOf(skipMatchingTokens));
    }

    public TokenStream consumeUntil(String expected) throws ParsingException, IllegalStateException {
        return this.consumeUntil(expected, null);
    }

    public TokenStream consumeUntil(String expected, String ... skipMatchingTokens) throws ParsingException, IllegalStateException {
        if (ANY_VALUE == expected) {
            this.consume();
            return this;
        }
        Marker start = this.mark();
        int remaining = 0;
        while (this.hasNext()) {
            if (skipMatchingTokens != null && this.matchesAnyOf(skipMatchingTokens)) {
                ++remaining;
            }
            if (this.matches(expected)) {
                if (remaining == 0) break;
                --remaining;
            }
            this.consume();
        }
        if (this.completed) {
            this.rewind(start);
            throw new ParsingException(this.tokens.get(this.tokens.size() - 1).position(), "No more content but was expecting to find " + expected);
        }
        return this;
    }

    public TokenStream consumeUntilEndOrOneOf(String ... stopTokens) throws ParsingException, IllegalStateException {
        while (this.hasNext() && !this.matchesAnyOf(stopTokens)) {
            this.consume();
        }
        return this;
    }

    public boolean canConsumeInteger(IntConsumer consumer) throws IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        String value = this.currentToken().value();
        try {
            int result = Integer.parseInt(value);
            this.moveToNextToken();
            consumer.accept(result);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean canConsumeBoolean(BooleanConsumer consumer) throws IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        String value = this.currentToken().value();
        try {
            boolean result = Boolean.parseBoolean(value);
            this.moveToNextToken();
            consumer.accept(result);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean canConsumeLong(LongConsumer consumer) throws IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        String value = this.currentToken().value();
        try {
            long result = Long.parseLong(value);
            this.moveToNextToken();
            consumer.accept(result);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean canConsume(String expected) throws IllegalStateException {
        return this.canConsume(Integer.MIN_VALUE, expected);
    }

    public boolean canConsume(int type, String expected) throws IllegalStateException {
        if (!this.matches(expected) || !this.matches(type)) {
            return false;
        }
        this.moveToNextToken();
        return true;
    }

    public boolean canConsumeWord(String expected) throws IllegalStateException {
        return this.canConsume(1, expected);
    }

    public boolean canConsume(char expected) throws IllegalStateException {
        if (!this.matches(expected)) {
            return false;
        }
        this.moveToNextToken();
        return true;
    }

    public boolean canConsume(int expectedType) throws IllegalStateException {
        if (!this.matches(expectedType)) {
            return false;
        }
        this.moveToNextToken();
        return true;
    }

    public boolean canConsume(String currentExpected, String ... expectedForNextTokens) throws IllegalStateException {
        return this.canConsume(Integer.MIN_VALUE, currentExpected, expectedForNextTokens);
    }

    public boolean canConsume(int type, String currentExpected, String ... expectedForNextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        if (!iter.hasNext()) {
            return false;
        }
        Token token = iter.next();
        if (currentExpected != ANY_VALUE && !token.matches(type, currentExpected)) {
            return false;
        }
        for (String nextExpected : expectedForNextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpected == ANY_VALUE || token.matches(type, nextExpected)) continue;
            return false;
        }
        this.tokenIterator = iter;
        this.currentToken = this.tokenIterator.hasNext() ? this.tokenIterator.next() : null;
        this.completed = this.currentToken == null;
        return true;
    }

    public boolean canConsumeWords(String currentExpected, String ... expectedForNextTokens) throws IllegalStateException {
        return this.canConsume(1, currentExpected, expectedForNextTokens);
    }

    public boolean canConsume(String[] nextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        Token token = null;
        for (String nextExpected : nextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpected == ANY_VALUE || token.matches(nextExpected)) continue;
            return false;
        }
        this.tokenIterator = iter;
        this.currentToken = this.tokenIterator.hasNext() ? this.tokenIterator.next() : null;
        this.completed = this.currentToken == null;
        return true;
    }

    public boolean canConsume(Iterable<String> nextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        Token token = null;
        for (String nextExpected : nextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpected == ANY_VALUE || token.matches(nextExpected)) continue;
            return false;
        }
        this.tokenIterator = iter;
        this.currentToken = this.tokenIterator.hasNext() ? this.tokenIterator.next() : null;
        this.completed = this.currentToken == null;
        return true;
    }

    public boolean canConsumeAnyOf(String firstOption, String ... additionalOptions) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        if (this.canConsume(firstOption)) {
            return true;
        }
        for (String nextOption : additionalOptions) {
            if (!this.canConsume(nextOption)) continue;
            return true;
        }
        return false;
    }

    public boolean canConsumeAnyOf(String[] options) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        for (String option : options) {
            if (!this.canConsume(option)) continue;
            return true;
        }
        return false;
    }

    public boolean canConsumeAnyOf(Iterable<String> options) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        for (String option : options) {
            if (!this.canConsume(option)) continue;
            return true;
        }
        return false;
    }

    public boolean canConsumeAnyOf(int firstTypeOption, int ... additionalTypeOptions) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        if (this.canConsume(firstTypeOption)) {
            return true;
        }
        for (int nextTypeOption : additionalTypeOptions) {
            if (!this.canConsume(nextTypeOption)) continue;
            return true;
        }
        return false;
    }

    public boolean canConsumeAnyOf(int[] typeOptions) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        for (int nextTypeOption : typeOptions) {
            if (!this.canConsume(nextTypeOption)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String expected) throws IllegalStateException {
        return this.matches(Integer.MIN_VALUE, expected);
    }

    public boolean matches(int type, String expected) throws IllegalStateException {
        return !this.completed && (expected == ANY_VALUE || this.currentToken().matches(expected)) && this.currentToken().matches(type);
    }

    public boolean matchesWord(String expected) throws IllegalStateException {
        return this.matches(1, expected);
    }

    public boolean matches(char expected) throws IllegalStateException {
        return !this.completed && this.currentToken().matches(expected);
    }

    public boolean matches(int expectedType) throws IllegalStateException {
        return !this.completed && this.currentToken().matches(expectedType);
    }

    public boolean matches(String currentExpected, String ... expectedForNextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        if (!iter.hasNext()) {
            return false;
        }
        Token token = iter.next();
        if (currentExpected != ANY_VALUE && !token.matches(currentExpected)) {
            return false;
        }
        for (String nextExpected : expectedForNextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpected == ANY_VALUE || token.matches(nextExpected)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(String[] nextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        Token token = null;
        for (String nextExpected : nextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpected == ANY_VALUE || token.matches(nextExpected)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(Iterable<String> nextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        Token token = null;
        for (String nextExpected : nextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpected == ANY_VALUE || token.matches(nextExpected)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(int currentExpectedType, int ... expectedTypeForNextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        if (!iter.hasNext()) {
            return false;
        }
        Token token = iter.next();
        if (currentExpectedType != Integer.MIN_VALUE && (this.currentToken().type() & currentExpectedType) != currentExpectedType) {
            return false;
        }
        for (int nextExpectedType : expectedTypeForNextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpectedType == Integer.MIN_VALUE || (token.type() & nextExpectedType) == nextExpectedType) continue;
            return false;
        }
        return true;
    }

    public boolean matches(int[] typesForNextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        Token token = null;
        for (int nextExpectedType : typesForNextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpectedType == Integer.MIN_VALUE || token.matches(nextExpectedType)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesAnyOf(String firstOption, String ... additionalOptions) throws IllegalStateException {
        return this.matchesAnyOf(Integer.MIN_VALUE, firstOption, additionalOptions);
    }

    public boolean matchesAnyOf(int type, String firstOption, String ... additionalOptions) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        Token current = this.currentToken();
        if (current.matches(type, firstOption)) {
            return true;
        }
        for (String nextOption : additionalOptions) {
            if (!current.matches(type, nextOption)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAnyWordOf(String firstOption, String ... additionalOptions) throws IllegalStateException {
        return this.matchesAnyOf(1, firstOption, additionalOptions);
    }

    public boolean matchesAnyOf(String[] options) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        Token current = this.currentToken();
        for (String option : options) {
            if (!current.matches(option)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAnyOf(Iterable<String> options) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        Token current = this.currentToken();
        for (String option : options) {
            if (!current.matches(option)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAnyOf(int firstTypeOption, int ... additionalTypeOptions) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        Token current = this.currentToken();
        if (current.matches(firstTypeOption)) {
            return true;
        }
        for (int nextTypeOption : additionalTypeOptions) {
            if (!current.matches(nextTypeOption)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAnyOf(int[] typeOptions) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        Token current = this.currentToken();
        for (int nextTypeOption : typeOptions) {
            if (!current.matches(nextTypeOption)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNext() {
        if (this.tokenIterator == null) {
            throw new IllegalStateException("start() method must be called before hasNext()");
        }
        return !this.completed;
    }

    public String toString() {
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        StringBuilder sb = new StringBuilder();
        if (iter.hasNext()) {
            sb.append(iter.next());
            int count = 1;
            while (iter.hasNext()) {
                if (count > 20) {
                    sb.append(" ...");
                    break;
                }
                sb.append("  ");
                ++count;
                sb.append(iter.next());
            }
        }
        return sb.toString();
    }

    private void moveToNextToken(List<Token> newTokens) {
        if (newTokens != null && !newTokens.isEmpty()) {
            for (Token t : newTokens) {
                this.tokenIterator.add(t);
            }
            for (int i = 0; i < newTokens.size() - 1; ++i) {
                this.tokenIterator.previous();
            }
            this.currentToken = newTokens.get(0);
            return;
        }
        if (!this.tokenIterator.hasNext()) {
            this.completed = true;
            this.currentToken = null;
        } else {
            this.currentToken = this.tokenIterator.next();
        }
    }

    private void moveToNextToken() {
        this.moveToNextToken(null);
    }

    final Token currentToken() throws IllegalStateException, NoSuchElementException {
        if (this.currentToken == null) {
            if (this.completed) {
                throw new NoSuchElementException("No more content");
            }
            throw new IllegalStateException("start() method must be called before consuming or matching");
        }
        assert (this.currentToken != null);
        return this.currentToken;
    }

    public String getContentFrom(Marker starting) {
        Objects.requireNonNull(starting, "starting");
        int startIndex = starting.position != null ? starting.position.index() : 0;
        return this.getContentBetween(startIndex, this.hasNext() ? this.nextPosition() : null);
    }

    public String getContentBetween(Marker starting, Position end) {
        Objects.requireNonNull(starting, "starting");
        int startIndex = starting.position != null ? starting.position.index() : 0;
        return this.getContentBetween(startIndex, end);
    }

    public String getContentBetween(Position starting, Position end) {
        Objects.requireNonNull(starting, "starting");
        return this.getContentBetween(starting.index(), end);
    }

    protected String getContentBetween(int startIndex, Position end) {
        int endIndex;
        int n = endIndex = end != null ? end.index() : this.inputString.length();
        if (startIndex >= endIndex) {
            throw new IllegalArgumentException("The starting position " + startIndex + " must be before the end position " + end);
        }
        return this.inputString.substring(startIndex, endIndex);
    }

    public final Token previousToken(int count) throws IllegalStateException, NoSuchElementException {
        if (count < 1) {
            throw new IllegalArgumentException("The count must be positive");
        }
        if (this.currentToken == null) {
            if (this.completed) {
                if (this.tokens.isEmpty()) {
                    throw new NoSuchElementException("No more content");
                }
                return this.tokens.get(this.tokens.size() - 1);
            }
            throw new IllegalStateException("start() method must be called before consuming or matching");
        }
        int index = this.tokenIterator.previousIndex() - count;
        if (index < 0) {
            throw new NoSuchElementException("No more content");
        }
        return this.tokens.get(this.tokenIterator.previousIndex() - count);
    }

    String generateFragment() {
        assert (this.currentToken != null);
        int startIndex = this.currentToken.startIndex();
        return TokenStream.generateFragment(this.inputString, startIndex, 20, " ===>> ");
    }

    static String generateFragment(String content, int indexOfProblem, int charactersToIncludeBeforeAndAfter, String highlightText) {
        assert (content != null);
        assert (indexOfProblem < content.length());
        int beforeStart = Math.max(0, indexOfProblem - charactersToIncludeBeforeAndAfter);
        String before = content.substring(beforeStart, indexOfProblem);
        int afterEnd = Math.min(indexOfProblem + charactersToIncludeBeforeAndAfter, content.length());
        String after = content.substring(indexOfProblem, afterEnd);
        return before + (highlightText != null ? highlightText : "") + after;
    }

    public static BasicTokenizer basicTokenizer(boolean includeComments) {
        return new BasicTokenizer(includeComments);
    }

    public String getInputString() {
        return this.inputString;
    }

    public static class BasicTokenizer
    implements Tokenizer {
        public static final int WORD = 1;
        public static final int SYMBOL = 2;
        public static final int DECIMAL = 4;
        public static final int SINGLE_QUOTED_STRING = 8;
        public static final int DOUBLE_QUOTED_STRING = 16;
        public static final int COMMENT = 32;
        private final boolean useComments;

        protected BasicTokenizer(boolean useComments) {
            this.useComments = useComments;
        }

        @Override
        public void tokenize(CharacterStream input, Tokens tokens) throws ParsingException {
            block8: while (input.hasNext()) {
                char c = input.next();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    case '!': 
                    case '$': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case ':': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '|': 
                    case '}': {
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                        break;
                    }
                    case '.': {
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 4);
                        break;
                    }
                    case '\"': {
                        int startIndex = input.index();
                        Position startingPosition = input.position(startIndex);
                        boolean foundClosingQuote = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c == '\\' && input.isNext('\"')) {
                                c = input.next();
                                continue;
                            }
                            if (c == '\"' && input.isNext('\"')) {
                                c = input.next();
                                continue;
                            }
                            if (c != '\"') continue;
                            foundClosingQuote = true;
                            break;
                        }
                        if (!foundClosingQuote) {
                            String msg = "No matching double quote found at line " + startingPosition.line() + ", column " + startingPosition.column();
                            throw new ParsingException(startingPosition, msg);
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(startingPosition, startIndex, endIndex, 16);
                        break;
                    }
                    case '\'': {
                        int startIndex = input.index();
                        Position startingPosition = input.position(startIndex);
                        boolean foundClosingQuote = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c == '\\' && input.isNext('\'')) {
                                c = input.next();
                                continue;
                            }
                            if (c == '\'' && input.isNext('\'')) {
                                c = input.next();
                                continue;
                            }
                            if (c != '\'') continue;
                            foundClosingQuote = true;
                            break;
                        }
                        if (!foundClosingQuote) {
                            String msg = "No matching single quote found at line " + startingPosition.line() + ", column " + startingPosition.column();
                            throw new ParsingException(startingPosition, msg);
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(startingPosition, startIndex, endIndex, 8);
                        break;
                    }
                    case '/': {
                        int endIndex;
                        int startIndex = input.index();
                        Position startingPosition = input.position(startIndex);
                        if (input.isNext('/')) {
                            boolean foundLineTerminator = false;
                            while (input.hasNext()) {
                                c = input.next();
                                if (c != '\n' && c != '\r') continue;
                                foundLineTerminator = true;
                                break;
                            }
                            endIndex = input.index();
                            if (!foundLineTerminator) {
                                ++endIndex;
                            }
                            if (c == '\r' && input.isNext('\n')) {
                                input.next();
                            }
                            if (!this.useComments) continue block8;
                            tokens.addToken(startingPosition, startIndex, endIndex, 32);
                            break;
                        }
                        if (input.isNext('*')) {
                            while (input.hasNext() && !input.isNext('*', '/')) {
                                c = input.next();
                            }
                            if (input.hasNext()) {
                                input.next();
                            }
                            if (input.hasNext()) {
                                input.next();
                            }
                            if (!this.useComments) continue block8;
                            endIndex = input.index() + 1;
                            tokens.addToken(startingPosition, startIndex, endIndex, 32);
                            break;
                        }
                        tokens.addToken(startingPosition, startIndex, startIndex + 1, 2);
                        break;
                    }
                    default: {
                        int startIndex = input.index();
                        Position startingPosition = input.position(startIndex);
                        while (input.hasNext() && !input.isNextWhitespace() && !input.isNextAnyOf("/.-(){}*,;+%?$[]!<>|=:")) {
                            c = input.next();
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(startingPosition, startIndex, endIndex, 1);
                    }
                }
            }
        }
    }

    public static final class CharacterArrayStream
    implements CharacterStream {
        private final char[] content;
        private int lastIndex = -1;
        private final int maxIndex;
        private int lineNumber = 1;
        private int columnNumber = 0;
        private boolean nextCharMayBeLineFeed;

        public CharacterArrayStream(char[] content) {
            this.content = content;
            this.maxIndex = content.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.lastIndex < this.maxIndex;
        }

        @Override
        public int index() {
            return this.lastIndex;
        }

        @Override
        public Position position(int startIndex) {
            return new Position(startIndex, this.lineNumber, this.columnNumber);
        }

        @Override
        public String substring(int startIndex, int endIndex) {
            return new String(this.content, startIndex, endIndex - startIndex);
        }

        @Override
        public char next() {
            if (this.lastIndex >= this.maxIndex) {
                throw new NoSuchElementException();
            }
            char result = this.content[++this.lastIndex];
            ++this.columnNumber;
            if (result == '\r') {
                this.nextCharMayBeLineFeed = true;
                ++this.lineNumber;
                this.columnNumber = 0;
            } else if (result == '\n') {
                if (!this.nextCharMayBeLineFeed) {
                    ++this.lineNumber;
                }
                this.columnNumber = 0;
            } else if (this.nextCharMayBeLineFeed) {
                this.nextCharMayBeLineFeed = false;
            }
            return result;
        }

        @Override
        public boolean isNext(char c) {
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && this.content[nextIndex] == c;
        }

        @Override
        public boolean isNext(char nextChar1, char nextChar2) {
            int nextIndex1 = this.lastIndex + 1;
            int nextIndex2 = this.lastIndex + 2;
            return nextIndex2 <= this.maxIndex && this.content[nextIndex1] == nextChar1 && this.content[nextIndex2] == nextChar2;
        }

        @Override
        public boolean isNext(char nextChar1, char nextChar2, char nextChar3) {
            int nextIndex1 = this.lastIndex + 1;
            int nextIndex2 = this.lastIndex + 2;
            int nextIndex3 = this.lastIndex + 3;
            return nextIndex3 <= this.maxIndex && this.content[nextIndex1] == nextChar1 && this.content[nextIndex2] == nextChar2 && this.content[nextIndex3] == nextChar3;
        }

        @Override
        public boolean isNextAnyOf(char[] characters) {
            int nextIndex = this.lastIndex + 1;
            if (nextIndex <= this.maxIndex) {
                char nextChar = this.content[this.lastIndex + 1];
                for (char c : characters) {
                    if (c != nextChar) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isNextAnyOf(String characters) {
            char nextChar;
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && characters.indexOf(nextChar = this.content[this.lastIndex + 1]) != -1;
        }

        @Override
        public boolean isNextWhitespace() {
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && Character.isWhitespace(this.content[nextIndex]);
        }

        @Override
        public boolean isNextLetterOrDigit() {
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && Character.isLetterOrDigit(this.content[nextIndex]);
        }

        @Override
        public boolean isNextValidXmlCharacter() {
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && XmlCharacters.isValid(this.content[nextIndex]);
        }

        @Override
        public boolean isNextValidXmlNameCharacter() {
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && XmlCharacters.isValidName(this.content[nextIndex]);
        }

        @Override
        public boolean isNextValidXmlNcNameCharacter() {
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && XmlCharacters.isValidNcName(this.content[nextIndex]);
        }
    }

    public class CaseInsensitiveTokenFactory
    extends TokenFactory {
        @Override
        public void addToken(Position position, int startIndex, int endIndex, int type) {
            this.tokens.add(new CaseInsensitiveToken(startIndex, endIndex, type, position));
        }
    }

    public class CaseSensitiveTokenFactory
    extends TokenFactory {
        @Override
        public void addToken(Position position, int startIndex, int endIndex, int type) {
            this.tokens.add(new CaseSensitiveToken(startIndex, endIndex, type, position));
        }
    }

    protected abstract class TokenFactory
    implements Tokens {
        protected final List<Token> tokens = new ArrayList<Token>();

        protected TokenFactory() {
        }

        public List<Token> getTokens() {
            return this.tokens;
        }
    }

    @Immutable
    protected class CaseInsensitiveToken
    extends CaseSensitiveToken {
        public CaseInsensitiveToken(int startIndex, int endIndex, int type, Position position) {
            super(startIndex, endIndex, type, position);
        }

        @Override
        public boolean matches(String expected) {
            return this.matchString().substring(this.startIndex(), this.endIndex()).toUpperCase().equals(expected);
        }

        @Override
        public Token withType(int typeMask) {
            int type = this.type() | typeMask;
            return new CaseInsensitiveToken(this.startIndex(), this.endIndex(), type, this.position());
        }
    }

    @Immutable
    protected class CaseSensitiveToken
    implements Token {
        private final int startIndex;
        private final int endIndex;
        private final int type;
        private final Position position;

        public CaseSensitiveToken(int startIndex, int endIndex, int type, Position position) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.type = type;
            this.position = position;
        }

        @Override
        public Token withType(int typeMask) {
            int type = this.type | typeMask;
            return new CaseSensitiveToken(this.startIndex, this.endIndex, type, this.position);
        }

        @Override
        public final int type() {
            return this.type;
        }

        @Override
        public final int startIndex() {
            return this.startIndex;
        }

        @Override
        public final int endIndex() {
            return this.endIndex;
        }

        @Override
        public final int length() {
            return this.endIndex - this.startIndex;
        }

        @Override
        public final boolean matches(char expected) {
            return this.length() == 1 && this.matchString().charAt(this.startIndex) == expected;
        }

        @Override
        public boolean matches(String expected) {
            return this.matchString().substring(this.startIndex, this.endIndex).equals(expected);
        }

        @Override
        public final boolean matches(int expectedType) {
            return expectedType == Integer.MIN_VALUE || (TokenStream.this.currentToken().type() & expectedType) == expectedType;
        }

        @Override
        public final String value() {
            return TokenStream.this.inputString.substring(this.startIndex, this.endIndex);
        }

        @Override
        public Position position() {
            return this.position;
        }

        protected String matchString() {
            return TokenStream.this.inputString;
        }

        public String toString() {
            return this.value();
        }
    }

    @Immutable
    public static interface Token {
        public String value();

        public boolean matches(String var1);

        default public boolean matches(int expectedType, String expected) {
            return this.matches(expectedType) && this.matches(expected);
        }

        public boolean matches(char var1);

        public boolean matches(int var1);

        public int type();

        public int startIndex();

        public int endIndex();

        public int length();

        public Position position();

        public Token withType(int var1);
    }

    public static interface Tokens {
        default public void addToken(Position position, int index) {
            this.addToken(position, index, index + 1, 0);
        }

        default public void addToken(Position position, int startIndex, int endIndex) {
            this.addToken(position, startIndex, endIndex, 0);
        }

        public void addToken(Position var1, int var2, int var3, int var4);
    }

    public static interface CharacterStream {
        public boolean hasNext();

        public char next();

        public int index();

        public Position position(int var1);

        public String substring(int var1, int var2);

        public boolean isNextWhitespace();

        public boolean isNextLetterOrDigit();

        public boolean isNextValidXmlCharacter();

        public boolean isNextValidXmlNameCharacter();

        public boolean isNextValidXmlNcNameCharacter();

        public boolean isNext(char var1);

        public boolean isNext(char var1, char var2);

        public boolean isNext(char var1, char var2, char var3);

        public boolean isNextAnyOf(char[] var1);

        public boolean isNextAnyOf(String var1);
    }

    public static interface Tokenizer {
        public void tokenize(CharacterStream var1, Tokens var2) throws ParsingException;
    }

    public static final class Marker
    implements Comparable<Marker> {
        protected final int tokenIndex;
        protected final Position position;

        protected Marker(Position position, int index) {
            this.position = position;
            this.tokenIndex = index;
        }

        public Position position() {
            return this.position;
        }

        @Override
        public int compareTo(Marker that) {
            if (this == that) {
                return 0;
            }
            return this.tokenIndex - that.tokenIndex;
        }

        public String toString() {
            return Integer.toString(this.tokenIndex);
        }
    }
}

