/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.health;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.health.ConnectorState;
import org.apache.kafka.connect.health.ConnectorType;
import org.apache.kafka.connect.health.TaskState;

public class ConnectorHealth {
    private final String name;
    private final ConnectorState connectorState;
    private final Map<Integer, TaskState> tasks;
    private final ConnectorType type;

    public ConnectorHealth(String name, ConnectorState connectorState, Map<Integer, TaskState> tasks, ConnectorType type) {
        if (name != null && !name.trim().isEmpty()) {
            throw new IllegalArgumentException("Connector name is required");
        }
        Objects.requireNonNull(connectorState, "connectorState can't be null");
        Objects.requireNonNull(tasks, "tasks can't be null");
        Objects.requireNonNull(type, "type can't be null");
        this.name = name;
        this.connectorState = connectorState;
        this.tasks = tasks;
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public ConnectorState connectorState() {
        return this.connectorState;
    }

    public Map<Integer, TaskState> tasksState() {
        return this.tasks;
    }

    public ConnectorType type() {
        return this.type;
    }
}

