/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ImplicitLinkedHashSet<E extends Element>
extends AbstractSet<E> {
    private static final int HEAD_INDEX = -1;
    public static final int INVALID_INDEX = -2;
    private Element head;
    private Element[] elements;
    private int size;

    private static Element indexToElement(Element head, Element[] elements, int index) {
        if (index == -1) {
            return head;
        }
        return elements[index];
    }

    private static void addToListTail(Element head, Element[] elements, int elementIdx) {
        int oldTailIdx = head.prev();
        Element element = ImplicitLinkedHashSet.indexToElement(head, elements, elementIdx);
        Element oldTail = ImplicitLinkedHashSet.indexToElement(head, elements, oldTailIdx);
        head.setPrev(elementIdx);
        oldTail.setNext(elementIdx);
        element.setPrev(oldTailIdx);
        element.setNext(-1);
    }

    private static void removeFromList(Element head, Element[] elements, int elementIdx) {
        Element element = ImplicitLinkedHashSet.indexToElement(head, elements, elementIdx);
        elements[elementIdx] = null;
        int prevIdx = element.prev();
        int nextIdx = element.next();
        Element prev = ImplicitLinkedHashSet.indexToElement(head, elements, prevIdx);
        Element next = ImplicitLinkedHashSet.indexToElement(head, elements, nextIdx);
        prev.setNext(nextIdx);
        next.setPrev(prevIdx);
        element.setNext(-2);
        element.setPrev(-2);
    }

    @Override
    public Iterator<E> iterator() {
        return new ImplicitLinkedHashSetIterator();
    }

    private static int slot(Element[] curElements, Element e) {
        return (e.hashCode() & Integer.MAX_VALUE) % curElements.length;
    }

    private int findIndex(E example) {
        int slot = ImplicitLinkedHashSet.slot(this.elements, example);
        for (int seen = 0; seen < this.elements.length; ++seen) {
            Element element = this.elements[slot];
            if (element == null) {
                return -2;
            }
            if (element.equals(example)) {
                return slot;
            }
            slot = (slot + 1) % this.elements.length;
        }
        return -2;
    }

    public E find(E example) {
        int index = this.findIndex(example);
        if (index == -2) {
            return null;
        }
        return (E)this.elements[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        Element example = null;
        try {
            example = (Element)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.find(example) != null;
    }

    @Override
    public boolean add(E newElement) {
        int slot;
        if (this.size + 1 >= this.elements.length / 2) {
            this.changeCapacity(2 * this.elements.length + 1);
        }
        if ((slot = ImplicitLinkedHashSet.addInternal(newElement, this.elements)) >= 0) {
            ImplicitLinkedHashSet.addToListTail(this.head, this.elements, slot);
            ++this.size;
            return true;
        }
        return false;
    }

    public void mustAdd(E newElement) {
        if (!this.add(newElement)) {
            throw new RuntimeException("Unable to add " + newElement);
        }
    }

    private static int addInternal(Element newElement, Element[] addElements) {
        int slot = ImplicitLinkedHashSet.slot(addElements, newElement);
        for (int seen = 0; seen < addElements.length; ++seen) {
            Element element = addElements[slot];
            if (element == null) {
                addElements[slot] = newElement;
                return slot;
            }
            if (element.equals(newElement)) {
                return -2;
            }
            slot = (slot + 1) % addElements.length;
        }
        throw new RuntimeException("Not enough hash table slots to add a new element.");
    }

    private void changeCapacity(int newCapacity) {
        Element[] newElements = new Element[newCapacity];
        HeadElement newHead = new HeadElement();
        int oldSize = this.size;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            iter.remove();
            int newSlot = ImplicitLinkedHashSet.addInternal(element, newElements);
            ImplicitLinkedHashSet.addToListTail(newHead, newElements, newSlot);
        }
        this.elements = newElements;
        this.head = newHead;
        this.size = oldSize;
    }

    @Override
    public boolean remove(Object o) {
        Element element;
        Element example = null;
        try {
            example = (Element)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        int slot = this.findIndex(example);
        if (slot == -2) {
            return false;
        }
        --this.size;
        ImplicitLinkedHashSet.removeFromList(this.head, this.elements, slot);
        int endSlot = slot = (slot + 1) % this.elements.length;
        for (int seen = 0; seen < this.elements.length && (element = this.elements[endSlot]) != null; ++seen) {
            endSlot = (endSlot + 1) % this.elements.length;
        }
        while (slot != endSlot) {
            this.reseat(slot);
            slot = (slot + 1) % this.elements.length;
        }
        return true;
    }

    private void reseat(int prevSlot) {
        Element e;
        Element element = this.elements[prevSlot];
        int newSlot = ImplicitLinkedHashSet.slot(this.elements, element);
        for (int seen = 0; seen < this.elements.length && (e = this.elements[newSlot]) != null && e != element; ++seen) {
            newSlot = (newSlot + 1) % this.elements.length;
        }
        if (newSlot == prevSlot) {
            return;
        }
        Element prev = ImplicitLinkedHashSet.indexToElement(this.head, this.elements, element.prev());
        prev.setNext(newSlot);
        Element next = ImplicitLinkedHashSet.indexToElement(this.head, this.elements, element.next());
        next.setPrev(newSlot);
        this.elements[prevSlot] = null;
        this.elements[newSlot] = element;
    }

    @Override
    public void clear() {
        this.reset(this.elements.length);
    }

    public ImplicitLinkedHashSet() {
        this(5);
    }

    public ImplicitLinkedHashSet(int initialCapacity) {
        this.reset(initialCapacity);
    }

    private void reset(int capacity) {
        this.head = new HeadElement();
        this.elements = new Element[2 * capacity + 1];
        this.size = 0;
    }

    int numSlots() {
        return this.elements.length;
    }

    private class ImplicitLinkedHashSetIterator
    implements Iterator<E> {
        private Element cur;
        private Element next;

        private ImplicitLinkedHashSetIterator() {
            this.cur = ImplicitLinkedHashSet.this.head;
            this.next = ImplicitLinkedHashSet.indexToElement(ImplicitLinkedHashSet.this.head, ImplicitLinkedHashSet.this.elements, ImplicitLinkedHashSet.this.head.next());
        }

        @Override
        public boolean hasNext() {
            return this.next != ImplicitLinkedHashSet.this.head;
        }

        @Override
        public E next() {
            if (this.next == ImplicitLinkedHashSet.this.head) {
                throw new NoSuchElementException();
            }
            this.cur = this.next;
            this.next = ImplicitLinkedHashSet.indexToElement(ImplicitLinkedHashSet.this.head, ImplicitLinkedHashSet.this.elements, this.cur.next());
            return this.cur;
        }

        @Override
        public void remove() {
            if (this.cur == ImplicitLinkedHashSet.this.head) {
                throw new IllegalStateException();
            }
            ImplicitLinkedHashSet.this.remove(this.cur);
            this.cur = ImplicitLinkedHashSet.this.head;
        }
    }

    private static class HeadElement
    implements Element {
        private int prev = -1;
        private int next = -1;

        private HeadElement() {
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public void setPrev(int prev) {
            this.prev = prev;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public void setNext(int next) {
            this.next = next;
        }
    }

    public static interface Element {
        public int prev();

        public void setPrev(int var1);

        public int next();

        public void setNext(int var1);
    }
}

