/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.EncryptionKeyInfo;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerEncryptionAlgorithm;
import com.microsoft.sqlserver.jdbc.SQLServerEncryptionAlgorithmFactoryList;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSymmetricKey;
import com.microsoft.sqlserver.jdbc.SQLServerSymmetricKeyCache;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class SQLServerSecurityUtility {
    SQLServerSecurityUtility() {
    }

    static byte[] getHMACWithSHA256(byte[] plainText, byte[] key, int length) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] hash = new byte[length];
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec ivkeySpec = new SecretKeySpec(key, "HmacSHA256");
        mac.init(ivkeySpec);
        byte[] computedHash = mac.doFinal(plainText);
        System.arraycopy(computedHash, 0, hash, 0, hash.length);
        return hash;
    }

    static boolean compareBytes(byte[] buffer1, byte[] buffer2, int buffer2Index, int lengthToCompare) {
        if (null == buffer1 || null == buffer2) {
            return false;
        }
        if (buffer2.length - buffer2Index < lengthToCompare) {
            return false;
        }
        for (int index = 0; index < buffer1.length && index < lengthToCompare; ++index) {
            if (buffer1[index] == buffer2[buffer2Index + index]) continue;
            return false;
        }
        return true;
    }

    static byte[] encryptWithKey(byte[] plainText, CryptoMetadata md, SQLServerConnection connection) throws SQLServerException {
        String serverName = connection.getTrustedServerNameAE();
        assert (serverName != null) : "Server name should npt be null in EncryptWithKey";
        if (!md.IsAlgorithmInitialized()) {
            SQLServerSecurityUtility.decryptSymmetricKey(md, connection);
        }
        assert (md.IsAlgorithmInitialized());
        byte[] cipherText = md.cipherAlgorithm.encryptData(plainText);
        if (null == cipherText || 0 == cipherText.length) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_NullCipherTextAE"), null, 0, false);
        }
        return cipherText;
    }

    private static String ValidateAndGetEncryptionAlgorithmName(byte cipherAlgorithmId, String cipherAlgorithmName) throws SQLServerException {
        if (2 != cipherAlgorithmId) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_CustomCipherAlgorithmNotSupportedAE"), null, 0, false);
        }
        return "AEAD_AES_256_CBC_HMAC_SHA256";
    }

    static void decryptSymmetricKey(CryptoMetadata md, SQLServerConnection connection) throws SQLServerException {
        assert (null != md) : "md should not be null in DecryptSymmetricKey.";
        assert (null != md.cekTableEntry) : "md.EncryptionInfo should not be null in DecryptSymmetricKey.";
        assert (null != md.cekTableEntry.columnEncryptionKeyValues) : "md.EncryptionInfo.ColumnEncryptionKeyValues should not be null in DecryptSymmetricKey.";
        SQLServerSymmetricKey symKey = null;
        EncryptionKeyInfo encryptionkeyInfoChosen = null;
        SQLServerSymmetricKeyCache cache = SQLServerSymmetricKeyCache.getInstance();
        Iterator<EncryptionKeyInfo> it = md.cekTableEntry.columnEncryptionKeyValues.iterator();
        SQLServerException lastException = null;
        while (it.hasNext()) {
            EncryptionKeyInfo keyInfo = it.next();
            try {
                symKey = cache.getKey(keyInfo, connection);
                if (null == symKey) continue;
                encryptionkeyInfoChosen = keyInfo;
                break;
            }
            catch (SQLServerException e) {
                lastException = e;
            }
        }
        if (null == symKey) {
            if (null != lastException) {
                throw lastException;
            }
            throw new SQLServerException(null, SQLServerException.getErrString("R_CEKDecryptionFailed"), null, 0, false);
        }
        md.cipherAlgorithm = null;
        SQLServerEncryptionAlgorithm cipherAlgorithm = null;
        String algorithmName = SQLServerSecurityUtility.ValidateAndGetEncryptionAlgorithmName(md.cipherAlgorithmId, md.cipherAlgorithmName);
        cipherAlgorithm = SQLServerEncryptionAlgorithmFactoryList.getInstance().getAlgorithm(symKey, md.encryptionType, algorithmName);
        assert (null != cipherAlgorithm) : "Cipher algorithm cannot be null in DecryptSymmetricKey";
        md.cipherAlgorithm = cipherAlgorithm;
        md.encryptionKeyInfo = encryptionkeyInfoChosen;
    }

    static byte[] decryptWithKey(byte[] cipherText, CryptoMetadata md, SQLServerConnection connection) throws SQLServerException {
        String serverName = connection.getTrustedServerNameAE();
        assert (null != serverName) : "serverName should not be null in DecryptWithKey.";
        if (!md.IsAlgorithmInitialized()) {
            SQLServerSecurityUtility.decryptSymmetricKey(md, connection);
        }
        assert (md.IsAlgorithmInitialized()) : "Decryption Algorithm is not initialized";
        byte[] plainText = md.cipherAlgorithm.decryptData(cipherText);
        if (null == plainText) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_PlainTextNullAE"), null, 0, false);
        }
        return plainText;
    }
}

