/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.ObjectAssert;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableAssert
extends GenericAssert<ThrowableAssert, Throwable> {
    @VisibleForTesting
    final ObjectAssert objectAssert;

    protected ThrowableAssert(Throwable actual) {
        super(ThrowableAssert.class, actual);
        this.objectAssert = new ObjectAssert(actual);
    }

    public ThrowableAssert isInstanceOf(Class<? extends Throwable> type) {
        this.objectAssert.isInstanceOf(type);
        return this;
    }

    public ThrowableAssert isExactlyInstanceOf(Class<?> type) {
        this.isNotNull();
        this.objectAssert.validateNotNull(type);
        Class<?> current = ((Throwable)this.actual).getClass();
        if (type.equals(current)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("expected exactly the same type:<%s> but was:<%s>", type, current));
    }

    public ThrowableAssert hasMessage(String message) {
        this.isNotNull();
        Fail.failIfNotEqual(this.customErrorMessage(), this.rawDescription(), ((Throwable)this.actual).getMessage(), message);
        return this;
    }

    public ThrowableAssert hasNoCause() {
        this.isNotNull();
        Throwable actualCause = ((Throwable)this.actual).getCause();
        if (actualCause == null) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("expected exception without cause, but cause was:<%s>", actualCause.getClass()));
    }

    @Override
    public ThrowableAssert as(String description) {
        this.objectAssert.as(description);
        return (ThrowableAssert)super.as(description);
    }

    @Override
    public ThrowableAssert describedAs(String description) {
        return this.as(description);
    }

    @Override
    public ThrowableAssert as(Description description) {
        this.objectAssert.as(description);
        return (ThrowableAssert)super.as(description);
    }

    @Override
    public ThrowableAssert describedAs(Description description) {
        return this.as(description);
    }

    @Override
    public ThrowableAssert overridingErrorMessage(String message) {
        this.objectAssert.overridingErrorMessage(message);
        return (ThrowableAssert)super.overridingErrorMessage(message);
    }
}

