/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatArrayAssert
extends ArrayAssert<FloatArrayAssert, float[]> {
    protected FloatArrayAssert(float ... actual) {
        super(FloatArrayAssert.class, actual);
    }

    public FloatArrayAssert contains(float ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public FloatArrayAssert containsOnly(float ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public FloatArrayAssert excludes(float ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    public FloatArrayAssert isEqualTo(float[] expected) {
        if (Arrays.equals((float[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    public FloatArrayAssert isNotEqualTo(float[] array) {
        if (!Arrays.equals((float[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

