/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayAssert
extends ArrayAssert<ByteArrayAssert, byte[]> {
    protected ByteArrayAssert(byte ... actual) {
        super(ByteArrayAssert.class, actual);
    }

    public ByteArrayAssert contains(byte ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public ByteArrayAssert containsOnly(byte ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public ByteArrayAssert excludes(byte ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    public ByteArrayAssert isEqualTo(byte[] expected) {
        if (Arrays.equals((byte[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    public ByteArrayAssert isNotEqualTo(byte[] array) {
        if (!Arrays.equals((byte[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

