/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.data.SchemaAndValueField;
import io.debezium.data.SourceRecordAssert;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqlServerConnectorIT
extends AbstractConnectorTest {
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE tablea (id int primary key, cola varchar(30))", "CREATE TABLE tableb (id int primary key, colb varchar(30))", "INSERT INTO tablea VALUES(1, 'a')"});
        TestHelper.enableTableCdc(this.connection, "tablea");
        TestHelper.enableTableCdc(this.connection, "tableb");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void createAndDelete() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.consumeRecordsByTopic(1);
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        List tableA = records.recordsForTopic("server1.dbo.tablea");
        List tableB = records.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((List)tableA).hasSize(5);
        Assertions.assertThat((List)tableB).hasSize(5);
        for (int i = 0; i < 5; ++i) {
            SourceRecord recordA = (SourceRecord)tableA.get(i);
            SourceRecord recordB = (SourceRecord)tableB.get(i);
            List<SchemaAndValueField> expectedRowA = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"a"));
            List<SchemaAndValueField> expectedRowB = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            Struct keyA = (Struct)recordA.key();
            Struct valueA = (Struct)recordA.value();
            this.assertRecord((Struct)valueA.get("after"), expectedRowA);
            Assert.assertNull((Object)valueA.get("before"));
            Struct keyB = (Struct)recordB.key();
            Struct valueB = (Struct)recordB.value();
            this.assertRecord((Struct)valueB.get("after"), expectedRowB);
            Assert.assertNull((Object)valueB.get("before"));
        }
        this.connection.execute(new String[]{"DELETE FROM tableB"});
        AbstractConnectorTest.SourceRecords deleteRecords = this.consumeRecordsByTopic(10);
        List deleteTableA = deleteRecords.recordsForTopic("server1.dbo.tablea");
        List deleteTableB = deleteRecords.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((List)deleteTableA).isNullOrEmpty();
        Assertions.assertThat((List)deleteTableB).hasSize(10);
        for (int i = 0; i < 5; ++i) {
            SourceRecord deleteRecord = (SourceRecord)deleteTableB.get(i * 2);
            SourceRecord tombstoneRecord = (SourceRecord)deleteTableB.get(i * 2 + 1);
            List<SchemaAndValueField> expectedDeleteRow = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            Struct deleteKey = (Struct)deleteRecord.key();
            Struct deleteValue = (Struct)deleteRecord.value();
            this.assertRecord((Struct)deleteValue.get("before"), expectedDeleteRow);
            Assert.assertNull((Object)deleteValue.get("after"));
            Struct tombstoneKey = (Struct)tombstoneRecord.key();
            Struct tombstoneValue = (Struct)tombstoneRecord.value();
            Assert.assertNull((Object)tombstoneValue);
        }
        this.stopConnector();
    }

    @Test
    public void update() throws Exception {
        SourceRecord recordB;
        int i;
        int RECORDS_PER_TABLE = 5;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.consumeRecordsByTopic(1);
        this.connection.setAutoCommit(false);
        String[] tableBInserts = new String[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            int id = 10 + i2;
            tableBInserts[i2] = "INSERT INTO tableb VALUES(" + id + ", 'b')";
        }
        this.connection.execute(tableBInserts);
        this.connection.setAutoCommit(true);
        this.connection.execute(new String[]{"UPDATE tableb SET colb='z'"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        List tableB = records.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((List)tableB).hasSize(10);
        for (i = 0; i < 5; ++i) {
            recordB = (SourceRecord)tableB.get(i);
            List<SchemaAndValueField> expectedRowB = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            Struct keyB = (Struct)recordB.key();
            Struct valueB = (Struct)recordB.value();
            this.assertRecord((Struct)valueB.get("after"), expectedRowB);
            Assert.assertNull((Object)valueB.get("before"));
        }
        for (i = 0; i < 5; ++i) {
            recordB = (SourceRecord)tableB.get(i + 5);
            List<SchemaAndValueField> expectedBefore = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            List<SchemaAndValueField> expectedAfter = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"z"));
            Struct keyB = (Struct)recordB.key();
            Struct valueB = (Struct)recordB.value();
            this.assertRecord((Struct)valueB.get("before"), expectedBefore);
            this.assertRecord((Struct)valueB.get("after"), expectedAfter);
        }
        this.stopConnector();
    }

    @Test
    public void streamChangesWhileStopped() throws Exception {
        int id;
        int i;
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START = 10;
        int ID_RESTART = 100;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.consumeRecordsByTopic(1);
        for (i = 0; i < 5; ++i) {
            id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        this.consumeRecordsByTopic(10);
        this.stopConnector();
        for (i = 0; i < 5; ++i) {
            id = 100 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        List tableA = records.recordsForTopic("server1.dbo.tablea");
        List tableB = records.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((List)tableA).hasSize(5);
        Assertions.assertThat((List)tableB).hasSize(5);
        for (int i2 = 0; i2 < 5; ++i2) {
            int id2 = i2 + 100;
            SourceRecord recordA = (SourceRecord)tableA.get(i2);
            SourceRecord recordB = (SourceRecord)tableB.get(i2);
            List<SchemaAndValueField> expectedRowA = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id2), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"a"));
            List<SchemaAndValueField> expectedRowB = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id2), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            Struct valueA = (Struct)recordA.value();
            this.assertRecord((Struct)valueA.get("after"), expectedRowA);
            Assert.assertNull((Object)valueA.get("before"));
            Struct valueB = (Struct)recordB.value();
            this.assertRecord((Struct)valueB.get("after"), expectedRowB);
            Assert.assertNull((Object)valueB.get("before"));
        }
    }

    @Test
    @FixFor(value={"DBZ-1069"})
    public void verifyOffsets() throws Exception {
        int i;
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START = 10;
        int ID_RESTART = 100;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).build();
        for (i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        i = 0;
        while (!this.connection.getMaxLsn().isAvailable()) {
            if (i == 30) {
                Assert.fail((String)"Initial changes not written to CDC structures");
            }
            Testing.debug((Object)"Waiting for initial changes to be propagated to CDC structures");
            Thread.sleep(1000L);
            ++i;
        }
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        List records = this.consumeRecordsByTopic(11).allRecordsInOrder();
        records = records.subList(1, records.size());
        Iterator it = records.iterator();
        while (it.hasNext()) {
            SourceRecord record = (SourceRecord)it.next();
            ((ObjectAssert)Assertions.assertThat(record.sourceOffset().get("snapshot")).as("Snapshot phase")).isEqualTo((Object)true);
            if (it.hasNext()) {
                ((ObjectAssert)Assertions.assertThat(record.sourceOffset().get("snapshot_completed")).as("Snapshot in progress")).isEqualTo((Object)false);
                continue;
            }
            ((ObjectAssert)Assertions.assertThat(record.sourceOffset().get("snapshot_completed")).as("Snapshot completed")).isEqualTo((Object)true);
        }
        this.stopConnector();
        for (int i2 = 0; i2 < 5; ++i2) {
            int id = 100 + i2;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(10);
        List tableA = sourceRecords.recordsForTopic("server1.dbo.tablea");
        List tableB = sourceRecords.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((List)tableA).hasSize(5);
        Assertions.assertThat((List)tableB).hasSize(5);
        for (int i3 = 0; i3 < 5; ++i3) {
            int id = i3 + 100;
            SourceRecord recordA = (SourceRecord)tableA.get(i3);
            SourceRecord recordB = (SourceRecord)tableB.get(i3);
            List<SchemaAndValueField> expectedRowA = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"a"));
            List<SchemaAndValueField> expectedRowB = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            Struct valueA = (Struct)recordA.value();
            this.assertRecord((Struct)valueA.get("after"), expectedRowA);
            Assert.assertNull((Object)valueA.get("before"));
            Struct valueB = (Struct)recordB.value();
            this.assertRecord((Struct)valueB.get("after"), expectedRowB);
            Assert.assertNull((Object)valueB.get("before"));
            ((ObjectAssert)Assertions.assertThat(recordA.sourceOffset().get("snapshot")).as("Streaming phase")).isNull();
            ((ObjectAssert)Assertions.assertThat(recordA.sourceOffset().get("snapshot_completed")).as("Streaming phase")).isNull();
            ((ObjectAssert)Assertions.assertThat(recordA.sourceOffset().get("change_lsn")).as("LSN present")).isNotNull();
            ((ObjectAssert)Assertions.assertThat(recordB.sourceOffset().get("snapshot")).as("Streaming phase")).isNull();
            ((ObjectAssert)Assertions.assertThat(recordB.sourceOffset().get("snapshot_completed")).as("Streaming phase")).isNull();
            ((ObjectAssert)Assertions.assertThat(recordB.sourceOffset().get("change_lsn")).as("LSN present")).isNotNull();
        }
    }

    @Test
    public void whitelistTable() throws Exception {
        int RECORDS_PER_TABLE = 5;
        boolean TABLES = true;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).with(SqlServerConnectorConfig.TABLE_WHITELIST, "dbo.tableb")).build();
        this.connection.execute(new String[]{"INSERT INTO tableb VALUES(1, 'b')"});
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.consumeRecordsByTopic(1);
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        List tableA = records.recordsForTopic("server1.dbo.tablea");
        List tableB = records.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((tableA == null || tableA.isEmpty() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((List)tableB).hasSize(5);
        this.stopConnector();
    }

    @Test
    public void blacklistTable() throws Exception {
        int RECORDS_PER_TABLE = 5;
        boolean TABLES = true;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL)).with(SqlServerConnectorConfig.TABLE_BLACKLIST, "dbo.tablea")).build();
        this.connection.execute(new String[]{"INSERT INTO tableb VALUES(1, 'b')"});
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.consumeRecordsByTopic(1);
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        List tableA = records.recordsForTopic("server1.dbo.tablea");
        List tableB = records.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((tableA == null || tableA.isEmpty() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((List)tableB).hasSize(5);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-1067"})
    public void blacklistColumn() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE blacklist_column_table_a (id int, name varchar(30), amount integer primary key(id))", "CREATE TABLE blacklist_column_table_b (id int, name varchar(30), amount integer primary key(id))"});
        TestHelper.enableTableCdc(this.connection, "blacklist_column_table_a");
        TestHelper.enableTableCdc(this.connection, "blacklist_column_table_b");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).with(SqlServerConnectorConfig.COLUMN_BLACKLIST, "dbo.blacklist_column_table_a.amount")).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.consumeRecordsByTopic(1);
        this.connection.execute(new String[]{"INSERT INTO blacklist_column_table_a VALUES(10, 'some_name', 120)"});
        this.connection.execute(new String[]{"INSERT INTO blacklist_column_table_b VALUES(11, 'some_name', 447)"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        List tableA = records.recordsForTopic("server1.dbo.blacklist_column_table_a");
        List tableB = records.recordsForTopic("server1.dbo.blacklist_column_table_b");
        Schema expectedSchemaA = SchemaBuilder.struct().optional().name("server1.dbo.blacklist_column_table_a.Value").field("id", Schema.INT32_SCHEMA).field("name", Schema.OPTIONAL_STRING_SCHEMA).build();
        Struct expectedValueA = new Struct(expectedSchemaA).put("id", (Object)10).put("name", (Object)"some_name");
        Schema expectedSchemaB = SchemaBuilder.struct().optional().name("server1.dbo.blacklist_column_table_b.Value").field("id", Schema.INT32_SCHEMA).field("name", Schema.OPTIONAL_STRING_SCHEMA).field("amount", Schema.OPTIONAL_INT32_SCHEMA).build();
        Struct expectedValueB = new Struct(expectedSchemaB).put("id", (Object)11).put("name", (Object)"some_name").put("amount", (Object)447);
        Assertions.assertThat((List)tableA).hasSize(1);
        SourceRecordAssert.assertThat((SourceRecord)((SourceRecord)tableA.get(0))).valueAfterFieldIsEqualTo(expectedValueA).valueAfterFieldSchemaIsEqualTo(expectedSchemaA);
        Assertions.assertThat((List)tableB).hasSize(1);
        SourceRecordAssert.assertThat((SourceRecord)((SourceRecord)tableB.get(0))).valueAfterFieldIsEqualTo(expectedValueB).valueAfterFieldSchemaIsEqualTo(expectedSchemaB);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-964"})
    public void shouldPropagateDatabaseDriverProperties() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).with("database.applicationName", "Debezium App DBZ-964").build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.connection.execute(new String[]{"INSERT INTO tablea VALUES(964, 'a')"});
        this.consumeRecordsByTopic(1);
        this.connection.query("select count(1) from sys.dm_exec_sessions where program_name = 'Debezium App DBZ-964'", rs -> {
            rs.next();
            Assertions.assertThat((int)rs.getInt(1)).isEqualTo(1);
        });
    }

    private void assertRecord(Struct record, List<SchemaAndValueField> expected) {
        expected.forEach(schemaAndValueField -> schemaAndValueField.assertFor(record));
    }
}

