/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectAssert
extends GenericAssert<ObjectAssert, Object> {
    protected ObjectAssert(Object actual) {
        super(ObjectAssert.class, actual);
    }

    public ObjectAssert isInstanceOf(Class<?> type) {
        this.isNotNull();
        this.validateNotNull(type);
        Class<?> current = this.actual.getClass();
        if (type.isAssignableFrom(current)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("expected instance of:<%s> but was instance of:<%s>", type, current));
    }

    public ObjectAssert isInstanceOfAny(Class<?> ... types) {
        this.isNotNull();
        if (types == null) {
            throw new NullPointerException(this.formattedErrorMessage("The given array of types should not be null"));
        }
        if (!this.foundInstanceOfAny(types)) {
            this.fail(String.format("expected instance of any:<%s> but was instance of:<%s>", this.typeNames(types), this.actual.getClass().getName()));
        }
        return this;
    }

    private boolean foundInstanceOfAny(Class<?> ... types) {
        Class<?> current = this.actual.getClass();
        for (Class<?> type : types) {
            this.validateNotNull(type);
            if (!type.isAssignableFrom(current)) continue;
            return true;
        }
        return false;
    }

    void validateNotNull(Class<?> type) {
        if (type == null) {
            throw new NullPointerException(ErrorMessages.unexpectedNullType(this.rawDescription()));
        }
    }

    private String typeNames(Class<?> ... types) {
        return Arrays.toString(Objects.namesOf((Class[])types));
    }
}

