/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver.util;

import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.IoUtil;
import io.debezium.util.Testing;
import java.io.InputStream;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Objects;

public class TestHelper {
    public static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-connect.txt").toAbsolutePath();
    public static final String TEST_DATABASE = "testDB";
    private static final String STATEMENTS_PLACEHOLDER = "#";
    private static final String ENABLE_DB_CDC = "IF EXISTS(select 1 from sys.databases where name='#' AND is_cdc_enabled=0)\nEXEC sys.sp_cdc_enable_db";
    private static final String DISABLE_DB_CDC = "IF EXISTS(select 1 from sys.databases where name='#' AND is_cdc_enabled=1)\nEXEC sys.sp_cdc_disable_db";
    private static final String ENABLE_TABLE_CDC = "IF EXISTS(select 1 from sys.tables where name = '#' AND is_tracked_by_cdc=0)\nEXEC sys.sp_cdc_enable_table @source_schema = N'dbo', @source_name = N'#', @role_name = NULL, @supports_net_changes = 0";
    private static final String ENABLE_TABLE_CDC_WITH_CUSTOM_CAPTURE = "EXEC sys.sp_cdc_enable_table @source_schema = N'dbo', @source_name = N'%s', @capture_instance = N'%s', @role_name = NULL, @supports_net_changes = 0";
    private static final String DISABLE_TABLE_CDC = "EXEC sys.sp_cdc_disable_table @source_schema = N'dbo', @source_name = N'#', @capture_instance = 'all'";
    private static final String CDC_WRAPPERS_DML;

    public static JdbcConfiguration adminJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.DATABASE, "master")).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 1433)).withDefault(JdbcConfiguration.USER, "sa")).withDefault(JdbcConfiguration.PASSWORD, "Password!")).build();
    }

    public static JdbcConfiguration defaultJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.DATABASE, TEST_DATABASE)).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 1433)).withDefault(JdbcConfiguration.USER, "sa")).withDefault(JdbcConfiguration.PASSWORD, "Password!")).build();
    }

    public static Configuration.Builder defaultConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.defaultJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with("database." + field, value));
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.with(SqlServerConnectorConfig.LOGICAL_NAME, "server1")).with(SqlServerConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH);
    }

    public static void createTestDatabase() {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            try {
                connection.execute(new String[]{"USE testDB"});
                TestHelper.disableDbCdc(connection, TEST_DATABASE);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            connection.execute(new String[]{"USE master"});
            String sql = "IF EXISTS(select 1 from sys.databases where name='testDB') DROP DATABASE testDB\nCREATE DATABASE testDB\n";
            connection.execute(new String[]{sql});
            connection.execute(new String[]{"USE testDB"});
            connection.execute(new String[]{"ALTER DATABASE testDB SET ALLOW_SNAPSHOT_ISOLATION ON"});
            TestHelper.enableDbCdc(connection, TEST_DATABASE);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while initiating test database", e);
        }
    }

    public static void dropTestDatabase() {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            try {
                connection.execute(new String[]{"USE testDB"});
                TestHelper.disableDbCdc(connection, TEST_DATABASE);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            connection.execute(new String[]{"USE master"});
            String sql = "IF EXISTS(select 1 from sys.databases where name='testDB') DROP DATABASE testDB";
            connection.execute(new String[]{sql});
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while dropping test database", e);
        }
    }

    public static SqlServerConnection adminConnection() {
        return new SqlServerConnection((Configuration)TestHelper.adminJdbcConfig());
    }

    public static SqlServerConnection testConnection() {
        return new SqlServerConnection((Configuration)TestHelper.defaultJdbcConfig());
    }

    public static void enableDbCdc(SqlServerConnection connection, String name) throws SQLException {
        Objects.requireNonNull(name);
        connection.execute(new String[]{ENABLE_DB_CDC.replace(STATEMENTS_PLACEHOLDER, name)});
    }

    protected static void disableDbCdc(SqlServerConnection connection, String name) throws SQLException {
        Objects.requireNonNull(name);
        connection.execute(new String[]{DISABLE_DB_CDC.replace(STATEMENTS_PLACEHOLDER, name)});
    }

    public static void enableTableCdc(SqlServerConnection connection, String name) throws SQLException {
        Objects.requireNonNull(name);
        String enableCdcForTableStmt = ENABLE_TABLE_CDC.replace(STATEMENTS_PLACEHOLDER, name);
        String generateWrapperFunctionsStmts = CDC_WRAPPERS_DML.replaceAll(STATEMENTS_PLACEHOLDER, name);
        connection.execute(new String[]{enableCdcForTableStmt, generateWrapperFunctionsStmts});
    }

    public static void enableTableCdc(SqlServerConnection connection, String tableName, String captureName) throws SQLException {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(captureName);
        String enableCdcForTableStmt = String.format(ENABLE_TABLE_CDC_WITH_CUSTOM_CAPTURE, tableName, captureName);
        connection.execute(new String[]{enableCdcForTableStmt});
    }

    public static void disableTableCdc(SqlServerConnection connection, String name) throws SQLException {
        Objects.requireNonNull(name);
        String disableCdcForTableStmt = DISABLE_TABLE_CDC.replace(STATEMENTS_PLACEHOLDER, name);
        connection.execute(new String[]{disableCdcForTableStmt});
    }

    static {
        try {
            ClassLoader classLoader = TestHelper.class.getClassLoader();
            CDC_WRAPPERS_DML = IoUtil.read((InputStream)classLoader.getResourceAsStream("generate_cdc_wrappers.sql"));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load SQL Server statements", e);
        }
    }
}

