/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.data.SchemaAndValueField;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqlServerConnectorIT
extends AbstractConnectorTest {
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE tablea (id int primary key, cola varchar(30))", "CREATE TABLE tableb (id int primary key, colb varchar(30))", "INSERT INTO tablea VALUES(1, 'a')"});
        TestHelper.enableTableCdc(this.connection, "tablea");
        TestHelper.enableTableCdc(this.connection, "tableb");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void createAndDelete() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        List tableA = records.recordsForTopic("server1.dbo.tablea");
        List tableB = records.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((List)tableA).hasSize(5);
        Assertions.assertThat((List)tableB).hasSize(5);
        for (int i = 0; i < 5; ++i) {
            SourceRecord recordA = (SourceRecord)tableA.get(i);
            SourceRecord recordB = (SourceRecord)tableB.get(i);
            List<SchemaAndValueField> expectedRowA = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"a"));
            List<SchemaAndValueField> expectedRowB = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            Struct keyA = (Struct)recordA.key();
            Struct valueA = (Struct)recordA.value();
            this.assertRecord((Struct)valueA.get("after"), expectedRowA);
            Assert.assertNull((Object)valueA.get("before"));
            Struct keyB = (Struct)recordB.key();
            Struct valueB = (Struct)recordB.value();
            this.assertRecord((Struct)valueB.get("after"), expectedRowB);
            Assert.assertNull((Object)valueB.get("before"));
        }
        this.connection.execute(new String[]{"DELETE FROM tableB"});
        AbstractConnectorTest.SourceRecords deleteRecords = this.consumeRecordsByTopic(10);
        List deleteTableA = deleteRecords.recordsForTopic("server1.dbo.tablea");
        List deleteTableB = deleteRecords.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((List)deleteTableA).isNullOrEmpty();
        Assertions.assertThat((List)deleteTableB).hasSize(10);
        for (int i = 0; i < 5; ++i) {
            SourceRecord deleteRecord = (SourceRecord)deleteTableB.get(i * 2);
            SourceRecord tombstoneRecord = (SourceRecord)deleteTableB.get(i * 2 + 1);
            List<SchemaAndValueField> expectedDeleteRow = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            Struct deleteKey = (Struct)deleteRecord.key();
            Struct deleteValue = (Struct)deleteRecord.value();
            this.assertRecord((Struct)deleteValue.get("before"), expectedDeleteRow);
            Assert.assertNull((Object)deleteValue.get("after"));
            Struct tombstoneKey = (Struct)tombstoneRecord.key();
            Struct tombstoneValue = (Struct)tombstoneRecord.value();
            Assert.assertNull((Object)tombstoneValue);
        }
        this.stopConnector();
    }

    @Test
    public void update() throws Exception {
        SourceRecord recordB;
        int i;
        int RECORDS_PER_TABLE = 5;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.connection.setAutoCommit(false);
        String[] tableBInserts = new String[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            int id = 10 + i2;
            tableBInserts[i2] = "INSERT INTO tableb VALUES(" + id + ", 'b')";
        }
        this.connection.execute(tableBInserts);
        this.connection.setAutoCommit(true);
        this.connection.execute(new String[]{"UPDATE tableb SET colb='z'"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        List tableB = records.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((List)tableB).hasSize(10);
        for (i = 0; i < 5; ++i) {
            recordB = (SourceRecord)tableB.get(i);
            List<SchemaAndValueField> expectedRowB = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            Struct keyB = (Struct)recordB.key();
            Struct valueB = (Struct)recordB.value();
            this.assertRecord((Struct)valueB.get("after"), expectedRowB);
            Assert.assertNull((Object)valueB.get("before"));
        }
        for (i = 0; i < 5; ++i) {
            recordB = (SourceRecord)tableB.get(i + 5);
            List<SchemaAndValueField> expectedBefore = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            List<SchemaAndValueField> expectedAfter = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"z"));
            Struct keyB = (Struct)recordB.key();
            Struct valueB = (Struct)recordB.value();
            this.assertRecord((Struct)valueB.get("before"), expectedBefore);
            this.assertRecord((Struct)valueB.get("after"), expectedAfter);
        }
        this.stopConnector();
    }

    @Test
    public void streamChangesWhileStopped() throws Exception {
        int id;
        int i;
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START = 10;
        int ID_RESTART = 100;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        for (i = 0; i < 5; ++i) {
            id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        this.consumeRecordsByTopic(10);
        this.stopConnector();
        for (i = 0; i < 5; ++i) {
            id = 100 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        List tableA = records.recordsForTopic("server1.dbo.tablea");
        List tableB = records.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((List)tableA).hasSize(5);
        Assertions.assertThat((List)tableB).hasSize(5);
        for (int i2 = 0; i2 < 5; ++i2) {
            int id2 = i2 + 100;
            SourceRecord recordA = (SourceRecord)tableA.get(i2);
            SourceRecord recordB = (SourceRecord)tableB.get(i2);
            List<SchemaAndValueField> expectedRowA = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id2), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"a"));
            List<SchemaAndValueField> expectedRowB = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id2), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            Struct valueA = (Struct)recordA.value();
            this.assertRecord((Struct)valueA.get("after"), expectedRowA);
            Assert.assertNull((Object)valueA.get("before"));
            Struct valueB = (Struct)recordB.value();
            this.assertRecord((Struct)valueB.get("after"), expectedRowB);
            Assert.assertNull((Object)valueB.get("before"));
        }
    }

    @Test
    public void whitelistTable() throws Exception {
        int RECORDS_PER_TABLE = 5;
        boolean TABLES = true;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).with(SqlServerConnectorConfig.TABLE_WHITELIST, "dbo.tableb")).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        List tableA = records.recordsForTopic("server1.dbo.tablea");
        List tableB = records.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((tableA == null || tableA.isEmpty() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((List)tableB).hasSize(5);
        this.stopConnector();
    }

    @Test
    public void blacklistTable() throws Exception {
        int RECORDS_PER_TABLE = 5;
        boolean TABLES = true;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).with(SqlServerConnectorConfig.TABLE_BLACKLIST, "dbo.tablea")).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        List tableA = records.recordsForTopic("server1.dbo.tablea");
        List tableB = records.recordsForTopic("server1.dbo.tableb");
        Assertions.assertThat((tableA == null || tableA.isEmpty() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((List)tableB).hasSize(5);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-964"})
    public void shouldPropagateDatabaseDriverProperties() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).with("database.applicationName", "Debezium App DBZ-964").build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.connection.execute(new String[]{"INSERT INTO tablea VALUES(964, 'a')"});
        this.consumeRecordsByTopic(1);
        this.connection.query("select count(1) from sys.dm_exec_sessions where program_name = 'Debezium App DBZ-964'", rs -> {
            rs.next();
            Assertions.assertThat((int)rs.getInt(1)).isEqualTo(1);
        });
    }

    private void assertRecord(Struct record, List<SchemaAndValueField> expected) {
        expected.forEach(schemaAndValueField -> schemaAndValueField.assertFor(record));
    }
}

