/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.CompatibilityCheckResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.rest.utils.UrlList;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestService {
    private static final Logger log = LoggerFactory.getLogger(RestService.class);
    private static final TypeReference<RegisterSchemaResponse> REGISTER_RESPONSE_TYPE = new TypeReference<RegisterSchemaResponse>(){};
    private static final TypeReference<Config> GET_CONFIG_RESPONSE_TYPE = new TypeReference<Config>(){};
    private static final TypeReference<SchemaString> GET_SCHEMA_BY_ID_RESPONSE_TYPE = new TypeReference<SchemaString>(){};
    private static final TypeReference<JsonNode> GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE = new TypeReference<JsonNode>(){};
    private static final TypeReference<Schema> GET_SCHEMA_BY_VERSION_RESPONSE_TYPE = new TypeReference<Schema>(){};
    private static final TypeReference<List<Integer>> ALL_VERSIONS_RESPONSE_TYPE = new TypeReference<List<Integer>>(){};
    private static final TypeReference<List<String>> ALL_TOPICS_RESPONSE_TYPE = new TypeReference<List<String>>(){};
    private static final TypeReference<CompatibilityCheckResponse> COMPATIBILITY_CHECK_RESPONSE_TYPE_REFERENCE = new TypeReference<CompatibilityCheckResponse>(){};
    private static final TypeReference<Schema> SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE = new TypeReference<Schema>(){};
    private static final TypeReference<ConfigUpdateRequest> UPDATE_CONFIG_RESPONSE_TYPE_REFERENCE = new TypeReference<ConfigUpdateRequest>(){};
    private static final TypeReference<Integer> DELETE_SUBJECT_VERSION_RESPONSE_TYPE = new TypeReference<Integer>(){};
    private static final TypeReference<? extends List<Integer>> DELETE_SUBJECT_RESPONSE_TYPE = new TypeReference<List<Integer>>(){};
    private static final int HTTP_CONNECT_TIMEOUT_MS = 60000;
    private static final int HTTP_READ_TIMEOUT_MS = 60000;
    private static final int JSON_PARSE_ERROR_CODE = 50005;
    private static ObjectMapper jsonDeserializer = new ObjectMapper();
    public static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = new HashMap<String, String>();
    private UrlList baseUrls;
    private SSLSocketFactory sslSocketFactory;
    private BasicAuthCredentialProvider basicAuthCredentialProvider;

    public RestService(UrlList baseUrls) {
        this.baseUrls = baseUrls;
    }

    public RestService(List<String> baseUrls) {
        this(new UrlList(baseUrls));
    }

    public RestService(String baseUrlConfig) {
        this(RestService.parseBaseUrl(baseUrlConfig));
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    private <T> T sendHttpRequest(String requestUrl, String method, byte[] requestBodyData, Map<String, String> requestProperties, TypeReference<T> responseFormat) throws IOException, RestClientException {
        String requestData = requestBodyData == null ? "null" : new String(requestBodyData, StandardCharsets.UTF_8);
        log.debug(String.format("Sending %s with input %s to %s", method, requestData, requestUrl));
        HttpURLConnection connection = null;
        try {
            ErrorMessage errorMessage;
            InputStream is;
            int responseCode;
            URL url = new URL(requestUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            this.setupSsl(connection);
            connection.setRequestMethod(method);
            this.setBasicAuthRequestHeader(connection);
            connection.setDoInput(true);
            for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            connection.setUseCaches(false);
            if (requestBodyData != null) {
                connection.setDoOutput(true);
                try (OutputStream os = null;){
                    os = connection.getOutputStream();
                    os.write(requestBodyData);
                    os.flush();
                }
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                is = connection.getInputStream();
                Object result = jsonDeserializer.readValue(is, responseFormat);
                is.close();
                Object object = result;
                return (T)object;
            }
            if (responseCode == 204) {
                is = null;
                return (T)is;
            }
            InputStream es = connection.getErrorStream();
            try {
                errorMessage = (ErrorMessage)jsonDeserializer.readValue(es, ErrorMessage.class);
            }
            catch (JsonProcessingException e) {
                errorMessage = new ErrorMessage(50005, e.getMessage());
            }
            es.close();
            throw new RestClientException(errorMessage.getMessage(), responseCode, errorMessage.getErrorCode());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void setupSsl(HttpURLConnection connection) {
        if (connection instanceof HttpsURLConnection && this.sslSocketFactory != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
        }
    }

    private <T> T httpRequest(String path, String method, byte[] requestBodyData, Map<String, String> requestProperties, TypeReference<T> responseFormat) throws IOException, RestClientException {
        int n = this.baseUrls.size();
        for (int i = 0; i < n; ++i) {
            String baseUrl = this.baseUrls.current();
            String requestUrl = RestService.buildRequestUrl(baseUrl, path);
            try {
                return this.sendHttpRequest(requestUrl, method, requestBodyData, requestProperties, responseFormat);
            }
            catch (IOException e) {
                this.baseUrls.fail(baseUrl);
                if (i != n - 1) continue;
                throw e;
            }
        }
        throw new IOException("Internal HTTP retry error");
    }

    static String buildRequestUrl(String baseUrl, String path) {
        return baseUrl.replaceFirst("/$", "") + "/" + path.replaceFirst("^/", "");
    }

    public Schema lookUpSubjectVersion(String schemaString, String subject) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.lookUpSubjectVersion(request, subject);
    }

    public Schema lookUpSubjectVersion(RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        return this.lookUpSubjectVersion(DEFAULT_REQUEST_PROPERTIES, registerSchemaRequest, subject, false);
    }

    public Schema lookUpSubjectVersion(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s", subject);
        if (requestProperties.isEmpty()) {
            requestProperties = DEFAULT_REQUEST_PROPERTIES;
        }
        Schema schema = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE);
        return schema;
    }

    public Schema lookUpSubjectVersion(String schemaString, String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.lookUpSubjectVersion(DEFAULT_REQUEST_PROPERTIES, request, subject, lookupDeletedSchema);
    }

    public Schema lookUpSubjectVersion(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        String path = String.format("/subjects/%s?deleted=%s", subject, lookupDeletedSchema);
        Schema schema = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE);
        return schema;
    }

    public int registerSchema(String schemaString, String subject) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.registerSchema(request, subject);
    }

    public int registerSchema(RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        return this.registerSchema(DEFAULT_REQUEST_PROPERTIES, registerSchemaRequest, subject);
    }

    public int registerSchema(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions", subject);
        RegisterSchemaResponse response = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, REGISTER_RESPONSE_TYPE);
        return response.getId();
    }

    public boolean testCompatibility(String schemaString, String subject, String version) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.testCompatibility(request, subject, version);
    }

    public boolean testCompatibility(RegisterSchemaRequest registerSchemaRequest, String subject, String version) throws IOException, RestClientException {
        return this.testCompatibility(DEFAULT_REQUEST_PROPERTIES, registerSchemaRequest, subject, version);
    }

    public boolean testCompatibility(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject, String version) throws IOException, RestClientException {
        String path = String.format("/compatibility/subjects/%s/versions/%s", subject, version);
        CompatibilityCheckResponse response = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, COMPATIBILITY_CHECK_RESPONSE_TYPE_REFERENCE);
        return response.getIsCompatible();
    }

    public ConfigUpdateRequest updateCompatibility(String compatibility, String subject) throws IOException, RestClientException {
        ConfigUpdateRequest request = new ConfigUpdateRequest();
        request.setCompatibilityLevel(compatibility);
        return this.updateConfig(request, subject);
    }

    public ConfigUpdateRequest updateConfig(ConfigUpdateRequest configUpdateRequest, String subject) throws IOException, RestClientException {
        return this.updateConfig(DEFAULT_REQUEST_PROPERTIES, configUpdateRequest, subject);
    }

    public ConfigUpdateRequest updateConfig(Map<String, String> requestProperties, ConfigUpdateRequest configUpdateRequest, String subject) throws IOException, RestClientException {
        String path = subject != null ? String.format("/config/%s", subject) : "/config";
        ConfigUpdateRequest response = this.httpRequest(path, "PUT", configUpdateRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, UPDATE_CONFIG_RESPONSE_TYPE_REFERENCE);
        return response;
    }

    public Config getConfig(String subject) throws IOException, RestClientException {
        return this.getConfig(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public Config getConfig(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = subject != null ? String.format("/config/%s", subject) : "/config";
        Config config = this.httpRequest(path, "GET", null, requestProperties, GET_CONFIG_RESPONSE_TYPE);
        return config;
    }

    public SchemaString getId(int id) throws IOException, RestClientException {
        return this.getId(DEFAULT_REQUEST_PROPERTIES, id);
    }

    public SchemaString getId(Map<String, String> requestProperties, int id) throws IOException, RestClientException {
        String path = String.format("/schemas/ids/%d", id);
        SchemaString response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_BY_ID_RESPONSE_TYPE);
        return response;
    }

    public Schema getVersion(String subject, int version) throws IOException, RestClientException {
        return this.getVersion(DEFAULT_REQUEST_PROPERTIES, subject, version);
    }

    public Schema getVersion(Map<String, String> requestProperties, String subject, int version) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/%d", subject, version);
        Schema response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_BY_VERSION_RESPONSE_TYPE);
        return response;
    }

    public Schema getLatestVersion(String subject) throws IOException, RestClientException {
        return this.getLatestVersion(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public Schema getLatestVersion(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/latest", subject);
        Schema response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_BY_VERSION_RESPONSE_TYPE);
        return response;
    }

    public String getVersionSchemaOnly(String subject, int version) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/%d/schema", subject, version);
        JsonNode response = this.httpRequest(path, "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE);
        return response.toString();
    }

    public String getLatestVersionSchemaOnly(String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/latest/schema", subject);
        JsonNode response = this.httpRequest(path, "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE);
        return response.toString();
    }

    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        return this.getAllVersions(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public List<Integer> getAllVersions(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions", subject);
        List<Integer> response = this.httpRequest(path, "GET", null, requestProperties, ALL_VERSIONS_RESPONSE_TYPE);
        return response;
    }

    public List<String> getAllSubjects() throws IOException, RestClientException {
        return this.getAllSubjects(DEFAULT_REQUEST_PROPERTIES);
    }

    public List<String> getAllSubjects(Map<String, String> requestProperties) throws IOException, RestClientException {
        List<String> response = this.httpRequest("/subjects", "GET", null, requestProperties, ALL_TOPICS_RESPONSE_TYPE);
        return response;
    }

    public Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/%s", subject, version);
        Integer response = this.httpRequest(path, "DELETE", null, requestProperties, DELETE_SUBJECT_VERSION_RESPONSE_TYPE);
        return response;
    }

    public List<Integer> deleteSubject(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s", subject);
        List<Integer> response = this.httpRequest(path, "DELETE", null, requestProperties, DELETE_SUBJECT_RESPONSE_TYPE);
        return response;
    }

    private static List<String> parseBaseUrl(String baseUrl) {
        List<String> baseUrls = Arrays.asList(baseUrl.split("\\s*,\\s*"));
        if (baseUrls.isEmpty()) {
            throw new IllegalArgumentException("Missing required schema registry url list");
        }
        return baseUrls;
    }

    public UrlList getBaseUrls() {
        return this.baseUrls;
    }

    private void setBasicAuthRequestHeader(HttpURLConnection connection) {
        String userInfo;
        if (this.basicAuthCredentialProvider != null && (userInfo = this.basicAuthCredentialProvider.getUserInfo(connection.getURL())) != null) {
            String authHeader = Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty("Authorization", "Basic " + authHeader);
        }
    }

    public void setBasicAuthCredentialProvider(BasicAuthCredentialProvider basicAuthCredentialProvider) {
        this.basicAuthCredentialProvider = basicAuthCredentialProvider;
    }

    static {
        DEFAULT_REQUEST_PROPERTIES.put("Content-Type", "application/vnd.schemaregistry.v1+json");
    }
}

