/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver.util;

import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectionFactory;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;

public class TestHelper {
    public static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-connect.txt").toAbsolutePath();
    public static final String TEST_DATABASE = "testDB";

    public static JdbcConfiguration adminJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.DATABASE, "master")).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 1433)).withDefault(JdbcConfiguration.USER, "sa")).withDefault(JdbcConfiguration.PASSWORD, "Password!")).build();
    }

    public static JdbcConfiguration defaultJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.DATABASE, TEST_DATABASE)).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 1433)).withDefault(JdbcConfiguration.USER, "sa")).withDefault(JdbcConfiguration.PASSWORD, "Password!")).build();
    }

    public static Configuration.Builder defaultConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.defaultJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with("database." + field, value));
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.with(SqlServerConnectorConfig.LOGICAL_NAME, "server1")).with(SqlServerConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH);
    }

    public static void createTestDatabase() {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            try {
                connection.execute(new String[]{"USE testDB"});
                connection.disableDbCdc(TEST_DATABASE);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            connection.execute(new String[]{"USE master"});
            String sql = "IF EXISTS(select 1 from sys.databases where name='testDB') DROP DATABASE testDB\nCREATE DATABASE testDB\n";
            connection.execute(new String[]{sql});
            connection.execute(new String[]{"USE testDB"});
            connection.enableDbCdc(TEST_DATABASE);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while initating test database", e);
        }
    }

    public static void dropTestDatabase() {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            try {
                connection.execute(new String[]{"USE testDB"});
                connection.disableDbCdc(TEST_DATABASE);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            connection.execute(new String[]{"USE master"});
            String sql = "IF EXISTS(select 1 from sys.databases where name='testDB') DROP DATABASE testDB";
            connection.execute(new String[]{sql});
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while dropping test database", e);
        }
    }

    public static SqlServerConnection adminConnection() {
        return new SqlServerConnection((Configuration)TestHelper.adminJdbcConfig(), (JdbcConnection.ConnectionFactory)new SqlServerConnectionFactory());
    }

    public static SqlServerConnection testConnection() {
        return new SqlServerConnection((Configuration)TestHelper.defaultJdbcConfig(), (JdbcConnection.ConnectionFactory)new SqlServerConnectionFactory());
    }
}

