/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.util.Testing;
import java.math.BigInteger;
import java.sql.SQLException;
import org.junit.Before;
import org.junit.Test;

public class SqlServerConnectionIT {
    @Before
    public void before() throws SQLException {
        TestHelper.dropTestDatabase();
    }

    @Test
    public void shouldEnableCdcForDatabase() throws Exception {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            connection.execute(new String[]{"CREATE DATABASE testDB"});
            connection.execute(new String[]{"USE testDB"});
            connection.enableDbCdc("testDB");
        }
    }

    @Test
    public void shouldEnableCdcWithWrapperFunctionsForTable() throws Exception {
        try (SqlServerConnection connection = TestHelper.adminConnection();){
            connection.connect();
            connection.execute(new String[]{"CREATE DATABASE testDB"});
            connection.execute(new String[]{"USE testDB"});
            connection.enableDbCdc("testDB");
            String sql = "IF EXISTS (select 1 from sys.objects where name = 'testTable' and type = 'u')\nDROP TABLE testTable\nCREATE TABLE testTable (ID int not null identity(1, 1) primary key, NUMBER int, TEXT text)";
            connection.execute(new String[]{sql});
            connection.enableTableCdc("testTable");
            connection.execute(new String[]{"INSERT INTO testTable (NUMBER, TEXT) values (1, 'aaa')\nINSERT INTO testTable (NUMBER, TEXT) values (2, 'bbb')"});
            Thread.sleep(5000L);
            Testing.Print.enable();
            connection.query("select * from cdc.fn_cdc_get_all_changes_dbo_testTable(sys.fn_cdc_get_min_lsn('dbo_testTable'), sys.fn_cdc_get_max_lsn(), N'all')", rs -> {
                while (rs.next()) {
                    BigInteger lsn = new BigInteger(rs.getBytes(1));
                    StringBuilder sb = new StringBuilder(lsn.toString());
                    for (int col = 1; col <= rs.getMetaData().getColumnCount(); ++col) {
                        sb.append(rs.getObject(col)).append(' ');
                    }
                    Testing.print((Object)sb.toString());
                }
            });
            Testing.Print.disable();
        }
    }
}

