/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.util.TestHelper;
import io.debezium.data.SchemaAndValueField;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.time.Timestamp;
import io.debezium.util.Collect;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SnapshotIT
extends AbstractConnectorTest {
    private static final int INITIAL_RECORDS_PER_TABLE = 500;
    private static final int STREAMING_RECORDS_PER_TABLE = 500;
    private SqlServerConnection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.createTestDatabase();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE table1 (id int, name varchar(30), price decimal(8,2), ts datetime2(0), primary key(id))"});
        for (int i = 0; i < 500; ++i) {
            this.connection.execute(new String[]{String.format("INSERT INTO table1 VALUES(%s, '%s', %s, '%s')", i, "name" + i, new BigDecimal(i + ".23"), "2018-07-18 13:28:56")});
        }
        this.connection.enableTableCdc("table1");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void takeSnapshot() throws Exception {
        Configuration config = TestHelper.defaultConfig().build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(500);
        List table1 = records.recordsForTopic("server1.dbo.table1");
        Assertions.assertThat((List)table1).hasSize(500);
        for (int i = 0; i < 500; ++i) {
            SourceRecord record1 = (SourceRecord)table1.get(i);
            List<SchemaAndValueField> expectedKey1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)i));
            List<SchemaAndValueField> expectedRow1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)i), new SchemaAndValueField("name", Schema.OPTIONAL_STRING_SCHEMA, (Object)("name" + i)), new SchemaAndValueField("price", Decimal.builder((int)2).parameter("connect.decimal.precision", "8").optional().build(), (Object)new BigDecimal(i + ".23")), new SchemaAndValueField("ts", Timestamp.builder().optional().schema(), (Object)1531920536000L));
            Map expectedSource1 = Collect.hashMapOf((Object)"snapshot", (Object)true, (Object)"snapshot_completed", (Object)(i == 499 ? 1 : 0));
            Struct key1 = (Struct)record1.key();
            Struct value1 = (Struct)record1.value();
            this.assertRecord(key1, expectedKey1);
            this.assertRecord((Struct)value1.get("after"), expectedRow1);
            Assertions.assertThat((Map)record1.sourceOffset()).isEqualTo((Object)expectedSource1);
            Assert.assertNull((Object)value1.get("before"));
        }
    }

    @Test
    public void takeSnapshotAndStartStreaming() throws Exception {
        Configuration config = TestHelper.defaultConfig().build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.consumeRecordsByTopic(500);
        this.testStreaming();
    }

    private void testStreaming() throws SQLException, InterruptedException {
        for (int i = 0; i < 500; ++i) {
            int id = i + 500;
            this.connection.execute(new String[]{String.format("INSERT INTO table1 VALUES(%s, '%s', %s, '%s')", id, "name" + id, new BigDecimal(id + ".23"), "2018-07-18 13:28:56")});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(500);
        List table1 = records.recordsForTopic("server1.dbo.table1");
        Assertions.assertThat((List)table1).hasSize(500);
        for (int i = 0; i < 500; ++i) {
            int id = i + 500;
            SourceRecord record1 = (SourceRecord)table1.get(i);
            List<SchemaAndValueField> expectedKey1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id));
            List<SchemaAndValueField> expectedRow1 = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id), new SchemaAndValueField("name", Schema.OPTIONAL_STRING_SCHEMA, (Object)("name" + id)), new SchemaAndValueField("price", Decimal.builder((int)2).parameter("connect.decimal.precision", "8").optional().build(), (Object)new BigDecimal(id + ".23")), new SchemaAndValueField("ts", Timestamp.builder().optional().schema(), (Object)1531920536000L));
            Struct key1 = (Struct)record1.key();
            Struct value1 = (Struct)record1.value();
            this.assertRecord(key1, expectedKey1);
            this.assertRecord((Struct)value1.get("after"), expectedRow1);
            Assertions.assertThat((Map)record1.sourceOffset()).hasSize(1);
            Assert.assertTrue((boolean)record1.sourceOffset().containsKey("change_lsn"));
            Assert.assertNull((Object)value1.get("before"));
        }
    }

    @Test
    public void takeSchemaOnlySnapshotAndStartStreaming() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(SqlServerConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)SqlServerConnectorConfig.SnapshotMode.INITIAL_SCHEMA_ONLY)).build();
        this.start(SqlServerConnector.class, config);
        this.assertConnectorIsRunning();
        this.testStreaming();
    }

    private void assertRecord(Struct record, List<SchemaAndValueField> expected) {
        expected.forEach(schemaAndValueField -> schemaAndValueField.assertFor(record));
    }
}

