/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.Configuration;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.DataCollectionFilters;
import java.util.function.Predicate;

public class RelationalTableFilters
implements DataCollectionFilters {
    private final Tables.TableFilter tableFilter;

    public RelationalTableFilters(Configuration config, Tables.TableFilter systemTablesFilter) {
        Predicate<TableId> predicate = Selectors.tableSelector().includeTables(config.getString(RelationalDatabaseConnectorConfig.TABLE_WHITELIST)).excludeTables(config.getString(RelationalDatabaseConnectorConfig.TABLE_BLACKLIST)).build();
        Predicate<TableId> finalPredicate = config.getBoolean(RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN) ? predicate.and(systemTablesFilter::isIncluded) : predicate;
        this.tableFilter = t -> finalPredicate.test(t);
    }

    public Tables.TableFilter dataCollectionFilter() {
        return this.tableFilter;
    }
}

