/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.avro;

import io.confluent.connect.avro.AvroDataConfig;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.NumericNode;
import org.codehaus.jackson.node.ObjectNode;

public class AvroData {
    public static final String NAMESPACE = "io.confluent.connect.avro";
    public static final String DEFAULT_SCHEMA_NAME = "ConnectDefault";
    public static final String DEFAULT_SCHEMA_FULL_NAME = "io.confluent.connect.avro.ConnectDefault";
    public static final String MAP_ENTRY_TYPE_NAME = "MapEntry";
    public static final String KEY_FIELD = "key";
    public static final String VALUE_FIELD = "value";
    public static final String CONNECT_NAME_PROP = "connect.name";
    public static final String CONNECT_DOC_PROP = "connect.doc";
    public static final String CONNECT_RECORD_DOC_PROP = "connect.record.doc";
    public static final String CONNECT_ENUM_DOC_PROP = "connect.enum.doc";
    public static final String CONNECT_VERSION_PROP = "connect.version";
    public static final String CONNECT_DEFAULT_VALUE_PROP = "connect.default";
    public static final String CONNECT_PARAMETERS_PROP = "connect.parameters";
    public static final String CONNECT_TYPE_PROP = "connect.type";
    public static final String CONNECT_TYPE_INT8 = "int8";
    public static final String CONNECT_TYPE_INT16 = "int16";
    public static final String AVRO_TYPE_UNION = "io.confluent.connect.avro.Union";
    public static final String AVRO_TYPE_ENUM = "io.confluent.connect.avro.Enum";
    public static final String AVRO_TYPE_ANYTHING = "io.confluent.connect.avro.Anything";
    private static final Map<String, Schema.Type> NON_AVRO_TYPES_BY_TYPE_CODE = new HashMap<String, Schema.Type>();
    private static final Map<Schema.Type, List<Class>> SIMPLE_AVRO_SCHEMA_TYPES;
    private static final Map<Schema.Type, Schema.Type> CONNECT_TYPES_TO_AVRO_TYPES;
    private static final String ANYTHING_SCHEMA_BOOLEAN_FIELD = "boolean";
    private static final String ANYTHING_SCHEMA_BYTES_FIELD = "bytes";
    private static final String ANYTHING_SCHEMA_DOUBLE_FIELD = "double";
    private static final String ANYTHING_SCHEMA_FLOAT_FIELD = "float";
    private static final String ANYTHING_SCHEMA_INT_FIELD = "int";
    private static final String ANYTHING_SCHEMA_LONG_FIELD = "long";
    private static final String ANYTHING_SCHEMA_STRING_FIELD = "string";
    private static final String ANYTHING_SCHEMA_ARRAY_FIELD = "array";
    private static final String ANYTHING_SCHEMA_MAP_FIELD = "map";
    public static final Schema ANYTHING_SCHEMA_MAP_ELEMENT;
    public static final Schema ANYTHING_SCHEMA;
    private static final Schema NULL_AVRO_SCHEMA;
    private static final HashMap<String, LogicalTypeConverter> TO_CONNECT_LOGICAL_CONVERTERS;
    static final String AVRO_PROP = "avro";
    static final String AVRO_LOGICAL_TYPE_PROP = "logicalType";
    static final String AVRO_LOGICAL_TIMESTAMP_MILLIS = "timestamp-millis";
    static final String AVRO_LOGICAL_TIME_MILLIS = "time-millis";
    static final String AVRO_LOGICAL_DATE = "date";
    static final String AVRO_LOGICAL_DECIMAL = "decimal";
    static final String AVRO_LOGICAL_DECIMAL_SCALE_PROP = "scale";
    static final String AVRO_LOGICAL_DECIMAL_PRECISION_PROP = "precision";
    static final String CONNECT_AVRO_DECIMAL_PRECISION_PROP = "connect.decimal.precision";
    static final Integer CONNECT_AVRO_DECIMAL_PRECISION_DEFAULT;
    private static final HashMap<String, LogicalTypeConverter> TO_AVRO_LOGICAL_CONVERTERS;
    private Cache<org.apache.kafka.connect.data.Schema, Schema> fromConnectSchemaCache;
    private Cache<Schema, org.apache.kafka.connect.data.Schema> toConnectSchemaCache;
    private boolean connectMetaData;
    private boolean enhancedSchemaSupport;

    public AvroData(int cacheSize) {
        this(new AvroDataConfig.Builder().with("schemas.cache.config", cacheSize).build());
    }

    public AvroData(AvroDataConfig avroDataConfig) {
        this.fromConnectSchemaCache = new SynchronizedCache((Cache)new LRUCache(avroDataConfig.getSchemasCacheSize()));
        this.toConnectSchemaCache = new SynchronizedCache((Cache)new LRUCache(avroDataConfig.getSchemasCacheSize()));
        this.connectMetaData = avroDataConfig.isConnectMetaData();
        this.enhancedSchemaSupport = avroDataConfig.isEnhancedAvroSchemaSupport();
    }

    public Object fromConnectData(org.apache.kafka.connect.data.Schema schema, Object value) {
        Schema avroSchema = this.fromConnectSchema(schema);
        return AvroData.fromConnectData(schema, avroSchema, value, true, false, this.enhancedSchemaSupport);
    }

    private static Object fromConnectData(org.apache.kafka.connect.data.Schema schema, Schema avroSchema, Object logicalValue, boolean requireContainer, boolean requireSchemalessContainerNull, boolean enhancedSchemaSupport) {
        LogicalTypeConverter logicalConverter;
        Schema.Type schemaType;
        Schema.Type type = schemaType = schema != null ? schema.type() : AvroData.schemaTypeForSchemalessJavaType(logicalValue);
        if (schemaType == null) {
            if (requireSchemalessContainerNull) {
                return new GenericRecordBuilder(ANYTHING_SCHEMA).build();
            }
            return null;
        }
        AvroData.validateSchemaValue(schema, logicalValue);
        if (logicalValue == null) {
            if (schema == null && requireSchemalessContainerNull) {
                return new GenericRecordBuilder(ANYTHING_SCHEMA).build();
            }
            return null;
        }
        Object value = logicalValue;
        if (schema != null && schema.name() != null && (logicalConverter = TO_AVRO_LOGICAL_CONVERTERS.get(schema.name())) != null && logicalValue != null) {
            value = logicalConverter.convert(schema, logicalValue);
        }
        try {
            switch (schemaType) {
                case INT8: {
                    Byte byteValue = (Byte)value;
                    Integer convertedByteValue = byteValue == null ? null : Integer.valueOf(byteValue.intValue());
                    return AvroData.maybeAddContainer(avroSchema, AvroData.maybeWrapSchemaless(schema, convertedByteValue, ANYTHING_SCHEMA_INT_FIELD), requireContainer);
                }
                case INT16: {
                    Short shortValue = (Short)value;
                    Integer convertedShortValue = shortValue == null ? null : Integer.valueOf(shortValue.intValue());
                    return AvroData.maybeAddContainer(avroSchema, AvroData.maybeWrapSchemaless(schema, convertedShortValue, ANYTHING_SCHEMA_INT_FIELD), requireContainer);
                }
                case INT32: {
                    Integer intValue = (Integer)value;
                    return AvroData.maybeAddContainer(avroSchema, AvroData.maybeWrapSchemaless(schema, value, ANYTHING_SCHEMA_INT_FIELD), requireContainer);
                }
                case INT64: {
                    Long longValue = (Long)value;
                    return AvroData.maybeAddContainer(avroSchema, AvroData.maybeWrapSchemaless(schema, value, ANYTHING_SCHEMA_LONG_FIELD), requireContainer);
                }
                case FLOAT32: {
                    Float floatValue = (Float)value;
                    return AvroData.maybeAddContainer(avroSchema, AvroData.maybeWrapSchemaless(schema, value, ANYTHING_SCHEMA_FLOAT_FIELD), requireContainer);
                }
                case FLOAT64: {
                    Double doubleValue = (Double)value;
                    return AvroData.maybeAddContainer(avroSchema, AvroData.maybeWrapSchemaless(schema, value, ANYTHING_SCHEMA_DOUBLE_FIELD), requireContainer);
                }
                case BOOLEAN: {
                    Boolean boolValue = (Boolean)value;
                    return AvroData.maybeAddContainer(avroSchema, AvroData.maybeWrapSchemaless(schema, value, ANYTHING_SCHEMA_BOOLEAN_FIELD), requireContainer);
                }
                case STRING: {
                    if (enhancedSchemaSupport && schema != null && schema.parameters() != null && schema.parameters().containsKey(AVRO_TYPE_ENUM)) {
                        Schema enumSchema;
                        String enumSchemaName = (String)schema.parameters().get(AVRO_TYPE_ENUM);
                        if (avroSchema.getType() == Schema.Type.UNION) {
                            int enumIndex = avroSchema.getIndexNamed(enumSchemaName);
                            enumSchema = (Schema)avroSchema.getTypes().get(enumIndex);
                        } else {
                            enumSchema = avroSchema;
                        }
                        value = new GenericData.EnumSymbol(enumSchema, (String)value);
                    } else {
                        String enumSchemaName = (String)value;
                    }
                    return AvroData.maybeAddContainer(avroSchema, AvroData.maybeWrapSchemaless(schema, value, ANYTHING_SCHEMA_STRING_FIELD), requireContainer);
                }
                case BYTES: {
                    ByteBuffer bytesValue = value instanceof byte[] ? ByteBuffer.wrap((byte[])value) : (ByteBuffer)value;
                    return AvroData.maybeAddContainer(avroSchema, AvroData.maybeWrapSchemaless(schema, bytesValue, ANYTHING_SCHEMA_BYTES_FIELD), requireContainer);
                }
                case ARRAY: {
                    Collection list = (Collection)value;
                    ArrayList<Object> converted = new ArrayList<Object>(list.size());
                    org.apache.kafka.connect.data.Schema elementSchema = schema != null ? schema.valueSchema() : null;
                    Schema underlyingAvroSchema = AvroData.avroSchemaForUnderlyingTypeIfOptional(schema, avroSchema);
                    Schema elementAvroSchema = schema != null ? underlyingAvroSchema.getElementType() : ANYTHING_SCHEMA;
                    for (Object val : list) {
                        converted.add(AvroData.fromConnectData(elementSchema, elementAvroSchema, val, false, true, enhancedSchemaSupport));
                    }
                    return AvroData.maybeAddContainer(avroSchema, AvroData.maybeWrapSchemaless(schema, converted, ANYTHING_SCHEMA_ARRAY_FIELD), requireContainer);
                }
                case MAP: {
                    Map map = (Map)value;
                    if (schema != null && schema.keySchema().type() == Schema.Type.STRING && !schema.keySchema().isOptional()) {
                        Schema underlyingAvroSchema = AvroData.avroSchemaForUnderlyingTypeIfOptional(schema, avroSchema);
                        HashMap<String, Object> converted = new HashMap<String, Object>();
                        for (Map.Entry entry : map.entrySet()) {
                            Object convertedValue = AvroData.fromConnectData(schema.valueSchema(), underlyingAvroSchema.getValueType(), entry.getValue(), false, true, enhancedSchemaSupport);
                            converted.put((String)entry.getKey(), convertedValue);
                        }
                        return AvroData.maybeAddContainer(avroSchema, converted, requireContainer);
                    }
                    ArrayList<GenericData.Record> converted = new ArrayList<GenericData.Record>(map.size());
                    Schema underlyingAvroSchema = AvroData.avroSchemaForUnderlyingMapEntryType(schema, avroSchema);
                    Schema elementSchema = schema != null ? underlyingAvroSchema.getElementType() : ANYTHING_SCHEMA_MAP_ELEMENT;
                    Schema avroKeySchema = elementSchema.getField(KEY_FIELD).schema();
                    Schema avroValueSchema = elementSchema.getField(VALUE_FIELD).schema();
                    for (Map.Entry entry : map.entrySet()) {
                        Object keyConverted = AvroData.fromConnectData(schema != null ? schema.keySchema() : null, avroKeySchema, entry.getKey(), false, true, enhancedSchemaSupport);
                        Object valueConverted = AvroData.fromConnectData(schema != null ? schema.valueSchema() : null, avroValueSchema, entry.getValue(), false, true, enhancedSchemaSupport);
                        converted.add(new GenericRecordBuilder(elementSchema).set(KEY_FIELD, keyConverted).set(VALUE_FIELD, valueConverted).build());
                    }
                    return AvroData.maybeAddContainer(avroSchema, AvroData.maybeWrapSchemaless(schema, converted, ANYTHING_SCHEMA_MAP_FIELD), requireContainer);
                }
                case STRUCT: {
                    Struct struct = (Struct)value;
                    if (!struct.schema().equals(schema)) {
                        throw new DataException("Mismatching struct schema");
                    }
                    if (AVRO_TYPE_UNION.equals(schema.name())) {
                        for (Field field : schema.fields()) {
                            Object object = struct.get(field);
                            if (object == null) continue;
                            return AvroData.fromConnectData(field.schema(), avroSchema, object, false, true, enhancedSchemaSupport);
                        }
                        return AvroData.fromConnectData(schema, avroSchema, null, false, true, enhancedSchemaSupport);
                    }
                    Schema underlyingAvroSchema = AvroData.avroSchemaForUnderlyingTypeIfOptional(schema, avroSchema);
                    GenericRecordBuilder convertedBuilder = new GenericRecordBuilder(underlyingAvroSchema);
                    for (Field field : schema.fields()) {
                        Schema.Field theField = underlyingAvroSchema.getField(field.name());
                        Schema fieldAvroSchema = theField.schema();
                        convertedBuilder.set(field.name(), AvroData.fromConnectData(field.schema(), fieldAvroSchema, struct.get(field), false, true, enhancedSchemaSupport));
                    }
                    return convertedBuilder.build();
                }
            }
            throw new DataException("Unknown schema type: " + schema.type());
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type for " + schema.type() + ": " + value.getClass());
        }
    }

    private static Schema avroSchemaForUnderlyingMapEntryType(org.apache.kafka.connect.data.Schema schema, Schema avroSchema) {
        if (schema != null && schema.isOptional()) {
            if (avroSchema.getType() == Schema.Type.UNION) {
                for (Schema typeSchema : avroSchema.getTypes()) {
                    if (typeSchema.getType().equals((Object)Schema.Type.NULL) || !Schema.Type.ARRAY.getName().equals(typeSchema.getType().getName())) continue;
                    return typeSchema;
                }
            } else {
                throw new DataException("An optional schema should have an Avro Union type, not " + schema.type());
            }
        }
        return avroSchema;
    }

    private static Schema avroSchemaForUnderlyingTypeIfOptional(org.apache.kafka.connect.data.Schema schema, Schema avroSchema) {
        if (schema != null && schema.isOptional()) {
            if (avroSchema.getType() == Schema.Type.UNION) {
                for (Schema typeSchema : avroSchema.getTypes()) {
                    if (typeSchema.getType().equals((Object)Schema.Type.NULL) || !typeSchema.getFullName().equals(schema.name()) && !typeSchema.getType().getName().equals(schema.type().getName())) continue;
                    return typeSchema;
                }
            } else {
                throw new DataException("An optinal schema should have an Avro Union type, not " + schema.type());
            }
        }
        return avroSchema;
    }

    private static Schema.Type schemaTypeForSchemalessJavaType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return Schema.Type.INT8;
        }
        if (value instanceof Short) {
            return Schema.Type.INT16;
        }
        if (value instanceof Integer) {
            return Schema.Type.INT32;
        }
        if (value instanceof Long) {
            return Schema.Type.INT64;
        }
        if (value instanceof Float) {
            return Schema.Type.FLOAT32;
        }
        if (value instanceof Double) {
            return Schema.Type.FLOAT64;
        }
        if (value instanceof Boolean) {
            return Schema.Type.BOOLEAN;
        }
        if (value instanceof String) {
            return Schema.Type.STRING;
        }
        if (value instanceof Collection) {
            return Schema.Type.ARRAY;
        }
        if (value instanceof Map) {
            return Schema.Type.MAP;
        }
        throw new DataException("Unknown Java type for schemaless data: " + value.getClass());
    }

    private static Object maybeAddContainer(Schema avroSchema, Object value, boolean wrap) {
        return wrap ? new NonRecordContainer(avroSchema, value) : value;
    }

    private static Object maybeWrapSchemaless(org.apache.kafka.connect.data.Schema schema, Object value, String typeField) {
        if (schema != null) {
            return value;
        }
        GenericRecordBuilder builder = new GenericRecordBuilder(ANYTHING_SCHEMA);
        if (value != null) {
            builder.set(typeField, value);
        }
        return builder.build();
    }

    public Schema fromConnectSchema(org.apache.kafka.connect.data.Schema schema) {
        return this.fromConnectSchema(schema, new HashMap<org.apache.kafka.connect.data.Schema, Schema>());
    }

    public Schema fromConnectSchema(org.apache.kafka.connect.data.Schema schema, Map<org.apache.kafka.connect.data.Schema, Schema> schemaMap) {
        return this.fromConnectSchema(schema, schemaMap, false);
    }

    public Schema fromConnectSchema(org.apache.kafka.connect.data.Schema schema, Map<org.apache.kafka.connect.data.Schema, Schema> schemaMap, boolean ignoreOptional) {
        Schema baseSchema;
        if (schema == null) {
            return ANYTHING_SCHEMA;
        }
        Schema cached = (Schema)this.fromConnectSchemaCache.get((Object)schema);
        if (cached == null && !AVRO_TYPE_UNION.equals(schema.name()) && !schema.isOptional()) {
            cached = schemaMap.get(schema);
        }
        if (cached != null) {
            return cached;
        }
        String namespace = NAMESPACE;
        String name = DEFAULT_SCHEMA_NAME;
        if (schema.name() != null) {
            String[] split = AvroData.splitName(schema.name());
            namespace = split[0];
            name = split[1];
        }
        String connectType = null;
        switch (schema.type()) {
            case INT8: {
                connectType = CONNECT_TYPE_INT8;
                baseSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
                break;
            }
            case INT16: {
                connectType = CONNECT_TYPE_INT16;
                baseSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
                break;
            }
            case INT32: {
                baseSchema = (Schema)org.apache.avro.SchemaBuilder.builder().intType();
                break;
            }
            case INT64: {
                baseSchema = (Schema)org.apache.avro.SchemaBuilder.builder().longType();
                break;
            }
            case FLOAT32: {
                baseSchema = (Schema)org.apache.avro.SchemaBuilder.builder().floatType();
                break;
            }
            case FLOAT64: {
                baseSchema = (Schema)org.apache.avro.SchemaBuilder.builder().doubleType();
                break;
            }
            case BOOLEAN: {
                baseSchema = (Schema)org.apache.avro.SchemaBuilder.builder().booleanType();
                break;
            }
            case STRING: {
                if (this.enhancedSchemaSupport && schema.parameters() != null && schema.parameters().containsKey(AVRO_TYPE_ENUM)) {
                    ArrayList symbols = new ArrayList();
                    for (Map.Entry entry : schema.parameters().entrySet()) {
                        if (!((String)entry.getKey()).startsWith("io.confluent.connect.avro.Enum.")) continue;
                        symbols.add(entry.getValue());
                    }
                    baseSchema = (Schema)((SchemaBuilder.EnumBuilder)org.apache.avro.SchemaBuilder.builder().enumeration((String)schema.parameters().get(AVRO_TYPE_ENUM)).doc((String)schema.parameters().get(CONNECT_ENUM_DOC_PROP))).symbols(symbols.toArray(new String[symbols.size()]));
                    break;
                }
                baseSchema = (Schema)org.apache.avro.SchemaBuilder.builder().stringType();
                break;
            }
            case BYTES: {
                baseSchema = (Schema)org.apache.avro.SchemaBuilder.builder().bytesType();
                if (!"org.apache.kafka.connect.data.Decimal".equalsIgnoreCase(schema.name())) break;
                int scale = Integer.parseInt((String)schema.parameters().get(AVRO_LOGICAL_DECIMAL_SCALE_PROP));
                baseSchema.addProp(AVRO_LOGICAL_DECIMAL_SCALE_PROP, (JsonNode)new IntNode(scale));
                if (schema.parameters().containsKey(CONNECT_AVRO_DECIMAL_PRECISION_PROP)) {
                    String precisionValue = (String)schema.parameters().get(CONNECT_AVRO_DECIMAL_PRECISION_PROP);
                    int n = Integer.parseInt(precisionValue);
                    baseSchema.addProp(AVRO_LOGICAL_DECIMAL_PRECISION_PROP, (JsonNode)new IntNode(n));
                    break;
                }
                baseSchema.addProp(AVRO_LOGICAL_DECIMAL_PRECISION_PROP, (JsonNode)new IntNode(CONNECT_AVRO_DECIMAL_PRECISION_DEFAULT.intValue()));
                break;
            }
            case ARRAY: {
                baseSchema = (Schema)org.apache.avro.SchemaBuilder.builder().array().items(this.fromConnectSchema(schema.valueSchema()));
                break;
            }
            case MAP: {
                if (schema.keySchema().type() == Schema.Type.STRING && !schema.keySchema().isOptional()) {
                    baseSchema = (Schema)org.apache.avro.SchemaBuilder.builder().map().values(this.fromConnectSchema(schema.valueSchema()));
                    break;
                }
                SchemaBuilder.FieldAssembler fieldAssembler = ((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.builder().array().items().record(MAP_ENTRY_TYPE_NAME).namespace(NAMESPACE)).fields();
                this.addAvroRecordField((SchemaBuilder.FieldAssembler<Schema>)fieldAssembler, KEY_FIELD, schema.keySchema(), schemaMap);
                this.addAvroRecordField((SchemaBuilder.FieldAssembler<Schema>)fieldAssembler, VALUE_FIELD, schema.valueSchema(), schemaMap);
                baseSchema = (Schema)fieldAssembler.endRecord();
                break;
            }
            case STRUCT: {
                if (AVRO_TYPE_UNION.equals(schema.name())) {
                    ArrayList<Object> unionSchemas = new ArrayList<Object>();
                    if (schema.isOptional()) {
                        unionSchemas.add(org.apache.avro.SchemaBuilder.builder().nullType());
                    }
                    for (Field field : schema.fields()) {
                        unionSchemas.add(this.fromConnectSchema(AvroData.nonOptional(field.schema()), schemaMap, true));
                    }
                    baseSchema = Schema.createUnion(unionSchemas);
                    break;
                }
                if (schema.isOptional()) {
                    ArrayList<Object> unionSchemas = new ArrayList<Object>();
                    unionSchemas.add(org.apache.avro.SchemaBuilder.builder().nullType());
                    unionSchemas.add(this.fromConnectSchema(AvroData.nonOptional(schema), schemaMap, false));
                    baseSchema = Schema.createUnion(unionSchemas);
                    break;
                }
                String doc = schema.parameters() != null ? (String)schema.parameters().get(CONNECT_RECORD_DOC_PROP) : null;
                SchemaBuilder.FieldAssembler fieldAssembler = ((SchemaBuilder.RecordBuilder)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)(name != null ? name : DEFAULT_SCHEMA_NAME)).namespace(namespace)).doc(doc)).fields();
                for (Field field : schema.fields()) {
                    this.addAvroRecordField((SchemaBuilder.FieldAssembler<Schema>)fieldAssembler, field.name(), field.schema(), schemaMap);
                }
                baseSchema = (Schema)fieldAssembler.endRecord();
                break;
            }
            default: {
                throw new DataException("Unknown schema type: " + schema.type());
            }
        }
        Schema finalSchema = baseSchema;
        if (!baseSchema.getType().equals((Object)Schema.Type.UNION)) {
            if (this.connectMetaData) {
                if (schema.doc() != null) {
                    baseSchema.addProp(CONNECT_DOC_PROP, schema.doc());
                }
                if (schema.version() != null) {
                    baseSchema.addProp(CONNECT_VERSION_PROP, (JsonNode)JsonNodeFactory.instance.numberNode(schema.version()));
                }
                if (schema.parameters() != null) {
                    baseSchema.addProp(CONNECT_PARAMETERS_PROP, AvroData.parametersFromConnect(schema.parameters()));
                }
                if (schema.defaultValue() != null) {
                    baseSchema.addProp(CONNECT_DEFAULT_VALUE_PROP, AvroData.defaultValueFromConnect(schema, schema.defaultValue()));
                }
                if (schema.name() != null) {
                    baseSchema.addProp(CONNECT_NAME_PROP, schema.name());
                }
                if (connectType != null) {
                    baseSchema.addProp(CONNECT_TYPE_PROP, connectType);
                }
            }
            if (schema.name() != null) {
                if ("org.apache.kafka.connect.data.Decimal".equalsIgnoreCase(schema.name())) {
                    baseSchema.addProp(AVRO_LOGICAL_TYPE_PROP, AVRO_LOGICAL_DECIMAL);
                } else if ("org.apache.kafka.connect.data.Time".equalsIgnoreCase(schema.name())) {
                    baseSchema.addProp(AVRO_LOGICAL_TYPE_PROP, AVRO_LOGICAL_TIME_MILLIS);
                } else if ("org.apache.kafka.connect.data.Timestamp".equalsIgnoreCase(schema.name())) {
                    baseSchema.addProp(AVRO_LOGICAL_TYPE_PROP, AVRO_LOGICAL_TIMESTAMP_MILLIS);
                } else if ("org.apache.kafka.connect.data.Date".equalsIgnoreCase(schema.name())) {
                    baseSchema.addProp(AVRO_LOGICAL_TYPE_PROP, AVRO_LOGICAL_DATE);
                }
            }
            if (schema.parameters() != null) {
                for (Map.Entry entry : schema.parameters().entrySet()) {
                    if (!((String)entry.getKey()).startsWith(AVRO_PROP)) continue;
                    baseSchema.addProp((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!ignoreOptional && schema.isOptional()) {
                finalSchema = schema.defaultValue() != null ? (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().type(baseSchema)).and().nullType()).endUnion() : (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)org.apache.avro.SchemaBuilder.builder().unionOf().nullType()).and().type(baseSchema)).endUnion();
            }
        }
        if (!schema.isOptional()) {
            schemaMap.put(schema, finalSchema);
        }
        this.fromConnectSchemaCache.put((Object)schema, (Object)finalSchema);
        return finalSchema;
    }

    private void addAvroRecordField(SchemaBuilder.FieldAssembler<Schema> fieldAssembler, String fieldName, org.apache.kafka.connect.data.Schema fieldSchema, Map<org.apache.kafka.connect.data.Schema, Schema> schemaMap) {
        SchemaBuilder.GenericDefault fieldAvroSchema = ((SchemaBuilder.FieldBuilder)fieldAssembler.name(fieldName).doc(fieldSchema.doc())).type(this.fromConnectSchema(fieldSchema, schemaMap));
        if (fieldSchema.defaultValue() != null) {
            fieldAvroSchema.withDefault((Object)AvroData.defaultValueFromConnect(fieldSchema, fieldSchema.defaultValue()));
        } else if (fieldSchema.isOptional()) {
            fieldAvroSchema.withDefault((Object)JsonNodeFactory.instance.nullNode());
        } else {
            fieldAvroSchema.noDefault();
        }
    }

    private static JsonNode defaultValueFromConnect(org.apache.kafka.connect.data.Schema schema, Object value) {
        try {
            LogicalTypeConverter logicalConverter;
            Object defaultVal = value;
            if (schema != null && schema.name() != null && (logicalConverter = TO_AVRO_LOGICAL_CONVERTERS.get(schema.name())) != null && value != null) {
                defaultVal = logicalConverter.convert(schema, value);
            }
            switch (schema.type()) {
                case INT8: {
                    return JsonNodeFactory.instance.numberNode((Byte)defaultVal);
                }
                case INT16: {
                    return JsonNodeFactory.instance.numberNode((Short)defaultVal);
                }
                case INT32: {
                    return JsonNodeFactory.instance.numberNode((Integer)defaultVal);
                }
                case INT64: {
                    return JsonNodeFactory.instance.numberNode((Long)defaultVal);
                }
                case FLOAT32: {
                    return JsonNodeFactory.instance.numberNode((Float)defaultVal);
                }
                case FLOAT64: {
                    return JsonNodeFactory.instance.numberNode((Double)defaultVal);
                }
                case BOOLEAN: {
                    return JsonNodeFactory.instance.booleanNode(((Boolean)defaultVal).booleanValue());
                }
                case STRING: {
                    return JsonNodeFactory.instance.textNode((String)defaultVal);
                }
                case BYTES: {
                    if (defaultVal instanceof byte[]) {
                        return JsonNodeFactory.instance.binaryNode((byte[])defaultVal);
                    }
                    return JsonNodeFactory.instance.binaryNode(((ByteBuffer)defaultVal).array());
                }
                case ARRAY: {
                    ArrayNode array = JsonNodeFactory.instance.arrayNode();
                    for (Object elem : (Collection)defaultVal) {
                        array.add(AvroData.defaultValueFromConnect(schema.valueSchema(), elem));
                    }
                    return array;
                }
                case MAP: {
                    ObjectNode node;
                    if (schema.keySchema().type() == Schema.Type.STRING && !schema.keySchema().isOptional()) {
                        node = JsonNodeFactory.instance.objectNode();
                        for (Map.Entry entry : ((Map)defaultVal).entrySet()) {
                            JsonNode entryDef = AvroData.defaultValueFromConnect(schema.valueSchema(), entry.getValue());
                            node.put((String)entry.getKey(), entryDef);
                        }
                        return node;
                    }
                    ArrayNode array = JsonNodeFactory.instance.arrayNode();
                    for (Map.Entry entry : ((Map)defaultVal).entrySet()) {
                        JsonNode keyDefault = AvroData.defaultValueFromConnect(schema.keySchema(), entry.getKey());
                        JsonNode valDefault = AvroData.defaultValueFromConnect(schema.valueSchema(), entry.getValue());
                        ArrayNode jsonEntry = JsonNodeFactory.instance.arrayNode();
                        jsonEntry.add(keyDefault);
                        jsonEntry.add(valDefault);
                        array.add((JsonNode)jsonEntry);
                    }
                    return array;
                }
                case STRUCT: {
                    ObjectNode node = JsonNodeFactory.instance.objectNode();
                    Struct struct = (Struct)defaultVal;
                    for (Field field : schema.fields()) {
                        JsonNode fieldDef = AvroData.defaultValueFromConnect(field.schema(), struct.get(field));
                        node.put(field.name(), fieldDef);
                    }
                    return node;
                }
            }
            throw new DataException("Unknown schema type:" + schema.type());
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type used for default value of " + schema.type() + " field: " + schema.defaultValue().getClass());
        }
    }

    private static JsonNode parametersFromConnect(Map<String, String> params) {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static void validateSchemaValue(org.apache.kafka.connect.data.Schema schema, Object value) throws DataException {
        if (value == null && schema != null && !schema.isOptional()) {
            throw new DataException("Found null value for non-optional schema");
        }
    }

    public SchemaAndValue toConnectData(Schema avroSchema, Object value) {
        if (value == null) {
            return null;
        }
        org.apache.kafka.connect.data.Schema schema = avroSchema.equals((Object)ANYTHING_SCHEMA) ? null : this.toConnectSchema(avroSchema);
        return new SchemaAndValue(schema, this.toConnectData(schema, value));
    }

    private Object toConnectData(org.apache.kafka.connect.data.Schema schema, Object value) {
        AvroData.validateSchemaValue(schema, value);
        if (value == null) {
            return null;
        }
        try {
            LogicalTypeConverter logicalConverter;
            if (schema == null) {
                if (!(value instanceof IndexedRecord)) {
                    throw new DataException("Invalid Avro data for schemaless Connect data");
                }
                IndexedRecord recordValue = (IndexedRecord)value;
                Object boolVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_BOOLEAN_FIELD).pos());
                if (boolVal != null) {
                    return this.toConnectData(org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA, boolVal);
                }
                Object bytesVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_BYTES_FIELD).pos());
                if (bytesVal != null) {
                    return this.toConnectData(org.apache.kafka.connect.data.Schema.BYTES_SCHEMA, bytesVal);
                }
                Object dblVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_DOUBLE_FIELD).pos());
                if (dblVal != null) {
                    return this.toConnectData(org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA, dblVal);
                }
                Object fltVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_FLOAT_FIELD).pos());
                if (fltVal != null) {
                    return this.toConnectData(org.apache.kafka.connect.data.Schema.FLOAT32_SCHEMA, fltVal);
                }
                Object intVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_INT_FIELD).pos());
                if (intVal != null) {
                    return this.toConnectData(org.apache.kafka.connect.data.Schema.INT32_SCHEMA, intVal);
                }
                Object longVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_LONG_FIELD).pos());
                if (longVal != null) {
                    return this.toConnectData(org.apache.kafka.connect.data.Schema.INT64_SCHEMA, longVal);
                }
                Object stringVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_STRING_FIELD).pos());
                if (stringVal != null) {
                    return this.toConnectData(org.apache.kafka.connect.data.Schema.STRING_SCHEMA, stringVal);
                }
                Object arrayVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_ARRAY_FIELD).pos());
                if (arrayVal != null) {
                    if (!(arrayVal instanceof Collection)) {
                        throw new DataException("Expected a Collection for schemaless array field but found a " + arrayVal.getClass().getName());
                    }
                    Collection original = (Collection)arrayVal;
                    ArrayList<Object> result = new ArrayList<Object>(original.size());
                    for (Object elem : original) {
                        result.add(this.toConnectData((org.apache.kafka.connect.data.Schema)null, elem));
                    }
                    return result;
                }
                Object mapVal = recordValue.get(ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_MAP_FIELD).pos());
                if (mapVal != null) {
                    if (!(mapVal instanceof Collection)) {
                        throw new DataException("Expected a List for schemaless map field but found a " + mapVal.getClass().getName());
                    }
                    Collection original = (Collection)mapVal;
                    HashMap<Object, Object> result = new HashMap<Object, Object>(original.size());
                    for (IndexedRecord entry : original) {
                        int avroKeyFieldIndex = entry.getSchema().getField(KEY_FIELD).pos();
                        int avroValueFieldIndex = entry.getSchema().getField(VALUE_FIELD).pos();
                        Object convertedKey = this.toConnectData((org.apache.kafka.connect.data.Schema)null, entry.get(avroKeyFieldIndex));
                        Object convertedValue = this.toConnectData((org.apache.kafka.connect.data.Schema)null, entry.get(avroValueFieldIndex));
                        result.put(convertedKey, convertedValue);
                    }
                    return result;
                }
                return null;
            }
            Object converted = null;
            switch (schema.type()) {
                case INT32: {
                    Integer intValue = (Integer)value;
                    converted = value;
                    break;
                }
                case INT64: {
                    Long longValue = (Long)value;
                    converted = value;
                    break;
                }
                case FLOAT32: {
                    Float floatValue = (Float)value;
                    converted = value;
                    break;
                }
                case FLOAT64: {
                    Double doubleValue = (Double)value;
                    converted = value;
                    break;
                }
                case BOOLEAN: {
                    Boolean boolValue = (Boolean)value;
                    converted = value;
                    break;
                }
                case INT8: {
                    converted = ((Integer)value).byteValue();
                    break;
                }
                case INT16: {
                    converted = ((Integer)value).shortValue();
                    break;
                }
                case STRING: {
                    if (value instanceof String) {
                        converted = value;
                        break;
                    }
                    if (value instanceof CharSequence || value instanceof GenericEnumSymbol || value instanceof Enum) {
                        converted = value.toString();
                        break;
                    }
                    throw new DataException("Invalid class for string type, expecting String or CharSequence but found " + value.getClass());
                }
                case BYTES: {
                    if (value instanceof byte[]) {
                        converted = ByteBuffer.wrap((byte[])value);
                        break;
                    }
                    if (value instanceof ByteBuffer) {
                        converted = value;
                        break;
                    }
                    if (value instanceof GenericFixed) {
                        converted = ByteBuffer.wrap(((GenericFixed)value).bytes());
                        break;
                    }
                    throw new DataException("Invalid class for bytes type, expecting byte[] or ByteBuffer but found " + value.getClass());
                }
                case ARRAY: {
                    org.apache.kafka.connect.data.Schema valueSchema = schema.valueSchema();
                    Collection original = (Collection)value;
                    Struct result = new ArrayList(original.size());
                    for (Object elem : original) {
                        result.add(this.toConnectData(valueSchema, elem));
                    }
                    converted = result;
                    break;
                }
                case MAP: {
                    org.apache.kafka.connect.data.Schema keySchema = schema.keySchema();
                    org.apache.kafka.connect.data.Schema valueSchema = schema.valueSchema();
                    if (keySchema != null && keySchema.type() == Schema.Type.STRING && !keySchema.isOptional()) {
                        Map original = (Map)value;
                        HashMap<String, Object> result = new HashMap<String, Object>(original.size());
                        for (Map.Entry entry : original.entrySet()) {
                            result.put(((CharSequence)entry.getKey()).toString(), this.toConnectData(valueSchema, entry.getValue()));
                        }
                        converted = result;
                        break;
                    }
                    Collection original = (Collection)value;
                    HashMap<Object, Object> result = new HashMap<Object, Object>(original.size());
                    for (IndexedRecord entry : original) {
                        int avroKeyFieldIndex = entry.getSchema().getField(KEY_FIELD).pos();
                        int avroValueFieldIndex = entry.getSchema().getField(VALUE_FIELD).pos();
                        Object convertedKey = this.toConnectData(keySchema, entry.get(avroKeyFieldIndex));
                        Object convertedValue = this.toConnectData(valueSchema, entry.get(avroValueFieldIndex));
                        result.put(convertedKey, convertedValue);
                    }
                    converted = result;
                    break;
                }
                case STRUCT: {
                    if (schema.name() != null && schema.name().equals(AVRO_TYPE_UNION)) {
                        org.apache.kafka.connect.data.Schema valueRecordSchema = null;
                        if (value instanceof IndexedRecord) {
                            IndexedRecord valueRecord = (IndexedRecord)value;
                            valueRecordSchema = this.toConnectSchema(valueRecord.getSchema(), true, null, null);
                        }
                        for (Field field : schema.fields()) {
                            org.apache.kafka.connect.data.Schema fieldSchema = field.schema();
                            if (!AvroData.isInstanceOfAvroSchemaTypeForSimpleSchema(fieldSchema, value) && (valueRecordSchema == null || !valueRecordSchema.equals(fieldSchema))) continue;
                            converted = new Struct(schema).put(this.unionMemberFieldName(fieldSchema), this.toConnectData(fieldSchema, (Object)value));
                            break;
                        }
                        if (converted != null) break;
                        throw new DataException("Did not find matching union field for data: " + value.toString());
                    }
                    IndexedRecord original = (IndexedRecord)value;
                    Struct result = new Struct(schema);
                    for (Field field : schema.fields()) {
                        int avroFieldIndex = original.getSchema().getField(field.name()).pos();
                        Object convertedFieldValue = this.toConnectData(field.schema(), original.get(avroFieldIndex));
                        result.put(field, convertedFieldValue);
                    }
                    converted = result;
                    break;
                }
                default: {
                    throw new DataException("Unknown Connect schema type: " + schema.type());
                }
            }
            if (schema != null && schema.name() != null && (logicalConverter = TO_CONNECT_LOGICAL_CONVERTERS.get(schema.name())) != null) {
                converted = logicalConverter.convert(schema, converted);
            }
            return converted;
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type for " + schema.type() + ": " + value.getClass());
        }
    }

    public org.apache.kafka.connect.data.Schema toConnectSchema(Schema schema) {
        org.apache.kafka.connect.data.Schema cachedSchema = (org.apache.kafka.connect.data.Schema)this.toConnectSchemaCache.get((Object)schema);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        org.apache.kafka.connect.data.Schema resultSchema = this.toConnectSchema(schema, false, null, null);
        this.toConnectSchemaCache.put((Object)schema, (Object)resultSchema);
        return resultSchema;
    }

    private org.apache.kafka.connect.data.Schema toConnectSchema(Schema schema, boolean forceOptional, Object fieldDefaultVal, String docDefaultVal) {
        JsonNode parameters;
        JsonNode version;
        String docVal;
        SchemaBuilder builder;
        String type = schema.getProp(CONNECT_TYPE_PROP);
        String logicalType = schema.getProp(AVRO_LOGICAL_TYPE_PROP);
        switch (schema.getType()) {
            case BOOLEAN: {
                builder = SchemaBuilder.bool();
                break;
            }
            case BYTES: 
            case FIXED: {
                if (AVRO_LOGICAL_DECIMAL.equalsIgnoreCase(logicalType)) {
                    JsonNode scaleNode = schema.getJsonProp(AVRO_LOGICAL_DECIMAL_SCALE_PROP);
                    if (null == scaleNode || !(scaleNode instanceof NumericNode)) {
                        throw new DataException("scale must be specified and must be a number.");
                    }
                    NumericNode scale = (NumericNode)scaleNode;
                    builder = Decimal.builder((int)scale.asInt());
                    JsonNode precisionNode = schema.getJsonProp(AVRO_LOGICAL_DECIMAL_PRECISION_PROP);
                    if (null != precisionNode) {
                        if (!precisionNode.isNumber()) {
                            throw new DataException("precision property must be a JSON Integer. https://avro.apache.org/docs/1.7.7/spec.html#Decimal");
                        }
                        Integer precision = precisionNode.asInt();
                        builder.parameter(CONNECT_AVRO_DECIMAL_PRECISION_PROP, precision.toString());
                        break;
                    }
                    builder.parameter(CONNECT_AVRO_DECIMAL_PRECISION_PROP, CONNECT_AVRO_DECIMAL_PRECISION_DEFAULT.toString());
                    break;
                }
                builder = SchemaBuilder.bytes();
                break;
            }
            case DOUBLE: {
                builder = SchemaBuilder.float64();
                break;
            }
            case FLOAT: {
                builder = SchemaBuilder.float32();
                break;
            }
            case INT: {
                if (type == null && logicalType == null) {
                    builder = SchemaBuilder.int32();
                    break;
                }
                if (logicalType != null) {
                    if (AVRO_LOGICAL_DATE.equalsIgnoreCase(logicalType)) {
                        builder = Date.builder();
                        break;
                    }
                    if (AVRO_LOGICAL_TIME_MILLIS.equalsIgnoreCase(logicalType)) {
                        builder = Time.builder();
                        break;
                    }
                    builder = SchemaBuilder.int32();
                    break;
                }
                Schema.Type connectType = NON_AVRO_TYPES_BY_TYPE_CODE.get(type);
                if (connectType == null) {
                    throw new DataException("Connect type annotation for Avro int field is null");
                }
                builder = SchemaBuilder.type((Schema.Type)connectType);
                break;
            }
            case LONG: {
                if (AVRO_LOGICAL_TIMESTAMP_MILLIS.equalsIgnoreCase(logicalType)) {
                    builder = Timestamp.builder();
                    break;
                }
                builder = SchemaBuilder.int64();
                break;
            }
            case STRING: {
                builder = SchemaBuilder.string();
                break;
            }
            case ARRAY: {
                Schema elemSchema = schema.getElementType();
                if (elemSchema.getType().equals((Object)Schema.Type.RECORD) && NAMESPACE.equals(elemSchema.getNamespace()) && MAP_ENTRY_TYPE_NAME.equals(elemSchema.getName())) {
                    if (elemSchema.getFields().size() != 2 || elemSchema.getField(KEY_FIELD) == null || elemSchema.getField(VALUE_FIELD) == null) {
                        throw new DataException("Found map encoded as array of key-value pairs, but array elements do not match the expected format.");
                    }
                    builder = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)this.toConnectSchema(elemSchema.getField(KEY_FIELD).schema()), (org.apache.kafka.connect.data.Schema)this.toConnectSchema(elemSchema.getField(VALUE_FIELD).schema()));
                    break;
                }
                builder = SchemaBuilder.array((org.apache.kafka.connect.data.Schema)this.toConnectSchema(schema.getElementType()));
                break;
            }
            case MAP: {
                builder = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)this.toConnectSchema(schema.getValueType()));
                break;
            }
            case RECORD: {
                builder = SchemaBuilder.struct();
                for (Schema.Field field : schema.getFields()) {
                    org.apache.kafka.connect.data.Schema fieldSchema = this.toConnectSchema(field.schema(), false, field.defaultValue(), field.doc());
                    builder.field(field.name(), fieldSchema);
                }
                break;
            }
            case ENUM: {
                builder = SchemaBuilder.string();
                if (schema.getDoc() != null) {
                    builder.parameter(CONNECT_ENUM_DOC_PROP, schema.getDoc());
                }
                builder.parameter(AVRO_TYPE_ENUM, schema.getFullName());
                for (String enumSymbol : schema.getEnumSymbols()) {
                    builder.parameter("io.confluent.connect.avro.Enum." + enumSymbol, enumSymbol);
                }
                break;
            }
            case UNION: {
                if (schema.getTypes().size() == 2 && schema.getTypes().contains(NULL_AVRO_SCHEMA)) {
                    for (Schema memberSchema : schema.getTypes()) {
                        if (memberSchema.equals((Object)NULL_AVRO_SCHEMA)) continue;
                        return this.toConnectSchema(memberSchema, true, null, docDefaultVal);
                    }
                }
                builder = SchemaBuilder.struct().name(AVRO_TYPE_UNION);
                HashSet<String> fieldNames = new HashSet<String>();
                for (Schema memberSchema : schema.getTypes()) {
                    if (memberSchema.getType() == Schema.Type.NULL) {
                        builder.optional();
                        continue;
                    }
                    String fieldName = this.unionMemberFieldName(memberSchema);
                    if (fieldNames.contains(fieldName)) {
                        throw new DataException("Multiple union schemas map to the Connect union field name");
                    }
                    fieldNames.add(fieldName);
                    builder.field(fieldName, this.toConnectSchema(memberSchema, true, null, null));
                }
                break;
            }
            case NULL: {
                throw new DataException("Standalone null schemas are not supported by this converter");
            }
            default: {
                throw new DataException("Couldn't translate unsupported schema type " + schema.getType().getName() + ".");
            }
        }
        String string = docDefaultVal != null ? docDefaultVal : (docVal = schema.getDoc() != null ? schema.getDoc() : schema.getProp(CONNECT_DOC_PROP));
        if (docVal != null) {
            builder.doc(docVal);
        }
        if (schema.getDoc() != null) {
            builder.parameter(CONNECT_RECORD_DOC_PROP, schema.getDoc());
        }
        if ((version = schema.getJsonProp(CONNECT_VERSION_PROP)) == null) {
            version = schema.getJsonProp("schema.registry.schema.version");
        }
        if (version != null) {
            if (!version.isIntegralNumber()) {
                throw new DataException("Invalid Connect version found: " + version.toString());
            }
            int versionInt = version.asInt();
            if (builder.version() != null) {
                if (versionInt != builder.version()) {
                    throw new DataException("Mismatched versions: version already added to SchemaBuilder (" + builder.version() + ") differs from version in source schema (" + version.toString() + ")");
                }
            } else {
                builder.version(Integer.valueOf(versionInt));
            }
        }
        if ((parameters = schema.getJsonProp(CONNECT_PARAMETERS_PROP)) != null) {
            if (!parameters.isObject()) {
                throw new DataException("Expected JSON object for schema parameters but found: " + parameters);
            }
            Iterator paramIt = parameters.getFields();
            while (paramIt.hasNext()) {
                Map.Entry field = (Map.Entry)paramIt.next();
                JsonNode jsonValue = (JsonNode)field.getValue();
                if (!jsonValue.isTextual()) {
                    throw new DataException("Expected schema parameter values to be strings but found: " + jsonValue);
                }
                builder.parameter((String)field.getKey(), jsonValue.getTextValue());
            }
        }
        for (Map.Entry entry : schema.getProps().entrySet()) {
            if (!((String)entry.getKey()).startsWith(AVRO_PROP)) continue;
            builder.parameter((String)entry.getKey(), (String)entry.getValue());
        }
        if (fieldDefaultVal == null) {
            fieldDefaultVal = schema.getJsonProp(CONNECT_DEFAULT_VALUE_PROP);
        }
        if (fieldDefaultVal != null) {
            builder.defaultValue(this.defaultValueFromAvro((org.apache.kafka.connect.data.Schema)builder, schema, fieldDefaultVal));
        }
        JsonNode connectNameJson = schema.getJsonProp(CONNECT_NAME_PROP);
        String name = null;
        if (connectNameJson != null) {
            if (!connectNameJson.isTextual()) {
                throw new DataException("Invalid schema name: " + connectNameJson.toString());
            }
            name = connectNameJson.asText();
        } else if (schema.getType() == Schema.Type.RECORD || schema.getType() == Schema.Type.ENUM) {
            name = schema.getFullName();
        }
        if (name != null && !name.equals(DEFAULT_SCHEMA_FULL_NAME)) {
            if (builder.name() != null) {
                if (!name.equals(builder.name())) {
                    throw new DataException("Mismatched names: name already added to SchemaBuilder (" + builder.name() + ") differs from name in source schema (" + name + ")");
                }
            } else {
                builder.name(name);
            }
        }
        if (forceOptional) {
            builder.optional();
        }
        return builder.build();
    }

    private Object defaultValueFromAvro(org.apache.kafka.connect.data.Schema schema, Schema avroSchema, Object value) {
        if (!(value instanceof JsonNode)) {
            return this.toConnectData(schema, value);
        }
        JsonNode jsonValue = (JsonNode)value;
        switch (avroSchema.getType()) {
            case INT: {
                if (schema.type() == Schema.Type.INT8) {
                    return (byte)jsonValue.getIntValue();
                }
                if (schema.type() == Schema.Type.INT16) {
                    return (short)jsonValue.getIntValue();
                }
                if (schema.type() != Schema.Type.INT32) break;
                return jsonValue.getIntValue();
            }
            case LONG: {
                return jsonValue.getLongValue();
            }
            case FLOAT: {
                return Float.valueOf((float)jsonValue.getDoubleValue());
            }
            case DOUBLE: {
                return jsonValue.getDoubleValue();
            }
            case BOOLEAN: {
                return jsonValue.asBoolean();
            }
            case NULL: {
                return null;
            }
            case STRING: 
            case ENUM: {
                return jsonValue.asText();
            }
            case BYTES: 
            case FIXED: {
                try {
                    return jsonValue.getBinaryValue();
                }
                catch (IOException e) {
                    throw new DataException("Invalid binary data in default value");
                }
            }
            case ARRAY: {
                if (!jsonValue.isArray()) {
                    throw new DataException("Invalid JSON for array default value: " + jsonValue.toString());
                }
                ArrayList<Object> result = new ArrayList<Object>(jsonValue.size());
                for (JsonNode elem : jsonValue) {
                    result.add(this.defaultValueFromAvro(schema, avroSchema.getElementType(), elem));
                }
                return result;
            }
            case MAP: {
                if (!jsonValue.isObject()) {
                    throw new DataException("Invalid JSON for map default value: " + jsonValue.toString());
                }
                HashMap result = new HashMap(jsonValue.size());
                Iterator fieldIt = jsonValue.getFields();
                while (fieldIt.hasNext()) {
                    Map.Entry field = (Map.Entry)fieldIt.next();
                    Object converted = this.defaultValueFromAvro(schema, avroSchema.getElementType(), field.getValue());
                    result.put(field.getKey(), converted);
                }
                return result;
            }
            case RECORD: {
                if (!jsonValue.isObject()) {
                    throw new DataException("Invalid JSON for record default value: " + jsonValue.toString());
                }
                Struct result = new Struct(schema);
                for (Schema.Field avroField : avroSchema.getFields()) {
                    Field field = schema.field(avroField.name());
                    JsonNode fieldJson = ((JsonNode)value).get(field.name());
                    Object converted = this.defaultValueFromAvro(field.schema(), avroField.schema(), fieldJson);
                    result.put(avroField.name(), converted);
                }
                return result;
            }
            case UNION: {
                Schema memberAvroSchema = (Schema)avroSchema.getTypes().get(0);
                if (memberAvroSchema.getType() == Schema.Type.NULL) {
                    return null;
                }
                return this.defaultValueFromAvro(schema.field(this.unionMemberFieldName(memberAvroSchema)).schema(), memberAvroSchema, value);
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private String unionMemberFieldName(Schema schema) {
        if (schema.getType() == Schema.Type.RECORD || schema.getType() == Schema.Type.ENUM) {
            if (this.enhancedSchemaSupport) {
                return schema.getFullName();
            }
            return AvroData.splitName(schema.getName())[1];
        }
        return schema.getType().getName();
    }

    private String unionMemberFieldName(org.apache.kafka.connect.data.Schema schema) {
        if (schema.type() == Schema.Type.STRUCT || AvroData.isEnumSchema(schema)) {
            if (this.enhancedSchemaSupport) {
                return schema.name();
            }
            return AvroData.splitName(schema.name())[1];
        }
        return CONNECT_TYPES_TO_AVRO_TYPES.get(schema.type()).getName();
    }

    private static boolean isEnumSchema(org.apache.kafka.connect.data.Schema schema) {
        return schema.type() == Schema.Type.STRING && schema.name() != null && schema.name().equals(AVRO_TYPE_ENUM);
    }

    private static boolean isInstanceOfAvroSchemaTypeForSimpleSchema(org.apache.kafka.connect.data.Schema fieldSchema, Object value) {
        List<Class> classes = SIMPLE_AVRO_SCHEMA_TYPES.get(fieldSchema.type());
        if (classes == null) {
            return false;
        }
        for (Class type : classes) {
            if (!type.isInstance(value)) continue;
            return true;
        }
        return false;
    }

    private static String[] splitName(String fullName) {
        String[] result = new String[2];
        int indexLastDot = fullName.lastIndexOf(46);
        if (indexLastDot >= 0) {
            result[0] = fullName.substring(0, indexLastDot);
            result[1] = fullName.substring(indexLastDot + 1);
        } else {
            result[0] = null;
            result[1] = fullName;
        }
        return result;
    }

    public static org.apache.kafka.connect.data.Schema nonOptional(org.apache.kafka.connect.data.Schema schema) {
        return new ConnectSchema(schema.type(), false, schema.defaultValue(), schema.name(), schema.version(), schema.doc(), schema.parameters(), AvroData.fields(schema), AvroData.keySchema(schema), AvroData.valueSchema(schema));
    }

    public static List<Field> fields(org.apache.kafka.connect.data.Schema schema) {
        Schema.Type type = schema.type();
        if (Schema.Type.STRUCT.equals((Object)type)) {
            return schema.fields();
        }
        return null;
    }

    public static org.apache.kafka.connect.data.Schema keySchema(org.apache.kafka.connect.data.Schema schema) {
        Schema.Type type = schema.type();
        if (Schema.Type.MAP.equals((Object)type)) {
            return schema.keySchema();
        }
        return null;
    }

    public static org.apache.kafka.connect.data.Schema valueSchema(org.apache.kafka.connect.data.Schema schema) {
        Schema.Type type = schema.type();
        if (Schema.Type.MAP.equals((Object)type) || Schema.Type.ARRAY.equals((Object)type)) {
            return schema.valueSchema();
        }
        return null;
    }

    static {
        NON_AVRO_TYPES_BY_TYPE_CODE.put(CONNECT_TYPE_INT8, Schema.Type.INT8);
        NON_AVRO_TYPES_BY_TYPE_CODE.put(CONNECT_TYPE_INT16, Schema.Type.INT16);
        SIMPLE_AVRO_SCHEMA_TYPES = new HashMap<Schema.Type, List<Class>>();
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.INT32, Arrays.asList(Integer.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.INT64, Arrays.asList(Long.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.FLOAT32, Arrays.asList(Float.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.FLOAT64, Arrays.asList(Double.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.BOOLEAN, Arrays.asList(Boolean.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.STRING, Arrays.asList(CharSequence.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.BYTES, Arrays.asList(ByteBuffer.class, byte[].class, GenericFixed.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.ARRAY, Arrays.asList(Collection.class));
        SIMPLE_AVRO_SCHEMA_TYPES.put(Schema.Type.MAP, Arrays.asList(Map.class));
        CONNECT_TYPES_TO_AVRO_TYPES = new HashMap<Schema.Type, Schema.Type>();
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.INT32, Schema.Type.INT);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.INT64, Schema.Type.LONG);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.FLOAT32, Schema.Type.FLOAT);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.FLOAT64, Schema.Type.DOUBLE);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.BOOLEAN, Schema.Type.BOOLEAN);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.STRING, Schema.Type.STRING);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.BYTES, Schema.Type.BYTES);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.ARRAY, Schema.Type.ARRAY);
        CONNECT_TYPES_TO_AVRO_TYPES.put(Schema.Type.MAP, Schema.Type.MAP);
        NULL_AVRO_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
        ANYTHING_SCHEMA = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.RecordBuilder)((SchemaBuilder.FieldAssembler)((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)AVRO_TYPE_ANYTHING).namespace(NAMESPACE)).fields().optionalBoolean(ANYTHING_SCHEMA_BOOLEAN_FIELD).optionalBytes(ANYTHING_SCHEMA_BYTES_FIELD).optionalDouble(ANYTHING_SCHEMA_DOUBLE_FIELD).optionalFloat(ANYTHING_SCHEMA_FLOAT_FIELD).optionalInt(ANYTHING_SCHEMA_INT_FIELD).optionalLong(ANYTHING_SCHEMA_LONG_FIELD).optionalString(ANYTHING_SCHEMA_STRING_FIELD).name(ANYTHING_SCHEMA_ARRAY_FIELD).type().optional().array().items().type(AVRO_TYPE_ANYTHING)).name(ANYTHING_SCHEMA_MAP_FIELD).type().optional().array().items().record(MAP_ENTRY_TYPE_NAME).namespace(NAMESPACE)).fields().name(KEY_FIELD).type(AVRO_TYPE_ANYTHING).noDefault().name(VALUE_FIELD).type(AVRO_TYPE_ANYTHING).noDefault().endRecord()).endRecord();
        ANYTHING_SCHEMA_MAP_ELEMENT = ((Schema)ANYTHING_SCHEMA.getField(ANYTHING_SCHEMA_MAP_FIELD).schema().getTypes().get(1)).getElementType();
        TO_CONNECT_LOGICAL_CONVERTERS = new HashMap();
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Decimal", new LogicalTypeConverter(){

            @Override
            public Object convert(org.apache.kafka.connect.data.Schema schema, Object value) {
                if (value instanceof byte[]) {
                    return Decimal.toLogical((org.apache.kafka.connect.data.Schema)schema, (byte[])((byte[])value));
                }
                if (value instanceof ByteBuffer) {
                    return Decimal.toLogical((org.apache.kafka.connect.data.Schema)schema, (byte[])((ByteBuffer)value).array());
                }
                throw new DataException("Invalid type for Decimal, underlying representation should be bytes but was " + value.getClass());
            }
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Date", new LogicalTypeConverter(){

            @Override
            public Object convert(org.apache.kafka.connect.data.Schema schema, Object value) {
                if (!(value instanceof Integer)) {
                    throw new DataException("Invalid type for Date, underlying representation should be int32 but was " + value.getClass());
                }
                return Date.toLogical((org.apache.kafka.connect.data.Schema)schema, (int)((Integer)value));
            }
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Time", new LogicalTypeConverter(){

            @Override
            public Object convert(org.apache.kafka.connect.data.Schema schema, Object value) {
                if (!(value instanceof Integer)) {
                    throw new DataException("Invalid type for Time, underlying representation should be int32 but was " + value.getClass());
                }
                return Time.toLogical((org.apache.kafka.connect.data.Schema)schema, (int)((Integer)value));
            }
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Timestamp", new LogicalTypeConverter(){

            @Override
            public Object convert(org.apache.kafka.connect.data.Schema schema, Object value) {
                if (!(value instanceof Long)) {
                    throw new DataException("Invalid type for Timestamp, underlying representation should be int64 but was " + value.getClass());
                }
                return Timestamp.toLogical((org.apache.kafka.connect.data.Schema)schema, (long)((Long)value));
            }
        });
        CONNECT_AVRO_DECIMAL_PRECISION_DEFAULT = 64;
        TO_AVRO_LOGICAL_CONVERTERS = new HashMap();
        TO_AVRO_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Decimal", new LogicalTypeConverter(){

            @Override
            public Object convert(org.apache.kafka.connect.data.Schema schema, Object value) {
                if (!(value instanceof BigDecimal)) {
                    throw new DataException("Invalid type for Decimal, expected BigDecimal but was " + value.getClass());
                }
                return Decimal.fromLogical((org.apache.kafka.connect.data.Schema)schema, (BigDecimal)((BigDecimal)value));
            }
        });
        TO_AVRO_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Date", new LogicalTypeConverter(){

            @Override
            public Object convert(org.apache.kafka.connect.data.Schema schema, Object value) {
                if (!(value instanceof java.util.Date)) {
                    throw new DataException("Invalid type for Date, expected Date but was " + value.getClass());
                }
                return Date.fromLogical((org.apache.kafka.connect.data.Schema)schema, (java.util.Date)((java.util.Date)value));
            }
        });
        TO_AVRO_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Time", new LogicalTypeConverter(){

            @Override
            public Object convert(org.apache.kafka.connect.data.Schema schema, Object value) {
                if (!(value instanceof java.util.Date)) {
                    throw new DataException("Invalid type for Time, expected Date but was " + value.getClass());
                }
                return Time.fromLogical((org.apache.kafka.connect.data.Schema)schema, (java.util.Date)((java.util.Date)value));
            }
        });
        TO_AVRO_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Timestamp", new LogicalTypeConverter(){

            @Override
            public Object convert(org.apache.kafka.connect.data.Schema schema, Object value) {
                if (!(value instanceof java.util.Date)) {
                    throw new DataException("Invalid type for Timestamp, expected Date but was " + value.getClass());
                }
                return Timestamp.fromLogical((org.apache.kafka.connect.data.Schema)schema, (java.util.Date)((java.util.Date)value));
            }
        });
    }

    private static interface LogicalTypeConverter {
        public Object convert(org.apache.kafka.connect.data.Schema var1, Object var2);
    }
}

