/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.db.model.Partition;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.metrics.event.PartitionOffsetLagMetricEvent;
import io.debezium.connector.spanner.task.PartitionOffsetProvider;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionFactory.class);
    private final PartitionOffsetProvider partitionOffsetProvider;
    private final MetricsEventPublisher metricsEventPublisher;

    public PartitionFactory(PartitionOffsetProvider partitionOffsetProvider, MetricsEventPublisher metricsEventPublisher) {
        this.partitionOffsetProvider = partitionOffsetProvider;
        this.metricsEventPublisher = metricsEventPublisher;
    }

    public Partition initPartition(Timestamp startTime, Timestamp endTime) {
        Partition partition = Partition.builder().token("Parent0").parentTokens(Set.of()).startTimestamp(startTime).endTimestamp(endTime).build();
        this.metricsEventPublisher.publishMetricEvent(PartitionOffsetLagMetricEvent.from(partition.getToken(), startTime));
        return partition;
    }

    public Partition getPartition(PartitionState partitionState) {
        return Partition.builder().token(partitionState.getToken()).startTimestamp(this.getOffset(partitionState)).endTimestamp(partitionState.getEndTimestamp()).parentTokens(partitionState.getParents()).build();
    }

    private Timestamp getOffset(PartitionState partitionState) {
        Timestamp startTime;
        Timestamp offset = this.partitionOffsetProvider.getOffset(partitionState);
        if (offset != null) {
            if (offset.toSqlTimestamp().before(partitionState.getStartTimestamp().toSqlTimestamp())) {
                Map<String, String> offsetMap = this.partitionOffsetProvider.getOffsetMap(partitionState);
                LOGGER.warn("Incorrect offset, start time will be taken for partition {}, offsetMap {}", (Object)partitionState.getToken(), offsetMap);
                startTime = partitionState.getStartTimestamp();
            } else {
                LOGGER.info("Found previous offset {}", Map.of(partitionState.getToken(), offset.toString()));
                startTime = offset;
            }
        } else {
            LOGGER.info("Previous offset not found, start time will be taken {}", Map.of(partitionState.getToken(), partitionState.getStartTimestamp()));
            startTime = partitionState.getStartTimestamp();
        }
        this.metricsEventPublisher.publishMetricEvent(PartitionOffsetLagMetricEvent.from(partitionState.getToken(), startTime));
        return startTime;
    }
}

