/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.db.model.Mod;
import io.debezium.connector.spanner.schema.KafkaSpannerTableSchema;
import io.debezium.data.Envelope;
import java.util.function.Function;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class KafkaSpannerTableSchemaTest {
    KafkaSpannerTableSchemaTest() {
    }

    @Test
    void testGetKeyStructFromModIsNull() {
        TableId id = TableId.getTableId((String)"Table Name");
        ConnectSchema keySchema = new ConnectSchema(Schema.Type.INT8);
        Function keyGenerator = (Function)Mockito.mock(Function.class);
        Envelope envelopeSchema = new Envelope((Schema)new ConnectSchema(Schema.Type.INT8));
        Assertions.assertNull((Object)new KafkaSpannerTableSchema(id, (Schema)keySchema, keyGenerator, envelopeSchema, (Schema)new ConnectSchema(Schema.Type.INT8), (Function)Mockito.mock(Function.class), (Function)Mockito.mock(Function.class)).getKeyStructFromMod(null));
    }

    @Test
    void testGetKeyStructFromMod() {
        Function function = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)((Struct)function.apply((Mod)Mockito.any()))).thenReturn(null);
        TableId id = TableId.getTableId((String)"Table Name");
        ConnectSchema keySchema = new ConnectSchema(Schema.Type.INT8);
        Envelope envelopeSchema = new Envelope((Schema)new ConnectSchema(Schema.Type.INT8));
        KafkaSpannerTableSchema kafkaSpannerTableSchema = new KafkaSpannerTableSchema(id, (Schema)keySchema, function, envelopeSchema, (Schema)new ConnectSchema(Schema.Type.INT8), (Function)Mockito.mock(Function.class), (Function)Mockito.mock(Function.class));
        MissingNode keysJsonNode = MissingNode.getInstance();
        MissingNode oldValuesJsonNode = MissingNode.getInstance();
        Assertions.assertNull((Object)kafkaSpannerTableSchema.getKeyStructFromMod(new Mod(0, (JsonNode)keysJsonNode, (JsonNode)oldValuesJsonNode, (JsonNode)MissingNode.getInstance())));
        ((Function)Mockito.verify((Object)function)).apply((Mod)Mockito.any());
    }

    @Test
    void testGetOldValueStructFromModIsNull() {
        TableId id = TableId.getTableId((String)"Table Name");
        ConnectSchema keySchema = new ConnectSchema(Schema.Type.INT8);
        Function keyGenerator = (Function)Mockito.mock(Function.class);
        Envelope envelopeSchema = new Envelope((Schema)new ConnectSchema(Schema.Type.INT8));
        Assertions.assertNull((Object)new KafkaSpannerTableSchema(id, (Schema)keySchema, keyGenerator, envelopeSchema, (Schema)new ConnectSchema(Schema.Type.INT8), (Function)Mockito.mock(Function.class), (Function)Mockito.mock(Function.class)).getOldValueStructFromMod(null));
    }

    @Test
    void testGetOldValueStructFromMod() {
        Function function = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)((Struct)function.apply((Mod)Mockito.any()))).thenReturn(null);
        TableId id = TableId.getTableId((String)"Table Name");
        ConnectSchema keySchema = new ConnectSchema(Schema.Type.INT8);
        Function keyGenerator = (Function)Mockito.mock(Function.class);
        Envelope envelopeSchema = new Envelope((Schema)new ConnectSchema(Schema.Type.INT8));
        KafkaSpannerTableSchema kafkaSpannerTableSchema = new KafkaSpannerTableSchema(id, (Schema)keySchema, keyGenerator, envelopeSchema, (Schema)new ConnectSchema(Schema.Type.INT8), function, (Function)Mockito.mock(Function.class));
        MissingNode keysJsonNode = MissingNode.getInstance();
        MissingNode oldValuesJsonNode = MissingNode.getInstance();
        Assertions.assertNull((Object)kafkaSpannerTableSchema.getOldValueStructFromMod(new Mod(0, (JsonNode)keysJsonNode, (JsonNode)oldValuesJsonNode, (JsonNode)MissingNode.getInstance())));
        ((Function)Mockito.verify((Object)function)).apply((Mod)Mockito.any());
    }

    @Test
    void testGetNewValueStructFromModIsNull() {
        TableId id = TableId.getTableId((String)"Table Name");
        ConnectSchema keySchema = new ConnectSchema(Schema.Type.INT8);
        Function keyGenerator = (Function)Mockito.mock(Function.class);
        Envelope envelopeSchema = new Envelope((Schema)new ConnectSchema(Schema.Type.INT8));
        Assertions.assertNull((Object)new KafkaSpannerTableSchema(id, (Schema)keySchema, keyGenerator, envelopeSchema, (Schema)new ConnectSchema(Schema.Type.INT8), (Function)Mockito.mock(Function.class), (Function)Mockito.mock(Function.class)).getNewValueStructFromMod(null));
    }

    @Test
    void testGetNewValueStructFromMod() {
        Function function = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)((Struct)function.apply((Mod)Mockito.any()))).thenReturn(null);
        TableId id = TableId.getTableId((String)"Table Name");
        ConnectSchema keySchema = new ConnectSchema(Schema.Type.INT8);
        Function keyGenerator = (Function)Mockito.mock(Function.class);
        Envelope envelopeSchema = new Envelope((Schema)new ConnectSchema(Schema.Type.INT8));
        KafkaSpannerTableSchema kafkaSpannerTableSchema = new KafkaSpannerTableSchema(id, (Schema)keySchema, keyGenerator, envelopeSchema, (Schema)new ConnectSchema(Schema.Type.INT8), (Function)Mockito.mock(Function.class), function);
        MissingNode keysJsonNode = MissingNode.getInstance();
        MissingNode oldValuesJsonNode = MissingNode.getInstance();
        Assertions.assertNull((Object)kafkaSpannerTableSchema.getNewValueStructFromMod(new Mod(0, (JsonNode)keysJsonNode, (JsonNode)oldValuesJsonNode, (JsonNode)MissingNode.getInstance())));
        ((Function)Mockito.verify((Object)function)).apply((Mod)Mockito.any());
    }
}

