/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics.latency;

import io.debezium.connector.spanner.metrics.latency.LatencyCalculator;
import java.util.HashMap;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class LatencyCalculatorTest {
    LatencyCalculatorTest() {
    }

    @Test
    void testGetTotalLatencyNoSource() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertNull((Object)LatencyCalculator.getTotalLatency((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testGetReadToEmitLatencyNoSource() {
        Assertions.assertNull((Object)LatencyCalculator.getReadToEmitLatency((SourceRecord)new SourceRecord(new HashMap(), new HashMap(), "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testGetSpannerLatencyNoSource() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertNull((Object)LatencyCalculator.getSpannerLatency((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testGetCommitToEmitLatencyNoSource() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertNull((Object)LatencyCalculator.getCommitToEmitLatency((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testGetCommitToPublishLatencyNoSource() {
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(new HashMap(), new HashMap(), "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        Mockito.when((Object)header.value()).thenReturn(null);
        Mockito.when((Object)headers.lastWithName(ArgumentMatchers.anyString())).thenReturn((Object)header);
        Mockito.when((Object)sourceRecord.headers()).thenReturn((Object)headers);
        Long commitToPublishLatency = LatencyCalculator.getCommitToPublishLatency((SourceRecord)sourceRecord);
        Assertions.assertNull((Object)commitToPublishLatency);
    }

    @Test
    void testGetEmitToPublishLatencyNoSource() {
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(new HashMap(), new HashMap(), "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        Mockito.when((Object)header.value()).thenReturn(null);
        Mockito.when((Object)headers.lastWithName(ArgumentMatchers.anyString())).thenReturn((Object)header);
        Mockito.when((Object)sourceRecord.headers()).thenReturn((Object)headers);
        Long emitToPublishLatency = LatencyCalculator.getEmitToPublishLatency((SourceRecord)sourceRecord);
        Assertions.assertNull((Object)emitToPublishLatency);
    }

    @Test
    void testGetOwnConnectorLatencyNoSource() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertNull((Object)LatencyCalculator.getOwnConnectorLatency((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testGetLowWatermarkLagNoSource() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertNull((Object)LatencyCalculator.getLowWatermarkLag((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testGetTotalLatency() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Schema schema = (Schema)Mockito.mock(Schema.class);
        Field field = (Field)Mockito.mock(Field.class);
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        ((SourceRecord)Mockito.doReturn((Object)struct).when((Object)sourceRecord)).value();
        ((SourceRecord)Mockito.doReturn((Object)headers).when((Object)sourceRecord)).headers();
        ((Headers)Mockito.doReturn((Object)header).when((Object)headers)).lastWithName(ArgumentMatchers.anyString());
        ((Header)Mockito.doReturn((Object)1L).when((Object)header)).value();
        ((Struct)Mockito.doReturn((Object)schema).when((Object)struct)).schema();
        ((Schema)Mockito.doReturn((Object)field).when((Object)schema)).field(ArgumentMatchers.anyString());
        ((Struct)Mockito.doReturn((Object)struct).when((Object)struct)).getStruct(ArgumentMatchers.anyString());
        Assertions.assertEquals((long)1L, (Long)LatencyCalculator.getTotalLatency((SourceRecord)sourceRecord));
    }

    @Test
    void testGetReadToEmitLatency() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Schema schema = (Schema)Mockito.mock(Schema.class);
        Field field = (Field)Mockito.mock(Field.class);
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        ((SourceRecord)Mockito.doReturn((Object)struct).when((Object)sourceRecord)).value();
        ((SourceRecord)Mockito.doReturn((Object)headers).when((Object)sourceRecord)).headers();
        ((Headers)Mockito.doReturn((Object)header).when((Object)headers)).lastWithName(ArgumentMatchers.anyString());
        ((Header)Mockito.doReturn((Object)1L).when((Object)header)).value();
        ((Struct)Mockito.doReturn((Object)schema).when((Object)struct)).schema();
        ((Schema)Mockito.doReturn((Object)field).when((Object)schema)).field(ArgumentMatchers.anyString());
        ((Struct)Mockito.doReturn((Object)struct).when((Object)struct)).getStruct(ArgumentMatchers.anyString());
        Assertions.assertEquals((long)1L, (Long)LatencyCalculator.getReadToEmitLatency((SourceRecord)sourceRecord));
    }

    @Test
    void testGetSpannerLatency() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Schema schema = (Schema)Mockito.mock(Schema.class);
        Field field = (Field)Mockito.mock(Field.class);
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        ((SourceRecord)Mockito.doReturn((Object)struct).when((Object)sourceRecord)).value();
        ((SourceRecord)Mockito.doReturn((Object)headers).when((Object)sourceRecord)).headers();
        ((Headers)Mockito.doReturn((Object)header).when((Object)headers)).lastWithName(ArgumentMatchers.anyString());
        ((Header)Mockito.doReturn((Object)1L).when((Object)header)).value();
        ((Struct)Mockito.doReturn((Object)schema).when((Object)struct)).schema();
        ((Schema)Mockito.doReturn((Object)field).when((Object)schema)).field(ArgumentMatchers.anyString());
        ((Struct)Mockito.doReturn((Object)struct).when((Object)struct)).getStruct(ArgumentMatchers.anyString());
        Assertions.assertEquals((long)0L, (Long)LatencyCalculator.getSpannerLatency((SourceRecord)sourceRecord));
    }

    @Test
    void testGetCommitToEmitLatency() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Schema schema = (Schema)Mockito.mock(Schema.class);
        Field field = (Field)Mockito.mock(Field.class);
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        ((SourceRecord)Mockito.doReturn((Object)struct).when((Object)sourceRecord)).value();
        ((SourceRecord)Mockito.doReturn((Object)headers).when((Object)sourceRecord)).headers();
        ((Headers)Mockito.doReturn((Object)header).when((Object)headers)).lastWithName(ArgumentMatchers.anyString());
        ((Header)Mockito.doReturn((Object)1L).when((Object)header)).value();
        ((Struct)Mockito.doReturn((Object)schema).when((Object)struct)).schema();
        ((Schema)Mockito.doReturn((Object)field).when((Object)schema)).field(ArgumentMatchers.anyString());
        ((Struct)Mockito.doReturn((Object)struct).when((Object)struct)).getStruct(ArgumentMatchers.anyString());
        Assertions.assertEquals((long)1L, (Long)LatencyCalculator.getCommitToEmitLatency((SourceRecord)sourceRecord));
    }

    @Test
    void testGetCommitToPublishLatency() {
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(new HashMap(), new HashMap(), "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        Mockito.when((Object)header.value()).thenReturn(null);
        Mockito.when((Object)headers.lastWithName(ArgumentMatchers.anyString())).thenReturn((Object)header);
        Mockito.when((Object)sourceRecord.headers()).thenReturn((Object)headers);
        Long commitToPublishLatency = LatencyCalculator.getCommitToPublishLatency((SourceRecord)sourceRecord);
        Assertions.assertNull((Object)commitToPublishLatency);
    }

    @Test
    void testGetEmitToPublishLatency() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Schema schema = (Schema)Mockito.mock(Schema.class);
        Field field = (Field)Mockito.mock(Field.class);
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        ((SourceRecord)Mockito.doReturn((Object)struct).when((Object)sourceRecord)).value();
        ((SourceRecord)Mockito.doReturn((Object)headers).when((Object)sourceRecord)).headers();
        ((Headers)Mockito.doReturn((Object)header).when((Object)headers)).lastWithName(ArgumentMatchers.anyString());
        ((Header)Mockito.doReturn((Object)1L).when((Object)header)).value();
        ((Struct)Mockito.doReturn((Object)schema).when((Object)struct)).schema();
        ((Schema)Mockito.doReturn((Object)field).when((Object)schema)).field(ArgumentMatchers.anyString());
        ((Struct)Mockito.doReturn((Object)struct).when((Object)struct)).getStruct(ArgumentMatchers.anyString());
        Assertions.assertEquals((long)0L, (Long)LatencyCalculator.getEmitToPublishLatency((SourceRecord)sourceRecord));
    }

    @Test
    void testGetOwnConnectorLatency() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Schema schema = (Schema)Mockito.mock(Schema.class);
        Field field = (Field)Mockito.mock(Field.class);
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        ((SourceRecord)Mockito.doReturn((Object)struct).when((Object)sourceRecord)).value();
        ((SourceRecord)Mockito.doReturn((Object)headers).when((Object)sourceRecord)).headers();
        ((Headers)Mockito.doReturn((Object)header).when((Object)headers)).lastWithName(ArgumentMatchers.anyString());
        ((Header)Mockito.doReturn((Object)1L).when((Object)header)).value();
        ((Struct)Mockito.doReturn((Object)schema).when((Object)struct)).schema();
        ((Schema)Mockito.doReturn((Object)field).when((Object)schema)).field(ArgumentMatchers.anyString());
        ((Struct)Mockito.doReturn((Object)struct).when((Object)struct)).getStruct(ArgumentMatchers.anyString());
        Assertions.assertEquals((long)1L, (Long)LatencyCalculator.getOwnConnectorLatency((SourceRecord)sourceRecord));
    }

    @Test
    void testGetLowWatermarkLag() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Schema schema = (Schema)Mockito.mock(Schema.class);
        Field field = (Field)Mockito.mock(Field.class);
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        ((SourceRecord)Mockito.doReturn((Object)struct).when((Object)sourceRecord)).value();
        ((SourceRecord)Mockito.doReturn((Object)headers).when((Object)sourceRecord)).headers();
        ((Headers)Mockito.doReturn((Object)header).when((Object)headers)).lastWithName(ArgumentMatchers.anyString());
        ((Header)Mockito.doReturn((Object)1L).when((Object)header)).value();
        ((Struct)Mockito.doReturn((Object)schema).when((Object)struct)).schema();
        ((Schema)Mockito.doReturn((Object)field).when((Object)schema)).field(ArgumentMatchers.anyString());
        ((Struct)Mockito.doReturn((Object)struct).when((Object)struct)).getStruct(ArgumentMatchers.anyString());
        Assertions.assertNotNull((Object)LatencyCalculator.getLowWatermarkLag((SourceRecord)sourceRecord));
    }
}

