/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc.multiendpoint;

import com.google.cloud.grpc.multiendpoint.Endpoint;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.time.Duration;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@CheckReturnValue
public final class MultiEndpoint {
    @GuardedBy(value="this")
    private final Map<String, Endpoint> endpointsMap = new HashMap<String, Endpoint>();
    @GuardedBy(value="this")
    private String currentId;
    private final Duration recoveryTimeout;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);

    private MultiEndpoint(Builder builder) {
        this.recoveryTimeout = builder.recoveryTimeout;
        this.setEndpoints(builder.endpoints);
    }

    public String getCurrentId() {
        return this.currentId;
    }

    private synchronized void setEndpointStateInternal(String endpointId, Endpoint.EndpointState state) {
        Endpoint endpoint = this.endpointsMap.get(endpointId);
        if (endpoint != null) {
            endpoint.setState(state);
            this.maybeUpdateCurrentEndpoint();
        }
    }

    private boolean isRecoveryEnabled() {
        return !this.recoveryTimeout.isNegative() && !this.recoveryTimeout.isZero();
    }

    public synchronized void setEndpointAvailable(String endpointId, boolean available) {
        this.setEndpointState(endpointId, available ? Endpoint.EndpointState.AVAILABLE : Endpoint.EndpointState.UNAVAILABLE);
    }

    private synchronized void setEndpointState(String endpointId, Endpoint.EndpointState state) {
        Preconditions.checkNotNull((Object)((Object)state));
        Endpoint endpoint = this.endpointsMap.get(endpointId);
        if (endpoint == null) {
            return;
        }
        if (Endpoint.EndpointState.UNAVAILABLE.equals((Object)state) && this.isRecoveryEnabled()) {
            endpoint.setState(Endpoint.EndpointState.RECOVERING);
            ScheduledFuture<?> future = this.executor.schedule(() -> this.setEndpointStateInternal(endpointId, Endpoint.EndpointState.UNAVAILABLE), this.recoveryTimeout.toMillis(), TimeUnit.MILLISECONDS);
            endpoint.setChangeStateFuture(future);
            return;
        }
        endpoint.resetStateChangeFuture();
        endpoint.setState(state);
        this.maybeUpdateCurrentEndpoint();
    }

    public synchronized void setEndpoints(List<String> endpoints) {
        Preconditions.checkNotNull(endpoints);
        Preconditions.checkArgument((!endpoints.isEmpty() ? 1 : 0) != 0, (Object)"Endpoints list must not be empty.");
        this.endpointsMap.keySet().retainAll(endpoints);
        int priority = 0;
        for (String endpointId : endpoints) {
            Endpoint existingEndpoint = this.endpointsMap.get(endpointId);
            if (existingEndpoint != null) {
                existingEndpoint.setPriority(priority++);
                continue;
            }
            Endpoint.EndpointState newState = this.isRecoveryEnabled() ? Endpoint.EndpointState.RECOVERING : Endpoint.EndpointState.UNAVAILABLE;
            Endpoint newEndpoint = new Endpoint(endpointId, newState, priority++);
            if (this.isRecoveryEnabled()) {
                ScheduledFuture<?> future = this.executor.schedule(() -> this.setEndpointStateInternal(endpointId, Endpoint.EndpointState.UNAVAILABLE), this.recoveryTimeout.toMillis(), TimeUnit.MILLISECONDS);
                newEndpoint.setChangeStateFuture(future);
            }
            this.endpointsMap.put(endpointId, newEndpoint);
        }
        this.maybeUpdateCurrentEndpoint();
    }

    private synchronized void maybeUpdateCurrentEndpoint() {
        Optional<Endpoint> topEndpoint = this.endpointsMap.values().stream().filter(c -> c.getState().equals((Object)Endpoint.EndpointState.AVAILABLE)).min(Comparator.comparingInt(Endpoint::getPriority));
        Endpoint current = this.endpointsMap.get(this.currentId);
        if (current != null && current.getState().equals((Object)Endpoint.EndpointState.RECOVERING) && (!topEndpoint.isPresent() || topEndpoint.get().getPriority() >= current.getPriority())) {
            return;
        }
        if (!topEndpoint.isPresent() && current == null) {
            topEndpoint = this.endpointsMap.values().stream().min(Comparator.comparingInt(Endpoint::getPriority));
        }
        topEndpoint.ifPresent(endpoint -> {
            this.currentId = endpoint.getId();
        });
    }

    public static final class Builder {
        private final List<String> endpoints;
        private Duration recoveryTimeout = Duration.ZERO;

        public Builder(List<String> endpoints) {
            Preconditions.checkNotNull(endpoints);
            Preconditions.checkArgument((!endpoints.isEmpty() ? 1 : 0) != 0, (Object)"Endpoints list must not be empty.");
            this.endpoints = endpoints;
        }

        public Builder withRecoveryTimeout(Duration timeout) {
            Preconditions.checkNotNull((Object)timeout);
            this.recoveryTimeout = timeout;
            return this;
        }

        public MultiEndpoint build() {
            return new MultiEndpoint(this);
        }
    }
}

