/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.scaler;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.task.TaskTestHelper;
import io.debezium.connector.spanner.task.scaler.TaskScalerUtil;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskScalerUtilTest {
    TaskScalerUtilTest() {
    }

    @Test
    void partitionsInWorkCountTest() {
        List partitions = Stream.of(PartitionStateEnum.values()).map(s -> PartitionState.builder().token(UUID.randomUUID().toString()).state(s).build()).collect(Collectors.toList());
        TaskState task1 = TaskTestHelper.generateTaskStateWithPartitions(partitions.subList(0, 3));
        TaskState task2 = TaskTestHelper.generateTaskStateWithPartitions(partitions.subList(3, partitions.size()));
        long partitionsInWorkCount = TaskScalerUtil.partitionsInWorkCount((TaskSyncEvent)TaskTestHelper.createTaskSyncEvent(task1, task2));
        Assertions.assertThat((long)partitionsInWorkCount).isEqualTo((long)(partitions.size() - 2));
    }

    @Test
    void partitionsInWorkCount_nullSyncEventTest() {
        long partitionsInWorkCount = TaskScalerUtil.partitionsInWorkCount(null);
        Assertions.assertThat((long)partitionsInWorkCount).isZero();
    }

    @Test
    void partitionsInWorkCount_noPartitionsTest() {
        Map<String, TaskState> taskStates = TaskTestHelper.createTaskStateMap(TaskTestHelper.generateTaskStateWithRandomPartitions(0, 0));
        TaskSyncEvent taskSyncEvent = TaskSyncEvent.builder().taskStates(taskStates).build();
        long partitionsInWorkCount = TaskScalerUtil.partitionsInWorkCount((TaskSyncEvent)taskSyncEvent);
        Assertions.assertThat((long)partitionsInWorkCount).isZero();
    }

    @Test
    void tasksCountTest() {
        long tasksCount = TaskScalerUtil.tasksCount((TaskSyncEvent)TaskTestHelper.createTaskSyncEvent(TaskTestHelper.generateTaskStateWithRandomPartitions(0, 0), TaskTestHelper.generateTaskStateWithRandomPartitions(2, 1), TaskTestHelper.generateTaskStateWithRandomPartitions(1, 2)));
        Assertions.assertThat((long)tasksCount).isEqualTo(3L);
    }

    @Test
    void tasksCount_nullSyncEventTest() {
        long tasksCount = TaskScalerUtil.tasksCount(null);
        Assertions.assertThat((long)tasksCount).isZero();
    }

    @Test
    void idlingTaskCount_tasksNoPartitions() {
        TaskState taskNoPartitions1 = TaskTestHelper.generateTaskStateWithRandomPartitions(0, 0);
        TaskState taskNoPartitions2 = TaskTestHelper.generateTaskStateWithRandomPartitions(0, 0);
        long idlingTaskCount = TaskScalerUtil.idlingTaskCount((TaskSyncEvent)TaskTestHelper.createTaskSyncEvent(taskNoPartitions1, taskNoPartitions2));
        Assertions.assertThat((long)idlingTaskCount).isEqualTo(2L);
    }

    @Test
    void idlingTaskCount_tasksOnlyFinishedPartitions() {
        TaskState task1 = TaskTestHelper.generateTaskStateWithPartitions(TaskTestHelper.generatePartitions(2, () -> PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.FINISHED).build()));
        TaskState task2 = TaskTestHelper.generateTaskStateWithPartitions(TaskTestHelper.generatePartitions(3, () -> PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.FINISHED).build()));
        long idlingTaskCount = TaskScalerUtil.idlingTaskCount((TaskSyncEvent)TaskTestHelper.createTaskSyncEvent(task1, task2));
        Assertions.assertThat((long)idlingTaskCount).isEqualTo(2L);
    }

    @Test
    void idlingTaskCount_tasksOnlyRemovedPartitions() {
        TaskState task1 = TaskTestHelper.generateTaskStateWithPartitions(TaskTestHelper.generatePartitions(4, () -> PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.REMOVED).build()));
        TaskState task2 = TaskTestHelper.generateTaskStateWithPartitions(TaskTestHelper.generatePartitions(6, () -> PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.REMOVED).build()));
        long idlingTaskCount = TaskScalerUtil.idlingTaskCount((TaskSyncEvent)TaskTestHelper.createTaskSyncEvent(task1, task2));
        Assertions.assertThat((long)idlingTaskCount).isEqualTo(2L);
    }

    @Test
    void idlingTaskCount_taskInProgressPartitions() {
        TaskState task1 = TaskTestHelper.generateTaskStateWithPartitions(List.of(PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.CREATED).build(), PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.REMOVED).build()));
        TaskState task2 = TaskTestHelper.generateTaskStateWithPartitions(List.of(PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.READY_FOR_STREAMING).build(), PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.FINISHED).build()));
        long idlingTaskCount = TaskScalerUtil.idlingTaskCount((TaskSyncEvent)TaskTestHelper.createTaskSyncEvent(task1, task2));
        Assertions.assertThat((long)idlingTaskCount).isZero();
    }

    @Test
    void idlingTaskCountTest() {
        TaskState task1 = TaskTestHelper.generateTaskStateWithPartitions(List.of(PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.RUNNING).build(), PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.REMOVED).build()));
        TaskState task2 = TaskTestHelper.generateTaskStateWithPartitions(List.of(PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.READY_FOR_STREAMING).build(), PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.CREATED).build()));
        TaskState task3 = TaskTestHelper.generateTaskStateWithPartitions(List.of());
        TaskState task4 = TaskTestHelper.generateTaskStateWithPartitions(List.of(PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.FINISHED).build(), PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.REMOVED).build()));
        TaskState task5 = TaskTestHelper.generateTaskStateWithPartitions(List.of(PartitionState.builder().token(UUID.randomUUID().toString()).state(PartitionStateEnum.REMOVED).build()));
        long idlingTaskCount = TaskScalerUtil.idlingTaskCount((TaskSyncEvent)TaskTestHelper.createTaskSyncEvent(task1, task2, task3, task4, task5));
        Assertions.assertThat((long)idlingTaskCount).isEqualTo(3L);
    }

    @Test
    void idlingTaskCount_nullSyncEventTest() {
        long idlingTaskCount = TaskScalerUtil.idlingTaskCount(null);
        Assertions.assertThat((long)idlingTaskCount).isZero();
    }
}

