/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.processor;

import com.google.cloud.spanner.DatabaseClient;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.config.SpannerTableFilter;
import io.debezium.connector.spanner.context.offset.LowWatermarkProvider;
import io.debezium.connector.spanner.context.source.SourceInfo;
import io.debezium.connector.spanner.context.source.SourceInfoFactory;
import io.debezium.connector.spanner.db.dao.SchemaDao;
import io.debezium.connector.spanner.db.metadata.SchemaRegistry;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.exception.SpannerConnectorException;
import io.debezium.connector.spanner.kafka.KafkaPartitionInfoProvider;
import io.debezium.connector.spanner.processor.SpannerEventDispatcher;
import io.debezium.connector.spanner.processor.metadata.SpannerEventMetadataProvider;
import io.debezium.connector.spanner.schema.KafkaSpannerSchema;
import io.debezium.connector.spanner.schema.KafkaSpannerTableSchemaFactory;
import io.debezium.heartbeat.HeartbeatFactory;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.Sizeable;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.ChangeEventCreator;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.spi.topic.TopicNamingStrategy;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SpannerEventDispatcherTest {
    SpannerEventDispatcherTest() {
    }

    @Test
    void testConstructor() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig = new SpannerConnectorConfig(configuration);
        TopicNamingStrategy topicNamingStrategy = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        Mockito.when((Object)topicNamingStrategy.transactionTopic()).thenReturn((Object)"Transaction Topic");
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class));
        KafkaSpannerSchema kafkaSpannerSchema = new KafkaSpannerSchema(new KafkaSpannerTableSchemaFactory(topicNamingStrategy, schemaNameAdjuster, schemaRegistry, (Schema)new ConnectSchema(Schema.Type.INT8)));
        ChangeEventQueue queue = (ChangeEventQueue)Mockito.mock(ChangeEventQueue.class);
        SpannerTableFilter filter = new SpannerTableFilter(new SpannerConnectorConfig(configuration));
        ChangeEventCreator changeEventCreator = (ChangeEventCreator)Mockito.mock(ChangeEventCreator.class);
        SpannerEventMetadataProvider metadataProvider = new SpannerEventMetadataProvider();
        SpannerConnectorConfig connectorConfig1 = new SpannerConnectorConfig(configuration);
        TopicNamingStrategy topicNamingStrategy2 = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        Mockito.when((Object)topicNamingStrategy2.heartbeatTopic()).thenReturn((Object)"Heartbeat Topic");
        SchemaNameAdjuster schemaNameAdjuster1 = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster1.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        HeartbeatFactory heartbeatFactory = new HeartbeatFactory((CommonConnectorConfig)connectorConfig1, topicNamingStrategy2, schemaNameAdjuster1);
        SchemaNameAdjuster schemaNameAdjuster2 = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster2.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        SchemaRegistry schemaRegistry1 = new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class));
        SourceInfoFactory sourceInfoFactory = new SourceInfoFactory(new SpannerConnectorConfig(configuration), (LowWatermarkProvider)Mockito.mock(LowWatermarkProvider.class));
        SpannerEventDispatcher actualSpannerEventDispatcher = new SpannerEventDispatcher(connectorConfig, topicNamingStrategy, (DatabaseSchema)kafkaSpannerSchema, queue, (DataCollectionFilters.DataCollectionFilter)filter, changeEventCreator, (EventMetadataProvider)metadataProvider, heartbeatFactory, schemaNameAdjuster2, schemaRegistry1, sourceInfoFactory, new KafkaPartitionInfoProvider(null));
        Assertions.assertNull((Object)actualSpannerEventDispatcher.getHistorizedSchema());
        Assertions.assertSame((Object)kafkaSpannerSchema, (Object)actualSpannerEventDispatcher.getSchema());
        ((TopicNamingStrategy)Mockito.verify((Object)topicNamingStrategy)).transactionTopic();
        ((TopicNamingStrategy)Mockito.verify((Object)topicNamingStrategy2)).heartbeatTopic();
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster1, (VerificationMode)Mockito.atLeast((int)1))).adjust((String)Mockito.any());
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster2, (VerificationMode)Mockito.atLeast((int)1))).adjust((String)Mockito.any());
    }

    @Test
    void testPublishLowWatermarkStampEventNoTables() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig = new SpannerConnectorConfig(configuration);
        TopicNamingStrategy topicNamingStrategy = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        Mockito.when((Object)topicNamingStrategy.transactionTopic()).thenReturn((Object)"Transaction Topic");
        Configuration configuration1 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration1.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration1.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration1.asProperties()).thenReturn((Object)new Properties());
        SpannerTableFilter filter = new SpannerTableFilter(new SpannerConnectorConfig(configuration1));
        Configuration configuration2 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration2.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration2.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration2.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig1 = new SpannerConnectorConfig(configuration2);
        TopicNamingStrategy topicNamingStrategy1 = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        Mockito.when((Object)topicNamingStrategy1.heartbeatTopic()).thenReturn((Object)"Heartbeat Topic");
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        HeartbeatFactory heartbeatFactory = new HeartbeatFactory((CommonConnectorConfig)connectorConfig1, topicNamingStrategy1, schemaNameAdjuster);
        SchemaNameAdjuster schemaNameAdjuster1 = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster1.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        Configuration configuration3 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration3.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration3.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration3.asProperties()).thenReturn((Object)new Properties());
        SourceInfoFactory sourceInfoFactory = new SourceInfoFactory(new SpannerConnectorConfig(configuration3), (LowWatermarkProvider)Mockito.mock(LowWatermarkProvider.class));
        TopicNamingStrategy topicNamingStrategy2 = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        SchemaNameAdjuster schemaNameAdjuster2 = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class));
        KafkaSpannerSchema schema = new KafkaSpannerSchema(new KafkaSpannerTableSchemaFactory(topicNamingStrategy2, schemaNameAdjuster2, schemaRegistry, (Schema)new ConnectSchema(Schema.Type.INT8)));
        ChangeEventQueue queue = (ChangeEventQueue)Mockito.mock(ChangeEventQueue.class);
        ChangeEventCreator changeEventCreator = (ChangeEventCreator)Mockito.mock(ChangeEventCreator.class);
        SpannerEventMetadataProvider metadataProvider = new SpannerEventMetadataProvider();
        SchemaRegistry schemaRegistry1 = new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class));
        Assertions.assertThrows(SpannerConnectorException.class, () -> new SpannerEventDispatcher(connectorConfig, topicNamingStrategy, (DatabaseSchema)schema, queue, (DataCollectionFilters.DataCollectionFilter)filter, changeEventCreator, (EventMetadataProvider)metadataProvider, heartbeatFactory, schemaNameAdjuster1, schemaRegistry1, sourceInfoFactory, new KafkaPartitionInfoProvider(null)).publishLowWatermarkStampEvent());
        ((TopicNamingStrategy)Mockito.verify((Object)topicNamingStrategy)).transactionTopic();
        ((TopicNamingStrategy)Mockito.verify((Object)topicNamingStrategy1)).heartbeatTopic();
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster, (VerificationMode)Mockito.atLeast((int)1))).adjust((String)Mockito.any());
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster1, (VerificationMode)Mockito.atLeast((int)1))).adjust((String)Mockito.any());
    }

    @Test
    void testPublishLowWatermarkStampEvent() throws InterruptedException, ExecutionException {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig = new SpannerConnectorConfig(configuration);
        TopicNamingStrategy topicNamingStrategy = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        Mockito.when((Object)topicNamingStrategy.transactionTopic()).thenReturn((Object)"Transaction Topic");
        Mockito.when((Object)topicNamingStrategy.dataChangeTopic((DataCollectionId)((TableId)Mockito.any()))).thenReturn((Object)"Change Topic");
        SpannerTableFilter filter = new SpannerTableFilter(new SpannerConnectorConfig(configuration));
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        HeartbeatFactory heartbeatFactory = new HeartbeatFactory((CommonConnectorConfig)connectorConfig, topicNamingStrategy, schemaNameAdjuster);
        ChangeEventQueue queue = (ChangeEventQueue)Mockito.mock(ChangeEventQueue.class);
        ChangeEventCreator changeEventCreator = (ChangeEventCreator)Mockito.mock(ChangeEventCreator.class);
        SpannerEventMetadataProvider metadataProvider = new SpannerEventMetadataProvider();
        SchemaRegistry schemaRegistry = (SchemaRegistry)Mockito.mock(SchemaRegistry.class);
        TableId tableId = (TableId)Mockito.mock(TableId.class);
        Mockito.when((Object)schemaRegistry.getAllTables()).thenReturn(Set.of(tableId));
        KafkaSpannerSchema schema = (KafkaSpannerSchema)Mockito.mock(KafkaSpannerSchema.class);
        DataCollectionSchema collectionSchema = (DataCollectionSchema)Mockito.mock(DataCollectionSchema.class);
        Mockito.when((Object)schema.schemaFor((TableId)Mockito.any())).thenReturn((Object)collectionSchema);
        SourceInfoFactory sourceInfoFactory = (SourceInfoFactory)Mockito.mock(SourceInfoFactory.class);
        SourceInfo sourceInfo = (SourceInfo)Mockito.mock(SourceInfo.class);
        Mockito.when((Object)sourceInfoFactory.getSourceInfoForLowWatermarkStamp((TableId)Mockito.any())).thenReturn((Object)sourceInfo);
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)sourceInfo.struct()).thenReturn((Object)struct);
        KafkaPartitionInfoProvider kafkaPartitionInfoProvider = (KafkaPartitionInfoProvider)Mockito.mock(KafkaPartitionInfoProvider.class);
        Mockito.when((Object)kafkaPartitionInfoProvider.getPartitions(ArgumentMatchers.anyString(), (Optional)Mockito.any())).thenReturn(List.of(Integer.valueOf(1)));
        SpannerEventDispatcher spannerEventDispatcher = (SpannerEventDispatcher)Mockito.spy((Object)new SpannerEventDispatcher(connectorConfig, topicNamingStrategy, (DatabaseSchema)schema, queue, (DataCollectionFilters.DataCollectionFilter)filter, changeEventCreator, (EventMetadataProvider)metadataProvider, heartbeatFactory, schemaNameAdjuster, schemaRegistry, sourceInfoFactory, kafkaPartitionInfoProvider));
        SourceRecord sourceRecord = (SourceRecord)Mockito.mock(SourceRecord.class);
        ((SpannerEventDispatcher)Mockito.doReturn((Object)sourceRecord).when((Object)spannerEventDispatcher)).emitSourceRecord(ArgumentMatchers.anyString(), (DataCollectionSchema)Mockito.any(), ArgumentMatchers.anyInt(), (Struct)Mockito.any());
        spannerEventDispatcher.publishLowWatermarkStampEvent();
        spannerEventDispatcher.destroy();
        spannerEventDispatcher.close();
        ((TopicNamingStrategy)Mockito.verify((Object)topicNamingStrategy)).dataChangeTopic((DataCollectionId)tableId);
        ((ChangeEventQueue)Mockito.verify((Object)queue)).enqueue((Sizeable)((DataChangeEvent)Mockito.any()));
    }
}

