/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config.validation;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.spanner.config.validation.FieldValidator;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class FieldValidatorTest {
    FieldValidatorTest() {
    }

    private static Stream<Arguments> heartBeatIntervalProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{300001L, 1}), Arguments.of((Object[])new Object[]{300000L, 0}), Arguments.of((Object[])new Object[]{299999L, 0}), Arguments.of((Object[])new Object[]{1001L, 0}), Arguments.of((Object[])new Object[]{1000L, 0}), Arguments.of((Object[])new Object[]{999L, 0}), Arguments.of((Object[])new Object[]{99L, 1}), Arguments.of((Object[])new Object[]{2000L, 0}));
    }

    @ParameterizedTest
    @MethodSource(value={"heartBeatIntervalProvider"})
    void testIsCorrectHeartBeatInterval(Long interval, int expectedResult) {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getLong((Field)Mockito.any())).thenReturn((Object)interval);
        Field.ValidationOutput problems = (Field.ValidationOutput)Mockito.mock(Field.ValidationOutput.class);
        int result = FieldValidator.isCorrectHeartBeatInterval((Configuration)configuration, (Field)Field.create((String)"Name"), (Field.ValidationOutput)problems);
        Assertions.assertEquals((int)expectedResult, (int)result);
    }

    @Test
    void testIsBlank() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"");
        Field.ValidationOutput problems = (Field.ValidationOutput)Mockito.mock(Field.ValidationOutput.class);
        Assertions.assertEquals((int)1, (int)FieldValidator.isNotBlank((Configuration)configuration, (Field)Field.create((String)"Name"), (Field.ValidationOutput)problems));
    }

    @Test
    void testIsNotBlank() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Assertions.assertEquals((int)0, (int)FieldValidator.isNotBlank((Configuration)configuration, (Field)Field.create((String)"Name"), null));
    }

    private static Stream<Arguments> pathProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, 0}), Arguments.of((Object[])new Object[]{"", 1}), Arguments.of((Object[])new Object[]{"path", 1}), Arguments.of((Object[])new Object[]{"/", 1}));
    }

    @ParameterizedTest
    @MethodSource(value={"pathProvider"})
    void testIsCorrectPath(String value, int expected) {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)value);
        Field.ValidationOutput problems = (Field.ValidationOutput)Mockito.mock(Field.ValidationOutput.class);
        Assertions.assertEquals((int)expected, (int)FieldValidator.isCorrectPath((Configuration)configuration, (Field)Field.create((String)"Name"), (Field.ValidationOutput)problems));
    }

    private static Stream<Arguments> jsonProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, 0}), Arguments.of((Object[])new Object[]{"", 1}), Arguments.of((Object[])new Object[]{"42", 0}), Arguments.of((Object[])new Object[]{"[", 1}), Arguments.of((Object[])new Object[]{Boolean.FALSE.toString(), 0}), Arguments.of((Object[])new Object[]{"{}", 0}));
    }

    @ParameterizedTest
    @MethodSource(value={"jsonProvider"})
    void testIsCorrectJson(String value, int expected) {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)value);
        Field.ValidationOutput problems = (Field.ValidationOutput)Mockito.mock(Field.ValidationOutput.class);
        Assertions.assertEquals((int)expected, (int)FieldValidator.isCorrectJson((Configuration)configuration, (Field)Field.create((String)"Name"), (Field.ValidationOutput)problems));
    }

    private static Stream<Arguments> valueCaptureModeProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, 0}), Arguments.of((Object[])new Object[]{"OLD_AND_NEW_VALUES", 0}), Arguments.of((Object[])new Object[]{"NEW_VALUES", 1}));
    }

    @ParameterizedTest
    @MethodSource(value={"valueCaptureModeProvider"})
    void testIsCorrectCaptureMode(String value, int expected) {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)value);
        Field.ValidationOutput problems = (Field.ValidationOutput)Mockito.mock(Field.ValidationOutput.class);
        Assertions.assertEquals((int)expected, (int)FieldValidator.isCorrectCaptureMode((Configuration)configuration, (Field)Field.create((String)"Name"), (Field.ValidationOutput)problems));
    }

    private static Stream<Arguments> dateTimeProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, 0}), Arguments.of((Object[])new Object[]{"", 1}), Arguments.of((Object[])new Object[]{"2022-10-17T19:15:48.622378", 1}), Arguments.of((Object[])new Object[]{"2022-10-18T17:17:39.257409Z", 0}), Arguments.of((Object[])new Object[]{"[]", 1}));
    }

    @ParameterizedTest
    @MethodSource(value={"dateTimeProvider"})
    void testIsCorrectDateTime(String value, int expected) {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)value);
        Field.ValidationOutput problems = (Field.ValidationOutput)Mockito.mock(Field.ValidationOutput.class);
        Assertions.assertEquals((int)expected, (int)FieldValidator.isCorrectDateTime((Configuration)configuration, (Field)Field.create((String)"Name"), (Field.ValidationOutput)problems));
    }

    @Test
    void testIsSpecified() {
        Assertions.assertTrue((boolean)FieldValidator.isSpecified((String)"42"));
        Assertions.assertFalse((boolean)FieldValidator.isSpecified((String)""));
    }
}

