/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.util;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import io.debezium.connector.spanner.db.dao.SchemaDao;
import io.debezium.connector.spanner.util.Database;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static final Logger LOG = LoggerFactory.getLogger(Connection.class);
    private final String projectId;
    private final String instanceId;
    private final String databaseId;
    public static final String emulatorHost = "http://localhost:9010";
    public DatabaseClient databaseClient;
    private Spanner spanner;
    private SchemaDao schemaDao;
    private final Dialect dialect;

    protected Connection(Database database) {
        this.projectId = database.getProjectId();
        this.instanceId = database.getInstanceId();
        this.databaseId = database.getDatabaseId();
        this.dialect = database.getDialect();
    }

    public ResultSet executeSelect(String query) {
        return this.databaseClient.singleUse().executeQuery(Statement.of((String)query), new Options.QueryOption[0]);
    }

    public ResultSet executeSelect(Statement statement) {
        return this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);
    }

    public Long executeUpdate(String query) {
        String msg = "Execution result: {}, query: {}";
        return (Long)this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            String uuid = UUID.randomUUID().toString();
            LOG.info("Begin transaction {}", (Object)uuid);
            long res = transaction.executeUpdate(Statement.of((String)query), new Options.UpdateOption[0]);
            if (res > 0L) {
                LOG.info("Execution result: {}, query: {}", (Object)res, (Object)query);
            } else {
                LOG.warn("Execution result: {}, query: {}", (Object)res, (Object)query);
            }
            return res;
        });
    }

    public Long executeUpdate(List<String> queries) {
        String msg = "Execution result: {}, query: {}";
        return (Long)this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            String uuid = UUID.randomUUID().toString();
            LOG.info("Begin transaction {}", (Object)uuid);
            long result = 0L;
            for (String query : queries) {
                long res = transaction.executeUpdate(Statement.of((String)query), new Options.UpdateOption[0]);
                result += res;
                if (res > 0L) {
                    LOG.info("Execution result: {}, query: {}", (Object)res, (Object)query);
                    continue;
                }
                LOG.warn("Execution result: {}, query: {}", (Object)res, (Object)query);
            }
            LOG.info("End transaction {}, result : {}", (Object)uuid, (Object)result);
            return result;
        });
    }

    public void updateDDL(Iterable<String> updates) throws ExecutionException, InterruptedException {
        OperationFuture future = this.spanner.getDatabaseAdminClient().updateDatabaseDdl(this.instanceId, this.databaseId, updates, null);
        future.get();
    }

    public void createTable(String tableDefinition) throws ExecutionException, InterruptedException {
        this.updateDDL(List.of("create table " + tableDefinition));
    }

    public void createChangeStream(String changeStreamName, String ... tables) throws ExecutionException, InterruptedException {
        this.updateDDL(List.of("create change stream " + changeStreamName + " for " + (tables.length == 0 ? "ALL" : String.join((CharSequence)",", tables))));
        Awaitility.await().atMost(Duration.ofSeconds(60L)).until(() -> this.isStreamExist(changeStreamName));
    }

    public void createChangeStreamNewValue(String changeStreamName, String ... tables) throws ExecutionException, InterruptedException {
        this.updateDDL(List.of("create change stream " + changeStreamName + " for " + (tables.length == 0 ? "ALL" : String.join((CharSequence)",", tables)) + " OPTIONS (\n            value_capture_type = 'NEW_VALUES'\n        ) "));
        Awaitility.await().atMost(Duration.ofSeconds(60L)).until(() -> this.isStreamExist(changeStreamName));
    }

    public void createChangeStreamNewRow(String changeStreamName, String ... tables) throws ExecutionException, InterruptedException {
        this.updateDDL(List.of("create change stream " + changeStreamName + " for " + (tables.length == 0 ? "ALL" : String.join((CharSequence)",", tables)) + " OPTIONS (\n            value_capture_type = 'NEW_ROW'\n        ) "));
        Awaitility.await().atMost(Duration.ofSeconds(60L)).until(() -> this.isStreamExist(changeStreamName));
    }

    private String createInstance() {
        for (Instance value : this.spanner.getInstanceAdminClient().listInstances(new Options.ListOption[0]).iterateAll()) {
            if (!value.getId().getInstance().equals("test-instance")) continue;
            return "test-instance";
        }
        String configId = "regional-us-central1";
        String displayName = "For IT";
        int nodeCount = 1;
        InstanceInfo instanceInfo = InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)this.projectId, (String)"test-instance")).setInstanceConfigId(InstanceConfigId.of((String)this.projectId, (String)configId)).setNodeCount(nodeCount).setDisplayName(displayName).build();
        OperationFuture instance = this.spanner.getInstanceAdminClient().createInstance(instanceInfo);
        try {
            instance.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return "test-instance";
    }

    private boolean isStreamExist(String streamName) {
        Statement statement = this.schemaDao.isPostgres() ? ((Statement.Builder)Statement.newBuilder((String)"select change_stream_name from information_schema.change_streams cs where cs.change_stream_name = $1").bind("p1").to(streamName.toLowerCase())).build() : ((Statement.Builder)Statement.newBuilder((String)"select change_stream_name from information_schema.change_streams cs where cs.change_stream_name = @streamname").bind("streamName").to(streamName)).build();
        return this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]).next();
    }

    public boolean dropTable(String tableName) throws InterruptedException {
        try {
            if (!this.isTableExist(tableName)) {
                return false;
            }
            this.updateDDL(List.of("drop table " + tableName));
        }
        catch (ExecutionException ex) {
            LOG.warn("Can`t drop table", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean dropChangeStream(String changeStreamName) throws InterruptedException {
        try {
            if (!this.isChangeStreamExist(changeStreamName)) {
                return false;
            }
            this.updateDDL(List.of("drop change stream " + changeStreamName));
        }
        catch (ExecutionException ex) {
            LOG.warn("Can`t delete change stream", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean isChangeStreamExist(String changeStreamName) {
        Statement statement = this.schemaDao.isPostgres() ? ((Statement.Builder)Statement.newBuilder((String)"select * from information_schema.change_streams where change_stream_name = $1").bind("p1").to(changeStreamName)).build() : ((Statement.Builder)Statement.newBuilder((String)"select * from information_schema.change_streams where change_stream_name = @streamName").bind("streamName").to(changeStreamName)).build();
        try (ResultSet resultSet = this.executeSelect(statement);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    public boolean isTableExist(String tableName) {
        Statement statement = this.schemaDao.isPostgres() ? ((Statement.Builder)Statement.newBuilder((String)"select * from information_schema.tables where table_schema = '' and table_catalog = '' and table_name = $1").bind("p1").to(tableName)).build() : ((Statement.Builder)Statement.newBuilder((String)"select * from information_schema.tables where table_schema = '' and table_catalog = '' and table_name = @tableName").bind("tableName").to(tableName)).build();
        try (ResultSet resultSet = this.executeSelect(statement);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    public boolean isDatabaseExist(String databaseId) {
        try {
            return this.spanner.getDatabaseAdminClient().getDatabase(this.instanceId, databaseId) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void dropDatabase(String databaseId) {
        this.spanner.getDatabaseAdminClient().dropDatabase(this.instanceId, databaseId);
        LOG.info("{} database has been dropped", (Object)databaseId);
    }

    public void createDatabase(String databaseId, Dialect dialect) throws InterruptedException {
        this.createInstance();
        DatabaseAdminClient dbAdminClient = this.spanner.getDatabaseAdminClient();
        OperationFuture operationFuture = dbAdminClient.createDatabase(dbAdminClient.newDatabaseBuilder(DatabaseId.of((String)this.projectId, (String)this.instanceId, (String)databaseId)).setDialect(dialect).build(), Collections.emptyList());
        try {
            operationFuture.get();
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Failed to create database", ex);
        }
        LOG.info("{} database has been created", (Object)databaseId);
    }

    public Connection connect(Dialect dialect) throws InterruptedException {
        if (this.databaseClient != null) {
            return this;
        }
        this.init();
        if (this.isDatabaseExist(this.databaseId)) {
            this.dropDatabase(this.databaseId);
        }
        this.createDatabase(this.databaseId, dialect);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.dropDatabase(this.databaseId)));
        this.databaseClient = this.spanner.getDatabaseClient(DatabaseId.of((String)this.projectId, (String)this.instanceId, (String)this.databaseId));
        this.schemaDao = new SchemaDao(this.databaseClient);
        return this;
    }

    private void init() {
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        builder.setCredentials((Credentials)NoCredentials.getInstance());
        builder.setProjectId(this.projectId);
        builder.setEmulatorHost(emulatorHost);
        SpannerOptions options = builder.build();
        try {
            this.spanner = (Spanner)options.getService();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

