/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.spanner.DatabaseClient;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.db.DatabaseClientFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class DatabaseClientFactoryTest {
    DatabaseClientFactoryTest() {
    }

    @Test
    void testConstructor() {
        SpannerConnectorConfig spannerConnectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        Mockito.when((Object)spannerConnectorConfig.databaseId()).thenReturn((Object)"42");
        Mockito.when((Object)spannerConnectorConfig.gcpSpannerCredentialsJson()).thenReturn((Object)"Gcp Spanner Credentials Json");
        Mockito.when((Object)spannerConnectorConfig.gcpSpannerCredentialsPath()).thenReturn((Object)"Gcp Spanner Credentials Path");
        Mockito.when((Object)spannerConnectorConfig.instanceId()).thenReturn((Object)"42");
        Mockito.when((Object)spannerConnectorConfig.projectId()).thenReturn((Object)"myproject");
        DatabaseClientFactory databaseClientFactory = new DatabaseClientFactory(spannerConnectorConfig);
        ((SpannerConnectorConfig)Mockito.verify((Object)spannerConnectorConfig)).databaseId();
        ((SpannerConnectorConfig)Mockito.verify((Object)spannerConnectorConfig)).gcpSpannerCredentialsJson();
        ((SpannerConnectorConfig)Mockito.verify((Object)spannerConnectorConfig)).gcpSpannerCredentialsPath();
        ((SpannerConnectorConfig)Mockito.verify((Object)spannerConnectorConfig)).instanceId();
        ((SpannerConnectorConfig)Mockito.verify((Object)spannerConnectorConfig)).projectId();
        databaseClientFactory.closeSpanner();
    }

    @Test
    void testGetGoogleCredentials() {
        try (MockedStatic credentials = Mockito.mockStatic(GoogleCredentials.class);){
            DatabaseClientFactory databaseClientFactory1 = new DatabaseClientFactory("myproject", "42", "42", "Credentials Json", "Credentials Path", null, null, "test-role");
            Assertions.assertNull((Object)databaseClientFactory1.getGoogleCredentials("Credentials Json", "Credentials Path"));
            databaseClientFactory1.closeSpanner();
            DatabaseClientFactory databaseClientFactory2 = new DatabaseClientFactory("myproject", "42", "42", "Credentials Json", "Credentials Path", null, null, "test-role");
            Assertions.assertNull((Object)databaseClientFactory2.getGoogleCredentials(null, null));
            databaseClientFactory2.closeSpanner();
            DatabaseClientFactory databaseClientFactory3 = new DatabaseClientFactory("myproject", "42", "42", "Credentials Json", "Credentials Path", null, null, "test-role");
            Assertions.assertNull((Object)databaseClientFactory3.getGoogleCredentials(null, "Credentials Path"));
            databaseClientFactory3.closeSpanner();
            DatabaseClientFactory databaseClientFactory4 = new DatabaseClientFactory("myproject", "42", "42", "Credentials Json", null, null, null, null);
            Assertions.assertNull((Object)databaseClientFactory4.getGoogleCredentials(null, null));
            databaseClientFactory4.closeSpanner();
        }
    }

    @Test
    void testGetDatabaseClient() {
        DatabaseClientFactory databaseClientFactory = new DatabaseClientFactory("myproject", "42", "42", "Credentials Json", "Credentials Path", null, null, "test-role");
        DatabaseClient actualDatabaseClient = databaseClientFactory.getDatabaseClient();
        Assertions.assertNotNull((Object)actualDatabaseClient);
        databaseClientFactory.closeSpanner();
    }
}

