/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config.validation;

import io.debezium.config.Configuration;
import io.debezium.connector.spanner.config.validation.ConfigurationValidator;
import io.debezium.connector.spanner.config.validation.StartEndTimeValidator;
import java.time.Instant;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class StartEndTimeValidatorTest {
    StartEndTimeValidatorTest() {
    }

    private static Stream<Arguments> configProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{Configuration.from(Map.of("gcp.spanner.start.time", Instant.ofEpochMilli(Instant.now().toEpochMilli() - 10000L).toString(), "gcp.spanner.end.time", Instant.ofEpochMilli(Instant.now().toEpochMilli() + 10000L).toString())), true}), Arguments.of((Object[])new Object[]{Configuration.from(Map.of()), true}), Arguments.of((Object[])new Object[]{Configuration.from(Map.of("gcp.spanner.start.time", Instant.ofEpochMilli(Instant.now().toEpochMilli() + 100001L).toString(), "gcp.spanner.end.time", Instant.ofEpochMilli(Instant.now().toEpochMilli() + 10000L).toString())), false}));
    }

    @ParameterizedTest
    @MethodSource(value={"configProvider"})
    void validate(Configuration configuration, boolean isSuccess) {
        Map<String, ConfigValue> configValueMap = Map.of("gcp.spanner.start.time", new ConfigValue("gcp.spanner.start.time"), "gcp.spanner.end.time", new ConfigValue("gcp.spanner.end.time"));
        ConfigurationValidator.ValidationContext validationContext = new ConfigurationValidator.ValidationContext(configuration, configValueMap);
        StartEndTimeValidator startEndTimeValidator = StartEndTimeValidator.withContext((ConfigurationValidator.ValidationContext)validationContext);
        startEndTimeValidator.validate();
        Assertions.assertEquals((Object)isSuccess, (Object)startEndTimeValidator.isSuccess());
    }
}

