/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config.validation;

import com.google.auth.oauth2.GoogleCredentials;
import io.debezium.config.Configuration;
import io.debezium.connector.spanner.config.validation.ConfigurationValidator;
import io.debezium.connector.spanner.config.validation.ConnectionValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class ConnectionValidatorTest {
    ConnectionValidatorTest() {
    }

    private static Stream<Arguments> configProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{Configuration.from(Map.of("gcp.spanner.project.id", "boxwood-weaver-353315", "gcp.spanner.instance.id", "kafka-connector", "gcp.spanner.database.id", "kafkaspan", "gcp.spanner.credentials.path", "/path/to/credential"))}), Arguments.of((Object[])new Object[]{Configuration.from(Map.of("gcp.spanner.project.id", "boxwood-weaver-353315", "gcp.spanner.instance.id", "kafka-connector", "gcp.spanner.database.id", "kafkaspan", "gcp.spanner.credentials.json", "{}"))}), Arguments.of((Object[])new Object[]{Configuration.from(Map.of("gcp.spanner.project.id", "boxwood-weaver-353315", "gcp.spanner.instance.id", "kafka-connector", "gcp.spanner.database.id", "kafkaspan"))}));
    }

    @ParameterizedTest
    @MethodSource(value={"configProvider"})
    void validateSuccess(Configuration configuration) {
        try (MockedStatic credentials = Mockito.mockStatic(GoogleCredentials.class);){
            credentials.when(GoogleCredentials::getApplicationDefault).thenReturn(null);
            Map<String, ConfigValue> configValueMap = Map.of("gcp.spanner.project.id", new ConfigValue("gcp.spanner.project.id"), "gcp.spanner.instance.id", new ConfigValue("gcp.spanner.instance.id"), "gcp.spanner.database.id", new ConfigValue("gcp.spanner.database.id"), "gcp.spanner.credentials.json", new ConfigValue("gcp.spanner.credentials.json"), "gcp.spanner.credentials.path", new ConfigValue("gcp.spanner.credentials.path"));
            ConfigurationValidator.ValidationContext validationContext = new ConfigurationValidator.ValidationContext(configuration, configValueMap);
            ConnectionValidator connectionValidator = (ConnectionValidator)Mockito.spy((Object)ConnectionValidator.withContext((ConfigurationValidator.ValidationContext)validationContext));
            Assertions.assertTrue((boolean)connectionValidator.isSuccess());
            connectionValidator.validate();
            Assertions.assertTrue((boolean)connectionValidator.isSuccess());
        }
    }

    @Test
    void validateNotSuccess() {
        Configuration configuration = Configuration.from(Map.of("gcp.spanner.project.id", "boxwood-weaver-353315", "gcp.spanner.instance.id", "kafka-connector", "gcp.spanner.database.id", "kafkaspan"));
        try (MockedStatic credentials = Mockito.mockStatic(GoogleCredentials.class);){
            credentials.when(GoogleCredentials::getApplicationDefault).thenThrow(new Throwable[]{new IOException()});
            Map<String, ConfigValue> configValueMap = Map.of("gcp.spanner.project.id", new ConfigValue("gcp.spanner.project.id"), "gcp.spanner.instance.id", new ConfigValue("gcp.spanner.instance.id"), "gcp.spanner.database.id", new ConfigValue("gcp.spanner.database.id"), "gcp.spanner.credentials.json", new ConfigValue("gcp.spanner.credentials.json"), "gcp.spanner.credentials.path", new ConfigValue("gcp.spanner.credentials.path"));
            ConfigurationValidator.ValidationContext validationContext = new ConfigurationValidator.ValidationContext(configuration, configValueMap);
            ConnectionValidator connectionValidator = (ConnectionValidator)Mockito.spy((Object)ConnectionValidator.withContext((ConfigurationValidator.ValidationContext)validationContext));
            Assertions.assertTrue((boolean)connectionValidator.isSuccess());
            connectionValidator.validate();
            Assertions.assertFalse((boolean)connectionValidator.isSuccess());
        }
    }

    @Test
    void validateSuccessAgainstEmulator() {
        Configuration configuration = Configuration.from(Map.of("gcp.spanner.project.id", "boxwood-weaver-353315", "gcp.spanner.instance.id", "kafka-connector", "gcp.spanner.database.id", "kafkaspan", "gcp.spanner.emulator.host", "http://localhost:9010"));
        Map<String, ConfigValue> configValueMap = Map.of("gcp.spanner.project.id", new ConfigValue("gcp.spanner.project.id", (Object)"boxwood-weaver-353315", new ArrayList(), new ArrayList()), "gcp.spanner.instance.id", new ConfigValue("gcp.spanner.instance.id", (Object)"kafka-connector", new ArrayList(), new ArrayList()), "gcp.spanner.database.id", new ConfigValue("gcp.spanner.database.id", (Object)"kafkaspan", new ArrayList(), new ArrayList()), "gcp.spanner.emulator.host", new ConfigValue("gcp.spanner.emulator.host", (Object)"http://localhost:9010", new ArrayList(), new ArrayList()));
        ConfigurationValidator.ValidationContext validationContext = new ConfigurationValidator.ValidationContext(configuration, configValueMap);
        ConnectionValidator connectionValidator = (ConnectionValidator)Mockito.spy((Object)ConnectionValidator.withContext((ConfigurationValidator.ValidationContext)validationContext));
        connectionValidator.validate();
        Assertions.assertEquals((Object)true, (Object)connectionValidator.isSuccess());
    }

    @Test
    void validateFailForConflictingHosts() {
        Configuration configuration = Configuration.from(Map.of("gcp.spanner.project.id", "boxwood-weaver-353315", "gcp.spanner.instance.id", "kafka-connector", "gcp.spanner.credentials.path", "no_path", "gcp.spanner.database.id", "kafkaspan", "gcp.spanner.host", "http://localhost:9010", "gcp.spanner.emulator.host", "http://localhost:9010"));
        Map<String, ConfigValue> configValueMap = Map.of("gcp.spanner.project.id", new ConfigValue("gcp.spanner.project.id", (Object)"boxwood-weaver-353315", new ArrayList(), new ArrayList()), "gcp.spanner.instance.id", new ConfigValue("gcp.spanner.instance.id", (Object)"kafka-connector", new ArrayList(), new ArrayList()), "gcp.spanner.database.id", new ConfigValue("gcp.spanner.database.id", (Object)"kafkaspan", new ArrayList(), new ArrayList()), "gcp.spanner.credentials.path", new ConfigValue("gcp.spanner.credentials.json", (Object)"{}", new ArrayList(), new ArrayList()), "gcp.spanner.credentials.json", new ConfigValue("gcp.spanner.credentials.json", (Object)"{}", new ArrayList(), new ArrayList()), "gcp.spanner.host", new ConfigValue("gcp.spanner.host", (Object)"http://localhost:9010", new ArrayList(), new ArrayList()), "gcp.spanner.emulator.host", new ConfigValue("gcp.spanner.emulator.host", (Object)"http://localhost:9010", new ArrayList(), new ArrayList()));
        ConfigurationValidator.ValidationContext validationContext = new ConfigurationValidator.ValidationContext(configuration, configValueMap);
        ConnectionValidator connectionValidator = (ConnectionValidator)Mockito.spy((Object)ConnectionValidator.withContext((ConfigurationValidator.ValidationContext)validationContext));
        connectionValidator.validate();
        Assertions.assertEquals((Object)false, (Object)connectionValidator.isSuccess());
    }
}

