/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db;

import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.annotations.VisibleForTesting;
import io.debezium.connector.spanner.Module;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseClientFactory.class);
    private static final String USER_AGENT_PREFIX = "kafka-change-streams-connector-";
    private final String projectId;
    private final String instanceId;
    private final String databaseId;
    private final SpannerOptions options;
    private volatile Spanner spanner;
    private DatabaseClient databaseClient;

    public DatabaseClientFactory(String projectId, String instanceId, String databaseId, String credentialsJson, String credentialsPath, String host, String emulatorHost, String databaseRole) {
        this.projectId = projectId;
        this.instanceId = instanceId;
        this.databaseId = databaseId;
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        GoogleCredentials googleCredentials = this.getGoogleCredentials(credentialsJson, credentialsPath);
        builder.setProjectId(this.projectId);
        if (!Strings.isNullOrEmpty((String)host)) {
            builder.setHost(host);
        }
        if (!Strings.isNullOrEmpty((String)emulatorHost)) {
            builder.setEmulatorHost(emulatorHost);
            builder.setCredentials((Credentials)NoCredentials.getInstance());
        } else if (googleCredentials != null) {
            builder.setCredentials((Credentials)googleCredentials);
        }
        if (!Strings.isNullOrEmpty((String)databaseRole)) {
            builder.setDatabaseRole(databaseRole);
        }
        String userAgentString = USER_AGENT_PREFIX + Module.version();
        builder.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{"user-agent", userAgentString}));
        this.options = builder.build();
        this.spanner = (Spanner)this.options.getService();
    }

    public DatabaseClientFactory(SpannerConnectorConfig config) {
        this(config.projectId(), config.instanceId(), config.databaseId(), config.gcpSpannerCredentialsJson(), config.gcpSpannerCredentialsPath(), config.spannerHost(), config.spannerEmulatorHost(), config.databaseRole());
    }

    @VisibleForTesting
    GoogleCredentials getGoogleCredentials(String credentialsJson, String credentialsPath) {
        GoogleCredentials credential = null;
        if (credentialsJson != null) {
            try {
                credential = GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(credentialsJson.getBytes()));
            }
            catch (IOException ex) {
                LOGGER.error("Error read GOOGLE CREDENTIALS from params {}", (Object)credentialsJson);
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        } else if (credentialsPath != null) {
            try {
                credential = GoogleCredentials.fromStream((InputStream)new FileInputStream(credentialsPath));
            }
            catch (IOException e) {
                LOGGER.error("Error read GOOGLE CREDENTIALS from path {}", (Object)credentialsPath);
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                credential = ServiceAccountCredentials.getApplicationDefault();
            }
            catch (IOException e) {
                LOGGER.error("The Application Default Credentials are not available.");
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return credential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSpanner() {
        DatabaseClientFactory databaseClientFactory = this;
        synchronized (databaseClientFactory) {
            if (this.spanner == null) {
                return;
            }
            try {
                this.spanner.close();
            }
            catch (Exception e) {
                LOGGER.error("Exception during spanner.close()", (Throwable)e);
            }
            this.spanner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseClient getDatabaseClient() {
        DatabaseClientFactory databaseClientFactory = this;
        synchronized (databaseClientFactory) {
            if (this.spanner == null) {
                return null;
            }
            if (this.databaseClient == null) {
                this.databaseClient = this.spanner.getDatabaseClient(DatabaseId.of((String)this.projectId, (String)this.instanceId, (String)this.databaseId));
            }
        }
        return this.databaseClient;
    }
}

