/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.encryption;

import com.google.cloud.spanner.encryption.BackupEncryptionConfig;
import com.google.cloud.spanner.encryption.RestoreEncryptionConfig;
import com.google.spanner.admin.database.v1.EncryptionConfig;
import java.util.Objects;

public class CustomerManagedEncryption
implements BackupEncryptionConfig,
RestoreEncryptionConfig {
    private final String kmsKeyName;

    CustomerManagedEncryption(String kmsKeyName) {
        this.kmsKeyName = kmsKeyName;
    }

    public String getKmsKeyName() {
        return this.kmsKeyName;
    }

    public static CustomerManagedEncryption fromProtoOrNull(EncryptionConfig proto) {
        return proto.equals((Object)EncryptionConfig.getDefaultInstance()) ? null : new CustomerManagedEncryption(proto.getKmsKeyName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerManagedEncryption that = (CustomerManagedEncryption)o;
        return Objects.equals(this.kmsKeyName, that.kmsKeyName);
    }

    public int hashCode() {
        return Objects.hash(this.kmsKeyName);
    }

    public String toString() {
        return "CustomerManagedEncryption{kmsKeyName='" + this.kmsKeyName + '\'' + '}';
    }
}

