/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics;

import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.metrics.event.MetricEvent;
import io.debezium.connector.spanner.metrics.event.NewQueueMetricEvent;
import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class MetricsEventPublisherTest {
    MetricsEventPublisherTest() {
    }

    @Test
    void testPublishMetricEvent() {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.spy((Object)new MetricsEventPublisher());
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        metricsEventPublisher.subscribe(NewQueueMetricEvent.class, consumer);
        metricsEventPublisher.publishMetricEvent((MetricEvent)new NewQueueMetricEvent());
        ((Consumer)Mockito.verify((Object)consumer)).accept((NewQueueMetricEvent)ArgumentMatchers.any());
    }

    @Test
    void testSubscribe() {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.spy((Object)new MetricsEventPublisher());
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        metricsEventPublisher.subscribe(NewQueueMetricEvent.class, consumer);
        Assertions.assertThrows(IllegalStateException.class, () -> metricsEventPublisher.subscribe(NewQueueMetricEvent.class, consumer));
    }

    @Test
    void testLogLatency() {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.spy((Object)new MetricsEventPublisher());
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Schema schema = (Schema)Mockito.mock(Schema.class);
        Field field = (Field)Mockito.mock(Field.class);
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Header header = (Header)Mockito.mock(Header.class);
        Header headerUid = (Header)Mockito.mock(Header.class);
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        ((SourceRecord)Mockito.doReturn((Object)struct).when((Object)sourceRecord)).value();
        ((SourceRecord)Mockito.doReturn((Object)headers).when((Object)sourceRecord)).headers();
        ((Headers)Mockito.doReturn((Object)header).when((Object)headers)).lastWithName(ArgumentMatchers.anyString());
        ((Header)Mockito.doReturn((Object)1001L).when((Object)header)).value();
        ((Struct)Mockito.doReturn((Object)schema).when((Object)struct)).schema();
        ((Schema)Mockito.doReturn((Object)field).when((Object)schema)).field(ArgumentMatchers.anyString());
        ((Struct)Mockito.doReturn((Object)struct).when((Object)struct)).getStruct(ArgumentMatchers.anyString());
        ((Headers)Mockito.doReturn((Object)headerUid).when((Object)headers)).lastWithName("spannerDataChangeRecordUid");
        ((Header)Mockito.doReturn((Object)"spannerDataChangeRecordUid").when((Object)headerUid)).value();
        metricsEventPublisher.logLatency(sourceRecord);
        ((MetricsEventPublisher)Mockito.verify((Object)metricsEventPublisher, (VerificationMode)Mockito.times((int)1))).publishMetricEvent((MetricEvent)ArgumentMatchers.any());
    }

    @Test
    void testLogLatencySourceRecordNull() {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.spy((Object)new MetricsEventPublisher());
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        SourceRecord sourceRecord = new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value");
        metricsEventPublisher.logLatency(sourceRecord);
        ((MetricsEventPublisher)Mockito.verify((Object)metricsEventPublisher, (VerificationMode)Mockito.times((int)0))).publishMetricEvent((MetricEvent)ArgumentMatchers.any());
    }

    @Test
    void testLogLatencySourceRecord() {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.spy((Object)new MetricsEventPublisher());
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        ConnectSchema schema = new ConnectSchema(Schema.Type.INT8);
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)schema, (Object)"Value"));
        Headers headers = (Headers)Mockito.mock(Headers.class);
        ((SourceRecord)Mockito.doReturn((Object)headers).when((Object)sourceRecord)).headers();
        metricsEventPublisher.logLatency(sourceRecord);
        ((MetricsEventPublisher)Mockito.verify((Object)metricsEventPublisher, (VerificationMode)Mockito.times((int)0))).publishMetricEvent((MetricEvent)ArgumentMatchers.any());
    }

    @Test
    void testNotLogLatency() {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.spy((Object)new MetricsEventPublisher());
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        SourceRecord sourceRecord = (SourceRecord)Mockito.spy((Object)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"));
        Headers headers = (Headers)Mockito.mock(Headers.class);
        Mockito.when((Object)sourceRecord.headers()).thenReturn((Object)headers);
        Mockito.when((Object)headers.lastWithName(ArgumentMatchers.anyString())).thenReturn(null);
        metricsEventPublisher.logLatency(sourceRecord);
        ((MetricsEventPublisher)Mockito.verify((Object)metricsEventPublisher, (VerificationMode)Mockito.times((int)0))).publishMetricEvent((MetricEvent)ArgumentMatchers.any());
    }
}

